/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.internal.hppc;

import guideme.internal.shaded.lucene.internal.hppc.AbstractIterator;
import guideme.internal.shaded.lucene.internal.hppc.BitMixer;
import guideme.internal.shaded.lucene.internal.hppc.LongCursor;
import guideme.internal.shaded.lucene.util.Accountable;
import guideme.internal.shaded.lucene.util.ArrayUtil;
import guideme.internal.shaded.lucene.util.RamUsageEstimator;
import java.util.Arrays;
import java.util.Iterator;
import java.util.stream.LongStream;

public class LongArrayList
implements Accountable,
Cloneable,
Iterable<LongCursor> {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(LongArrayList.class);
    public static final long[] EMPTY_ARRAY = new long[0];
    public long[] buffer;
    public int elementsCount;

    public LongArrayList() {
        this(4);
    }

    public LongArrayList(int expectedElements) {
        this.buffer = new long[expectedElements];
    }

    public void add(long e1) {
        this.ensureBufferSpace(1);
        this.buffer[this.elementsCount++] = e1;
    }

    public void add(long[] elements, int start, int length) {
        assert (length >= 0) : "Length must be >= 0";
        this.ensureBufferSpace(length);
        System.arraycopy(elements, start, this.buffer, this.elementsCount, length);
        this.elementsCount += length;
    }

    public final void add(long ... elements) {
        this.add(elements, 0, elements.length);
    }

    public long get(int index) {
        assert (index >= 0 && index < this.size()) : "Index " + index + " out of bounds [0, " + this.size() + ").";
        return this.buffer[index];
    }

    public boolean contains(long e1) {
        return this.indexOf(e1) >= 0;
    }

    public int indexOf(long e1) {
        for (int i = 0; i < this.elementsCount; ++i) {
            if (e1 != this.buffer[i]) continue;
            return i;
        }
        return -1;
    }

    protected void ensureBufferSpace(int expectedAdditions) {
        if (this.elementsCount + expectedAdditions > this.buffer.length) {
            this.buffer = ArrayUtil.grow(this.buffer, this.elementsCount + expectedAdditions);
        }
    }

    public int size() {
        return this.elementsCount;
    }

    public long[] toArray() {
        return ArrayUtil.copyOfSubArray(this.buffer, 0, this.elementsCount);
    }

    public LongArrayList clone() {
        try {
            LongArrayList cloned = (LongArrayList)super.clone();
            cloned.buffer = (long[])this.buffer.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public int hashCode() {
        int h = 1;
        int max = this.elementsCount;
        for (int i = 0; i < max; ++i) {
            h = 31 * h + BitMixer.mix(this.buffer[i]);
        }
        return h;
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && this.getClass() == obj.getClass() && this.equalElements((LongArrayList)this.getClass().cast(obj));
    }

    protected boolean equalElements(LongArrayList other) {
        int max = this.size();
        if (other.size() != max) {
            return false;
        }
        for (int i = 0; i < max; ++i) {
            if (this.get(i) == other.get(i)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf(this.buffer);
    }

    public LongStream stream() {
        return Arrays.stream(this.buffer, 0, this.size());
    }

    @Override
    public Iterator<LongCursor> iterator() {
        return new ValueIterator(this.buffer, this.size());
    }

    public static LongArrayList from(long ... elements) {
        LongArrayList list = new LongArrayList(elements.length);
        list.add(elements);
        return list;
    }

    static final class ValueIterator
    extends AbstractIterator<LongCursor> {
        private final LongCursor cursor = new LongCursor();
        private final long[] buffer;
        private final int size;

        public ValueIterator(long[] buffer, int size) {
            this.cursor.index = -1;
            this.size = size;
            this.buffer = buffer;
        }

        @Override
        protected LongCursor fetch() {
            if (this.cursor.index + 1 == this.size) {
                return (LongCursor)this.done();
            }
            this.cursor.value = this.buffer[++this.cursor.index];
            return this.cursor;
        }
    }
}

