/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.analysis.tr;

import guideme.internal.shaded.lucene.analysis.TokenFilter;
import guideme.internal.shaded.lucene.analysis.TokenStream;
import guideme.internal.shaded.lucene.analysis.tokenattributes.CharTermAttribute;
import java.io.IOException;

public final class TurkishLowerCaseFilter
extends TokenFilter {
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);

    public TurkishLowerCaseFilter(TokenStream in) {
        super(in);
    }

    @Override
    public final boolean incrementToken() throws IOException {
        boolean iOrAfter = false;
        if (this.input.incrementToken()) {
            char[] buffer = this.termAtt.buffer();
            int length = this.termAtt.length();
            int i = 0;
            block4: while (i < length) {
                int ch = Character.codePointAt(buffer, i, length);
                boolean bl = iOrAfter = ch == 73 || iOrAfter && Character.getType(ch) == 6;
                if (iOrAfter) {
                    switch (ch) {
                        case 775: {
                            length = this.delete(buffer, i, length);
                            continue block4;
                        }
                        case 73: {
                            if (this.isBeforeDot(buffer, i + 1, length)) {
                                buffer[i] = 105;
                            } else {
                                buffer[i] = 305;
                                iOrAfter = false;
                            }
                            ++i;
                            continue block4;
                        }
                    }
                }
                i += Character.toChars(Character.toLowerCase(ch), buffer, i);
            }
            this.termAtt.setLength(length);
            return true;
        }
        return false;
    }

    private boolean isBeforeDot(char[] s, int pos, int len) {
        int ch;
        for (int i = pos; i < len; i += Character.charCount(ch)) {
            ch = Character.codePointAt(s, i, len);
            if (Character.getType(ch) != 6) {
                return false;
            }
            if (ch != 775) continue;
            return true;
        }
        return false;
    }

    private int delete(char[] s, int pos, int len) {
        if (pos < len) {
            System.arraycopy(s, pos + 1, s, pos, len - pos - 1);
        }
        return len - 1;
    }
}

