/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.analysis.cz;

import guideme.internal.shaded.lucene.analysis.Analyzer;
import guideme.internal.shaded.lucene.analysis.CharArraySet;
import guideme.internal.shaded.lucene.analysis.LowerCaseFilter;
import guideme.internal.shaded.lucene.analysis.StopFilter;
import guideme.internal.shaded.lucene.analysis.StopwordAnalyzerBase;
import guideme.internal.shaded.lucene.analysis.TokenFilter;
import guideme.internal.shaded.lucene.analysis.TokenStream;
import guideme.internal.shaded.lucene.analysis.WordlistLoader;
import guideme.internal.shaded.lucene.analysis.cz.CzechStemFilter;
import guideme.internal.shaded.lucene.analysis.miscellaneous.SetKeywordMarkerFilter;
import guideme.internal.shaded.lucene.analysis.standard.StandardTokenizer;
import guideme.internal.shaded.lucene.util.IOUtils;
import java.io.IOException;
import java.io.UncheckedIOException;

public final class CzechAnalyzer
extends StopwordAnalyzerBase {
    private final CharArraySet stemExclusionTable;

    public CzechAnalyzer() {
        this(DefaultSetHolder.DEFAULT_SET);
    }

    public CzechAnalyzer(CharArraySet stopwords) {
        this(stopwords, CharArraySet.EMPTY_SET);
    }

    public CzechAnalyzer(CharArraySet stopwords, CharArraySet stemExclusionTable) {
        super(stopwords);
        this.stemExclusionTable = CharArraySet.unmodifiableSet(CharArraySet.copy(stemExclusionTable));
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        StandardTokenizer source = new StandardTokenizer();
        TokenFilter result = new LowerCaseFilter(source);
        result = new StopFilter(result, this.stopwords);
        if (!this.stemExclusionTable.isEmpty()) {
            result = new SetKeywordMarkerFilter(result, this.stemExclusionTable);
        }
        result = new CzechStemFilter(result);
        return new Analyzer.TokenStreamComponents(source, (TokenStream)result);
    }

    @Override
    protected TokenStream normalize(String fieldName, TokenStream in) {
        return new LowerCaseFilter(in);
    }

    private static class DefaultSetHolder {
        private static final CharArraySet DEFAULT_SET;

        static {
            try {
                DEFAULT_SET = WordlistLoader.getWordSet(IOUtils.requireResourceNonNull(CzechAnalyzer.class.getResourceAsStream("stopwords.txt"), "stopwords.txt"), "#");
            }
            catch (IOException ex) {
                throw new UncheckedIOException("Unable to load default stopword set", ex);
            }
        }
    }
}

