/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.search;

import guideme.internal.search.EnglishAnalyzer;
import guideme.internal.shaded.lucene.analysis.Analyzer;
import guideme.internal.shaded.lucene.analysis.ar.ArabicAnalyzer;
import guideme.internal.shaded.lucene.analysis.bg.BulgarianAnalyzer;
import guideme.internal.shaded.lucene.analysis.br.BrazilianAnalyzer;
import guideme.internal.shaded.lucene.analysis.ca.CatalanAnalyzer;
import guideme.internal.shaded.lucene.analysis.cjk.CJKAnalyzer;
import guideme.internal.shaded.lucene.analysis.cz.CzechAnalyzer;
import guideme.internal.shaded.lucene.analysis.da.DanishAnalyzer;
import guideme.internal.shaded.lucene.analysis.de.GermanAnalyzer;
import guideme.internal.shaded.lucene.analysis.el.GreekAnalyzer;
import guideme.internal.shaded.lucene.analysis.es.SpanishAnalyzer;
import guideme.internal.shaded.lucene.analysis.fa.PersianAnalyzer;
import guideme.internal.shaded.lucene.analysis.fi.FinnishAnalyzer;
import guideme.internal.shaded.lucene.analysis.fr.FrenchAnalyzer;
import guideme.internal.shaded.lucene.analysis.ga.IrishAnalyzer;
import guideme.internal.shaded.lucene.analysis.hi.HindiAnalyzer;
import guideme.internal.shaded.lucene.analysis.hu.HungarianAnalyzer;
import guideme.internal.shaded.lucene.analysis.it.ItalianAnalyzer;
import guideme.internal.shaded.lucene.analysis.nl.DutchAnalyzer;
import guideme.internal.shaded.lucene.analysis.no.NorwegianAnalyzer;
import guideme.internal.shaded.lucene.analysis.pt.PortugueseAnalyzer;
import guideme.internal.shaded.lucene.analysis.ro.RomanianAnalyzer;
import guideme.internal.shaded.lucene.analysis.ru.RussianAnalyzer;
import guideme.internal.shaded.lucene.analysis.sv.SwedishAnalyzer;
import guideme.internal.shaded.lucene.analysis.tr.TurkishAnalyzer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

final class Analyzers {
    public static final List<String> LANGUAGES = List.of("ar", "br", "bg", "ca", "cn", "cz", "da", "nl", "en", "fa", "fi", "fr", "de", "gr", "hi", "hu", "ir", "it", "jp", "ko", "no", "pt", "ro", "ru", "es", "sw", "tr");
    public static final Map<String, String> MINECRAFT_TO_LUCENE_LANG;
    public static final Map<String, Supplier<Analyzer>> ANALYZERS;

    static {
        HashMap<String, Supplier<Analyzer>> map = new HashMap<String, Supplier<Analyzer>>();
        map.put("ar", () -> new ArabicAnalyzer());
        map.put("br", () -> new BrazilianAnalyzer());
        map.put("bg", () -> new BulgarianAnalyzer());
        map.put("ca", () -> new CatalanAnalyzer());
        map.put("cn", () -> new CJKAnalyzer());
        map.put("cz", () -> new CzechAnalyzer());
        map.put("da", () -> new DanishAnalyzer());
        map.put("nl", () -> new DutchAnalyzer());
        map.put("en", () -> new EnglishAnalyzer());
        map.put("fa", () -> new PersianAnalyzer());
        map.put("fi", () -> new FinnishAnalyzer());
        map.put("fr", () -> new FrenchAnalyzer());
        map.put("de", () -> new GermanAnalyzer());
        map.put("gr", () -> new GreekAnalyzer());
        map.put("hi", () -> new HindiAnalyzer());
        map.put("hu", () -> new HungarianAnalyzer());
        map.put("ir", () -> new IrishAnalyzer());
        map.put("it", () -> new ItalianAnalyzer());
        map.put("jp", () -> new CJKAnalyzer());
        map.put("ko", () -> new CJKAnalyzer());
        map.put("no", () -> new NorwegianAnalyzer());
        map.put("pt", () -> new PortugueseAnalyzer());
        map.put("ro", () -> new RomanianAnalyzer());
        map.put("ru", () -> new RussianAnalyzer());
        map.put("es", () -> new SpanishAnalyzer());
        map.put("sw", () -> new SwedishAnalyzer());
        map.put("tr", () -> new TurkishAnalyzer());
        ANALYZERS = Map.copyOf(map);
        HashMap<String, String> langMap = new HashMap<String, String>();
        langMap.put("ar_sa", "ar");
        langMap.put("bg_bg", "bg");
        langMap.put("pt_br", "br");
        langMap.put("en_us", "en");
        langMap.put("de_de", "de");
        langMap.put("ca_es", "ca");
        langMap.put("zh_cn", "cn");
        langMap.put("zh_hk", "cn");
        langMap.put("zh_tw", "cn");
        langMap.put("ja_jp", "jp");
        langMap.put("ko_kr", "ko");
        langMap.put("cs_cz", "cz");
        langMap.put("da_dk", "da");
        langMap.put("el_gr", "gr");
        langMap.put("es_es", "es");
        langMap.put("fa_ir", "fa");
        langMap.put("fi_fi", "fi");
        langMap.put("fr_fr", "fr");
        langMap.put("ga_ie", "ir");
        langMap.put("hi_in", "hi");
        langMap.put("hu_hu", "hu");
        langMap.put("it_it", "it");
        langMap.put("nl_nl", "nl");
        langMap.put("no_no", "no");
        langMap.put("pt_pt", "pt");
        langMap.put("ro_ro", "ro");
        langMap.put("ru_ru", "ru");
        langMap.put("sv_se", "sw");
        langMap.put("tr_tr", "tr");
        MINECRAFT_TO_LUCENE_LANG = Map.copyOf(langMap);
    }
}

