/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.screen;

import guideme.Guide;
import guideme.PageAnchor;
import guideme.internal.screen.GuideScreenHistory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalInMemoryHistory
implements GuideScreenHistory {
    private static final Logger LOG = LoggerFactory.getLogger(GlobalInMemoryHistory.class);
    private static final Map<ResourceLocation, GuideScreenHistory> PER_GUIDE_HISTORY = new HashMap<ResourceLocation, GuideScreenHistory>();
    private final ResourceLocation guideId;
    private final List<PageAnchor> history = new ArrayList<PageAnchor>();
    private int historyPosition;

    private GlobalInMemoryHistory(ResourceLocation guideId) {
        this.guideId = guideId;
    }

    public static GuideScreenHistory get(Guide guide) {
        return PER_GUIDE_HISTORY.computeIfAbsent(guide.getId(), GlobalInMemoryHistory::new);
    }

    @Override
    public PageAnchor get(int index) {
        return null;
    }

    @Override
    public void push(PageAnchor anchor) {
        LOG.debug("Pushing {} to history of {}", (Object)anchor, (Object)this.guideId);
        if (this.historyPosition < this.history.size() && this.history.get(this.historyPosition).pageId().equals((Object)anchor.pageId())) {
            LOG.debug("Replacing {} with {}", (Object)this.history.get(this.historyPosition), (Object)anchor);
            this.history.set(this.historyPosition, anchor);
            return;
        }
        if (this.historyPosition + 1 < this.history.size()) {
            List<PageAnchor> followingEntries = this.history.subList(this.historyPosition + 1, this.history.size());
            LOG.debug("Cutting tail from history: {}", followingEntries);
            followingEntries.clear();
        }
        if (this.history.size() >= 100) {
            List<PageAnchor> prunedEntries = this.history.subList(0, this.history.size() - 100);
            LOG.debug("Pruning from history: {}", prunedEntries);
            prunedEntries.clear();
        }
        this.historyPosition = this.history.size();
        this.history.add(anchor);
    }

    @Override
    public Optional<PageAnchor> current() {
        if (this.historyPosition < this.history.size()) {
            return Optional.of(this.history.get(this.historyPosition));
        }
        return Optional.empty();
    }

    @Override
    public Optional<PageAnchor> forward() {
        Optional<PageAnchor> page = this.peekForward();
        if (page.isPresent()) {
            ++this.historyPosition;
            LOG.debug("Going forward in history of {}. Position: {}/{}", new Object[]{this.guideId, this.historyPosition + 1, this.history.size()});
        }
        return page;
    }

    @Override
    public Optional<PageAnchor> back() {
        Optional<PageAnchor> page = this.peekBack();
        if (page.isPresent()) {
            --this.historyPosition;
            LOG.debug("Going back in history of {}. Position: {}/{}", new Object[]{this.guideId, this.historyPosition + 1, this.history.size()});
        }
        return page;
    }

    @Override
    public Optional<PageAnchor> peekForward() {
        if (this.historyPosition + 1 < this.history.size()) {
            return Optional.of(this.history.get(this.historyPosition + 1));
        }
        return Optional.empty();
    }

    @Override
    public Optional<PageAnchor> peekBack() {
        if (this.historyPosition > 0) {
            return Optional.of(this.history.get(this.historyPosition - 1));
        }
        return Optional.empty();
    }
}

