/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.snakeyaml.introspector;

import guideme.internal.shaded.snakeyaml.error.YAMLException;
import guideme.internal.shaded.snakeyaml.introspector.GenericProperty;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

public class MethodProperty
extends GenericProperty {
    private final PropertyDescriptor property;
    private final boolean readable;
    private final boolean writable;

    private static Type discoverGenericType(PropertyDescriptor property) {
        Type[] paramTypes;
        Method readMethod = property.getReadMethod();
        if (readMethod != null) {
            return readMethod.getGenericReturnType();
        }
        Method writeMethod = property.getWriteMethod();
        if (writeMethod != null && (paramTypes = writeMethod.getGenericParameterTypes()).length > 0) {
            return paramTypes[0];
        }
        return null;
    }

    public MethodProperty(PropertyDescriptor property) {
        super(property.getName(), property.getPropertyType(), MethodProperty.discoverGenericType(property));
        this.property = property;
        this.readable = property.getReadMethod() != null;
        this.writable = property.getWriteMethod() != null;
    }

    @Override
    public void set(Object object, Object value) throws Exception {
        if (!this.writable) {
            throw new YAMLException("No writable property '" + this.getName() + "' on class: " + object.getClass().getName());
        }
        this.property.getWriteMethod().invoke(object, value);
    }

    @Override
    public boolean isWritable() {
        return this.writable;
    }
}

