/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.util.packed;

import guideme.internal.shaded.lucene.store.DataOutput;
import guideme.internal.shaded.lucene.util.packed.PackedInts;
import java.io.IOException;
import java.util.Arrays;

abstract class AbstractBlockPackedWriter {
    protected DataOutput out;
    protected final long[] values;
    protected byte[] blocks;
    protected int off;
    protected long ord;
    protected boolean finished;

    static void writeVLong(DataOutput out, long i) throws IOException {
        int k = 0;
        while ((i & 0xFFFFFFFFFFFFFF80L) != 0L && k++ < 8) {
            out.writeByte((byte)(i & 0x7FL | 0x80L));
            i >>>= 7;
        }
        out.writeByte((byte)i);
    }

    protected AbstractBlockPackedWriter(DataOutput out, int blockSize) {
        PackedInts.checkBlockSize(blockSize, 64, 0x8000000);
        this.reset(out);
        this.values = new long[blockSize];
    }

    public void reset(DataOutput out) {
        assert (out != null);
        this.out = out;
        this.off = 0;
        this.ord = 0L;
        this.finished = false;
    }

    private void checkNotFinished() {
        if (this.finished) {
            throw new IllegalStateException("Already finished");
        }
    }

    public void add(long l) throws IOException {
        this.checkNotFinished();
        if (this.off == this.values.length) {
            this.flush();
        }
        this.values[this.off++] = l;
        ++this.ord;
    }

    public void finish() throws IOException {
        this.checkNotFinished();
        if (this.off > 0) {
            this.flush();
        }
        this.finished = true;
    }

    protected abstract void flush() throws IOException;

    protected final void writeValues(int bitsRequired) throws IOException {
        PackedInts.Encoder encoder = PackedInts.getEncoder(PackedInts.Format.PACKED, 2, bitsRequired);
        int iterations = this.values.length / encoder.byteValueCount();
        int blockSize = encoder.byteBlockCount() * iterations;
        if (this.blocks == null || this.blocks.length < blockSize) {
            this.blocks = new byte[blockSize];
        }
        if (this.off < this.values.length) {
            Arrays.fill(this.values, this.off, this.values.length, 0L);
        }
        encoder.encode(this.values, 0, this.blocks, 0, iterations);
        int blockCount = (int)PackedInts.Format.PACKED.byteCount(2, this.off, bitsRequired);
        this.out.writeBytes(this.blocks, blockCount);
    }
}

