/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.util.fst;

import guideme.internal.shaded.lucene.util.BytesRef;
import guideme.internal.shaded.lucene.util.BytesRefBuilder;
import guideme.internal.shaded.lucene.util.IntsRef;
import guideme.internal.shaded.lucene.util.IntsRefBuilder;

public final class Util {
    private Util() {
    }

    public static IntsRef toIntsRef(BytesRef input, IntsRefBuilder scratch) {
        scratch.growNoCopy(input.length);
        for (int i = 0; i < input.length; ++i) {
            scratch.setIntAt(i, input.bytes[i + input.offset] & 0xFF);
        }
        scratch.setLength(input.length);
        return scratch.get();
    }

    public static BytesRef toBytesRef(IntsRef input, BytesRefBuilder scratch) {
        scratch.growNoCopy(input.length);
        for (int i = 0; i < input.length; ++i) {
            int value = input.ints[i + input.offset];
            assert (value >= -128 && value <= 255) : "value " + value + " doesn't fit into byte";
            scratch.setByteAt(i, (byte)value);
        }
        scratch.setLength(input.length);
        return scratch.get();
    }
}

