/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search;

import guideme.internal.shaded.lucene.search.CollectorManager;
import guideme.internal.shaded.lucene.search.MaxScoreAccumulator;
import guideme.internal.shaded.lucene.search.ScoreDoc;
import guideme.internal.shaded.lucene.search.TopDocs;
import guideme.internal.shaded.lucene.search.TopScoreDocCollector;
import java.io.IOException;
import java.util.Collection;

public class TopScoreDocCollectorManager
implements CollectorManager<TopScoreDocCollector, TopDocs> {
    private final int numHits;
    private final ScoreDoc after;
    private final int totalHitsThreshold;
    private final MaxScoreAccumulator minScoreAcc;

    public TopScoreDocCollectorManager(int numHits, ScoreDoc after, int totalHitsThreshold) {
        if (totalHitsThreshold < 0) {
            throw new IllegalArgumentException("totalHitsThreshold must be >= 0, got " + totalHitsThreshold);
        }
        if (numHits <= 0) {
            throw new IllegalArgumentException("numHits must be > 0; please use TotalHitCountCollectorManager if you just need the total hit count");
        }
        this.numHits = numHits;
        this.after = after;
        this.totalHitsThreshold = Math.max(totalHitsThreshold, numHits);
        this.minScoreAcc = totalHitsThreshold != Integer.MAX_VALUE ? new MaxScoreAccumulator() : null;
    }

    @Override
    public TopScoreDocCollector newCollector() {
        return new TopScoreDocCollector(this.numHits, this.after, this.totalHitsThreshold, this.minScoreAcc);
    }

    @Override
    public TopDocs reduce(Collection<TopScoreDocCollector> collectors) throws IOException {
        TopDocs[] topDocs = new TopDocs[collectors.size()];
        int i = 0;
        for (TopScoreDocCollector collector : collectors) {
            topDocs[i++] = collector.topDocs();
        }
        return TopDocs.merge(0, this.numHits, topDocs);
    }
}

