/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search;

import guideme.internal.shaded.lucene.index.DocValues;
import guideme.internal.shaded.lucene.index.IndexSorter;
import guideme.internal.shaded.lucene.search.FieldComparator;
import guideme.internal.shaded.lucene.search.FieldComparatorSource;
import guideme.internal.shaded.lucene.search.Pruning;
import guideme.internal.shaded.lucene.search.comparators.DocComparator;
import guideme.internal.shaded.lucene.search.comparators.DoubleComparator;
import guideme.internal.shaded.lucene.search.comparators.FloatComparator;
import guideme.internal.shaded.lucene.search.comparators.IntComparator;
import guideme.internal.shaded.lucene.search.comparators.LongComparator;
import guideme.internal.shaded.lucene.search.comparators.TermOrdValComparator;
import guideme.internal.shaded.lucene.util.BytesRef;
import java.util.Comparator;
import java.util.Objects;

public class SortField {
    public static final SortField FIELD_SCORE = new SortField(null, Type.SCORE);
    public static final SortField FIELD_DOC = new SortField(null, Type.DOC);
    private String field;
    private Type type;
    boolean reverse = false;
    private FieldComparatorSource comparatorSource;
    protected Object missingValue = null;
    @Deprecated
    private boolean optimizeSortWithIndexedData = true;
    public static final Object STRING_FIRST = new Object(){

        public String toString() {
            return "SortField.STRING_FIRST";
        }
    };
    public static final Object STRING_LAST = new Object(){

        public String toString() {
            return "SortField.STRING_LAST";
        }
    };
    private Comparator<BytesRef> bytesComparator = Comparator.naturalOrder();

    public SortField(String field, Type type) {
        this.initFieldType(field, type);
    }

    private void initFieldType(String field, Type type) {
        this.type = type;
        if (field == null) {
            if (type != Type.SCORE && type != Type.DOC) {
                throw new IllegalArgumentException("field can only be null when type is SCORE or DOC");
            }
        } else {
            this.field = field;
        }
    }

    public String getField() {
        return this.field;
    }

    public boolean getReverse() {
        return this.reverse;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        switch (this.type.ordinal()) {
            case 0: {
                buffer.append("<score>");
                break;
            }
            case 1: {
                buffer.append("<doc>");
                break;
            }
            case 2: {
                buffer.append("<string: \"").append(this.field).append("\">");
                break;
            }
            case 8: {
                buffer.append("<string_val: \"").append(this.field).append("\">");
                break;
            }
            case 3: {
                buffer.append("<int: \"").append(this.field).append("\">");
                break;
            }
            case 5: {
                buffer.append("<long: \"").append(this.field).append("\">");
                break;
            }
            case 4: {
                buffer.append("<float: \"").append(this.field).append("\">");
                break;
            }
            case 6: {
                buffer.append("<double: \"").append(this.field).append("\">");
                break;
            }
            case 7: {
                buffer.append("<custom:\"").append(this.field).append("\": ").append(this.comparatorSource).append('>');
                break;
            }
            case 9: {
                buffer.append("<rewriteable: \"").append(this.field).append("\">");
                break;
            }
            default: {
                buffer.append("<???: \"").append(this.field).append("\">");
            }
        }
        if (this.reverse) {
            buffer.append('!');
        }
        if (this.missingValue != null) {
            buffer.append(" missingValue=");
            buffer.append(this.missingValue);
        }
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SortField)) {
            return false;
        }
        SortField other = (SortField)o;
        return Objects.equals(other.field, this.field) && other.type == this.type && other.reverse == this.reverse && Objects.equals(this.comparatorSource, other.comparatorSource) && Objects.equals(this.missingValue, other.missingValue);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.field, this.type, this.reverse, this.comparatorSource, this.missingValue});
    }

    public FieldComparator<?> getComparator(int numHits, Pruning pruning) {
        FieldComparator fieldComparator = switch (this.type.ordinal()) {
            case 0 -> new FieldComparator.RelevanceComparator(numHits);
            case 1 -> new DocComparator(numHits, this.reverse, pruning);
            case 3 -> new IntComparator(numHits, this.field, (Integer)this.missingValue, this.reverse, pruning);
            case 4 -> new FloatComparator(numHits, this.field, (Float)this.missingValue, this.reverse, pruning);
            case 5 -> new LongComparator(numHits, this.field, (Long)this.missingValue, this.reverse, pruning);
            case 6 -> new DoubleComparator(numHits, this.field, (Double)this.missingValue, this.reverse, pruning);
            case 7 -> {
                if (!$assertionsDisabled && this.comparatorSource == null) {
                    throw new AssertionError();
                }
                yield this.comparatorSource.newComparator(this.field, numHits, pruning, this.reverse);
            }
            case 2 -> new TermOrdValComparator(numHits, this.field, this.missingValue == STRING_LAST, this.reverse, pruning);
            case 8 -> new FieldComparator.TermValComparator(numHits, this.field, this.missingValue == STRING_LAST);
            case 9 -> throw new IllegalStateException("SortField needs to be rewritten through Sort.rewrite(..) and SortField.rewrite(..)");
            default -> throw new IllegalStateException("Illegal sort type: " + String.valueOf((Object)this.type));
        };
        if (!this.getOptimizeSortWithIndexedData()) {
            fieldComparator.disableSkipping();
        }
        return fieldComparator;
    }

    public boolean needsScores() {
        return this.type == Type.SCORE;
    }

    public IndexSorter getIndexSorter() {
        switch (this.type.ordinal()) {
            case 2: {
                return new IndexSorter.StringSorter("SortField", this.missingValue, this.reverse, reader -> DocValues.getSorted(reader, this.field));
            }
            case 3: {
                return new IndexSorter.IntSorter("SortField", (Integer)this.missingValue, this.reverse, reader -> DocValues.getNumeric(reader, this.field));
            }
            case 5: {
                return new IndexSorter.LongSorter("SortField", (Long)this.missingValue, this.reverse, reader -> DocValues.getNumeric(reader, this.field));
            }
            case 6: {
                return new IndexSorter.DoubleSorter("SortField", (Double)this.missingValue, this.reverse, reader -> DocValues.getNumeric(reader, this.field));
            }
            case 4: {
                return new IndexSorter.FloatSorter("SortField", (Float)this.missingValue, this.reverse, reader -> DocValues.getNumeric(reader, this.field));
            }
        }
        return null;
    }

    @Deprecated
    public boolean getOptimizeSortWithIndexedData() {
        return this.optimizeSortWithIndexedData;
    }

    public static enum Type {
        SCORE,
        DOC,
        STRING,
        INT,
        FLOAT,
        LONG,
        DOUBLE,
        CUSTOM,
        STRING_VAL,
        REWRITEABLE;

    }
}

