/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search;

import guideme.internal.shaded.lucene.index.IndexReader;
import guideme.internal.shaded.lucene.index.IndexReaderContext;
import guideme.internal.shaded.lucene.index.LeafReaderContext;
import guideme.internal.shaded.lucene.index.QueryTimeout;
import guideme.internal.shaded.lucene.index.Term;
import guideme.internal.shaded.lucene.index.Terms;
import guideme.internal.shaded.lucene.search.BooleanClause;
import guideme.internal.shaded.lucene.search.BulkScorer;
import guideme.internal.shaded.lucene.search.CollectionStatistics;
import guideme.internal.shaded.lucene.search.CollectionTerminatedException;
import guideme.internal.shaded.lucene.search.Collector;
import guideme.internal.shaded.lucene.search.CollectorManager;
import guideme.internal.shaded.lucene.search.ConstantScoreQuery;
import guideme.internal.shaded.lucene.search.LRUQueryCache;
import guideme.internal.shaded.lucene.search.LeafCollector;
import guideme.internal.shaded.lucene.search.Query;
import guideme.internal.shaded.lucene.search.QueryCache;
import guideme.internal.shaded.lucene.search.QueryCachingPolicy;
import guideme.internal.shaded.lucene.search.QueryVisitor;
import guideme.internal.shaded.lucene.search.ScoreDoc;
import guideme.internal.shaded.lucene.search.ScoreMode;
import guideme.internal.shaded.lucene.search.ScorerSupplier;
import guideme.internal.shaded.lucene.search.TaskExecutor;
import guideme.internal.shaded.lucene.search.TermStatistics;
import guideme.internal.shaded.lucene.search.TimeLimitingBulkScorer;
import guideme.internal.shaded.lucene.search.TopDocs;
import guideme.internal.shaded.lucene.search.TopScoreDocCollectorManager;
import guideme.internal.shaded.lucene.search.UsageTrackingQueryCachingPolicy;
import guideme.internal.shaded.lucene.search.Weight;
import guideme.internal.shaded.lucene.search.similarities.BM25Similarity;
import guideme.internal.shaded.lucene.search.similarities.Similarity;
import guideme.internal.shaded.lucene.util.automaton.ByteRunAutomaton;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Supplier;

public class IndexSearcher {
    static int maxClauseCount = 1024;
    private static QueryCache DEFAULT_QUERY_CACHE;
    private static QueryCachingPolicy DEFAULT_CACHING_POLICY;
    private QueryTimeout queryTimeout = null;
    private volatile boolean partialResult = false;
    final IndexReader reader;
    protected final IndexReaderContext readerContext;
    protected final List<LeafReaderContext> leafContexts;
    private volatile LeafSlice[] leafSlices;
    private final TaskExecutor taskExecutor;
    private static final Similarity defaultSimilarity;
    private QueryCache queryCache = DEFAULT_QUERY_CACHE;
    private QueryCachingPolicy queryCachingPolicy = DEFAULT_CACHING_POLICY;
    private Similarity similarity = defaultSimilarity;

    public static Similarity getDefaultSimilarity() {
        return defaultSimilarity;
    }

    public IndexSearcher(IndexReader r) {
        this(r, null);
    }

    public IndexSearcher(IndexReader r, Executor executor) {
        this(r.getContext(), executor);
    }

    public IndexSearcher(IndexReaderContext context, Executor executor) {
        assert (context.isTopLevel) : "IndexSearcher's ReaderContext must be topLevel for reader " + String.valueOf(context.reader());
        this.reader = context.reader();
        this.taskExecutor = executor == null ? new TaskExecutor(Runnable::run) : new TaskExecutor(executor);
        this.readerContext = context;
        this.leafContexts = context.leaves();
        if (executor == null) {
            LeafSlice[] leafSliceArray;
            if (this.leafContexts.isEmpty()) {
                leafSliceArray = new LeafSlice[]{};
            } else {
                LeafSlice[] leafSliceArray2 = new LeafSlice[1];
                leafSliceArray = leafSliceArray2;
                leafSliceArray2[0] = new LeafSlice(new ArrayList<LeafReaderContextPartition>(this.leafContexts.stream().map(LeafReaderContextPartition::createForEntireSegment).toList()));
            }
            this.leafSlices = leafSliceArray;
        }
    }

    public IndexSearcher(IndexReaderContext context) {
        this(context, null);
    }

    public static int getMaxClauseCount() {
        return maxClauseCount;
    }

    public void setQueryCache(QueryCache queryCache) {
        this.queryCache = queryCache;
    }

    protected LeafSlice[] slices(List<LeafReaderContext> leaves) {
        return IndexSearcher.slices(leaves, 250000, 5, false);
    }

    public static LeafSlice[] slices(List<LeafReaderContext> leaves, int maxDocsPerSlice, int maxSegmentsPerSlice, boolean allowSegmentPartitions) {
        ArrayList<LeafReaderContext> sortedLeaves = new ArrayList<LeafReaderContext>(leaves);
        sortedLeaves.sort(Collections.reverseOrder(Comparator.comparingInt(l -> l.reader().maxDoc())));
        if (allowSegmentPartitions) {
            ArrayList<List<LeafReaderContextPartition>> groupedLeafPartitions = new ArrayList<List<LeafReaderContextPartition>>();
            int currentSliceNumDocs = 0;
            ArrayList<LeafReaderContextPartition> group = null;
            for (LeafReaderContext ctx : sortedLeaves) {
                if (ctx.reader().maxDoc() > maxDocsPerSlice) {
                    int n;
                    assert (group == null);
                    int numSlices = Math.min(5, Math.ceilDiv(ctx.reader().maxDoc(), maxDocsPerSlice));
                    int n2 = n = ctx.reader().maxDoc() / numSlices;
                    int minDocId = 0;
                    for (int i = 0; i < numSlices - 1; ++i) {
                        groupedLeafPartitions.add(Collections.singletonList(LeafReaderContextPartition.createFromAndTo(ctx, minDocId, n2)));
                        minDocId = n2;
                        n2 += n;
                    }
                    groupedLeafPartitions.add(Collections.singletonList(LeafReaderContextPartition.createFromAndTo(ctx, minDocId, ctx.reader().maxDoc())));
                    continue;
                }
                if (group == null) {
                    group = new ArrayList<LeafReaderContextPartition>();
                    groupedLeafPartitions.add(group);
                }
                group.add(LeafReaderContextPartition.createForEntireSegment(ctx));
                if (group.size() < maxSegmentsPerSlice && (currentSliceNumDocs += ctx.reader().maxDoc()) <= maxDocsPerSlice) continue;
                group = null;
                currentSliceNumDocs = 0;
            }
            LeafSlice[] slices = new LeafSlice[groupedLeafPartitions.size()];
            int upto = 0;
            for (List list : groupedLeafPartitions) {
                slices[upto] = new LeafSlice(list);
                ++upto;
            }
            return slices;
        }
        ArrayList<List<LeafReaderContext>> groupedLeaves = new ArrayList<List<LeafReaderContext>>();
        long docSum = 0L;
        ArrayList<LeafReaderContext> group = null;
        for (LeafReaderContext ctx : sortedLeaves) {
            if (ctx.reader().maxDoc() > maxDocsPerSlice) {
                assert (group == null);
                groupedLeaves.add(Collections.singletonList(ctx));
                continue;
            }
            if (group == null) {
                group = new ArrayList<LeafReaderContext>();
                group.add(ctx);
                groupedLeaves.add(group);
            } else {
                group.add(ctx);
            }
            if (group.size() < maxSegmentsPerSlice && (docSum += (long)ctx.reader().maxDoc()) <= (long)maxDocsPerSlice) continue;
            group = null;
            docSum = 0L;
        }
        LeafSlice[] slices = new LeafSlice[groupedLeaves.size()];
        int upto = 0;
        for (List list : groupedLeaves) {
            slices[upto] = new LeafSlice(new ArrayList<LeafReaderContextPartition>(list.stream().map(LeafReaderContextPartition::createForEntireSegment).toList()));
            ++upto;
        }
        return slices;
    }

    public IndexReader getIndexReader() {
        return this.reader;
    }

    public void setSimilarity(Similarity similarity) {
        this.similarity = similarity;
    }

    public Similarity getSimilarity() {
        return this.similarity;
    }

    public final LeafSlice[] getSlices() {
        LeafSlice[] res = this.leafSlices;
        if (res == null) {
            res = this.computeAndCacheSlices();
        }
        return res;
    }

    private synchronized LeafSlice[] computeAndCacheSlices() {
        LeafSlice[] res = this.leafSlices;
        if (res == null) {
            for (LeafSlice leafSlice : res = this.slices(this.leafContexts)) {
                if (leafSlice.partitions.length <= 1) continue;
                IndexSearcher.enforceDistinctLeaves(leafSlice);
            }
            this.leafSlices = res;
        }
        return res;
    }

    private static void enforceDistinctLeaves(LeafSlice leafSlice) {
        HashSet<LeafReaderContext> distinctLeaves = new HashSet<LeafReaderContext>();
        for (LeafReaderContextPartition leafPartition : leafSlice.partitions) {
            if (distinctLeaves.add(leafPartition.ctx)) continue;
            throw new IllegalStateException("The same slice targets multiple leaf partitions of the same leaf reader context. A physical segment should rather get partitioned to be searched concurrently from as many slices as the number of leaf partitions it is split into.");
        }
    }

    public TopDocs searchAfter(ScoreDoc after, Query query, int numHits) throws IOException {
        int limit = Math.max(1, this.reader.maxDoc());
        if (after != null && after.doc >= limit) {
            throw new IllegalArgumentException("after.doc exceeds the number of documents in the reader: after.doc=" + after.doc + " limit=" + limit);
        }
        int cappedNumHits = Math.min(numHits, limit);
        TopScoreDocCollectorManager manager = new TopScoreDocCollectorManager(cappedNumHits, after, 1000);
        return this.search(query, manager);
    }

    public TopDocs search(Query query, int n) throws IOException {
        return this.searchAfter(null, query, n);
    }

    public <C extends Collector, T> T search(Query query, CollectorManager<C, T> collectorManager) throws IOException {
        C firstCollector = collectorManager.newCollector();
        query = this.rewrite(query, firstCollector.scoreMode().needsScores());
        Weight weight = this.createWeight(query, firstCollector.scoreMode(), 1.0f);
        return this.search(weight, collectorManager, firstCollector);
    }

    private <C extends Collector, T> T search(Weight weight, CollectorManager<C, T> collectorManager, C firstCollector) throws IOException {
        LeafSlice[] leafSlices = this.getSlices();
        if (leafSlices.length == 0) {
            assert (this.leafContexts.isEmpty());
            return collectorManager.reduce(Collections.singletonList(firstCollector));
        }
        ArrayList<C> collectors = new ArrayList<C>(leafSlices.length);
        collectors.add(firstCollector);
        ScoreMode scoreMode = firstCollector.scoreMode();
        for (int i = 1; i < leafSlices.length; ++i) {
            C collector = collectorManager.newCollector();
            collectors.add(collector);
            if (scoreMode == collector.scoreMode()) continue;
            throw new IllegalStateException("CollectorManager does not always produce collectors with the same score mode");
        }
        ArrayList listTasks = new ArrayList(leafSlices.length);
        for (int i = 0; i < leafSlices.length; ++i) {
            LeafReaderContextPartition[] leaves = leafSlices[i].partitions;
            Collector collector = (Collector)collectors.get(i);
            listTasks.add(() -> {
                this.search(leaves, weight, collector);
                return collector;
            });
        }
        List results = this.taskExecutor.invokeAll(listTasks);
        return collectorManager.reduce(results);
    }

    protected void search(LeafReaderContextPartition[] partitions, Weight weight, Collector collector) throws IOException {
        collector.setWeight(weight);
        for (LeafReaderContextPartition partition : partitions) {
            this.searchLeaf(partition.ctx, partition.minDocId, partition.maxDocId, weight, collector);
        }
    }

    protected void searchLeaf(LeafReaderContext ctx, int minDocId, int maxDocId, Weight weight, Collector collector) throws IOException {
        LeafCollector leafCollector;
        try {
            leafCollector = collector.getLeafCollector(ctx);
        }
        catch (CollectionTerminatedException e) {
            return;
        }
        ScorerSupplier scorerSupplier = weight.scorerSupplier(ctx);
        if (scorerSupplier != null) {
            scorerSupplier.setTopLevelScoringClause();
            BulkScorer scorer = scorerSupplier.bulkScorer();
            if (this.queryTimeout != null) {
                scorer = new TimeLimitingBulkScorer(scorer, this.queryTimeout);
            }
            try {
                scorer.score(leafCollector, ctx.reader().getLiveDocs(), minDocId, maxDocId);
            }
            catch (CollectionTerminatedException collectionTerminatedException) {
            }
            catch (TimeLimitingBulkScorer.TimeExceededException e) {
                this.partialResult = true;
            }
        }
        leafCollector.finish();
    }

    public Query rewrite(Query original) throws IOException {
        Query query = original;
        Query rewrittenQuery = query.rewrite(this);
        while (rewrittenQuery != query) {
            query = rewrittenQuery;
            rewrittenQuery = query.rewrite(this);
        }
        query.visit(IndexSearcher.getNumClausesCheckVisitor());
        return query;
    }

    private Query rewrite(Query original, boolean needsScores) throws IOException {
        if (needsScores) {
            return this.rewrite(original);
        }
        return this.rewrite(new ConstantScoreQuery(original));
    }

    private static QueryVisitor getNumClausesCheckVisitor() {
        return new QueryVisitor(){
            int numClauses;

            @Override
            public QueryVisitor getSubVisitor(BooleanClause.Occur occur, Query parent) {
                return this;
            }

            @Override
            public void visitLeaf(Query query) {
                if (this.numClauses > maxClauseCount) {
                    throw new TooManyNestedClauses();
                }
                ++this.numClauses;
            }

            @Override
            public void consumeTerms(Query query, Term ... terms) {
                if (this.numClauses > maxClauseCount) {
                    throw new TooManyNestedClauses();
                }
                ++this.numClauses;
            }

            @Override
            public void consumeTermsMatching(Query query, String field, Supplier<ByteRunAutomaton> automaton) {
                if (this.numClauses > maxClauseCount) {
                    throw new TooManyNestedClauses();
                }
                ++this.numClauses;
            }
        };
    }

    public Weight createWeight(Query query, ScoreMode scoreMode, float boost) throws IOException {
        QueryCache queryCache = this.queryCache;
        Weight weight = query.createWeight(this, scoreMode, boost);
        if (!scoreMode.needsScores() && queryCache != null) {
            weight = queryCache.doCache(weight, this.queryCachingPolicy);
        }
        return weight;
    }

    public IndexReaderContext getTopReaderContext() {
        return this.readerContext;
    }

    public String toString() {
        return "IndexSearcher(" + String.valueOf(this.reader) + "; taskExecutor=" + String.valueOf(this.taskExecutor) + ")";
    }

    public TermStatistics termStatistics(Term term, int docFreq, long totalTermFreq) throws IOException {
        return new TermStatistics(term.bytes(), docFreq, totalTermFreq);
    }

    public CollectionStatistics collectionStatistics(String field) throws IOException {
        assert (field != null);
        long docCount = 0L;
        long sumTotalTermFreq = 0L;
        long sumDocFreq = 0L;
        for (LeafReaderContext leaf : this.reader.leaves()) {
            Terms terms = Terms.getTerms(leaf.reader(), field);
            docCount += (long)terms.getDocCount();
            sumTotalTermFreq += terms.getSumTotalTermFreq();
            sumDocFreq += terms.getSumDocFreq();
        }
        if (docCount == 0L) {
            return null;
        }
        return new CollectionStatistics(field, this.reader.maxDoc(), docCount, sumTotalTermFreq, sumDocFreq);
    }

    static {
        DEFAULT_CACHING_POLICY = new UsageTrackingQueryCachingPolicy();
        int maxCachedQueries = 1000;
        long maxRamBytesUsed = Math.min(0x2000000L, Runtime.getRuntime().maxMemory() / 20L);
        DEFAULT_QUERY_CACHE = new LRUQueryCache(1000, maxRamBytesUsed);
        defaultSimilarity = new BM25Similarity();
    }

    public static class LeafSlice {
        public final LeafReaderContextPartition[] partitions;
        private final int maxDocs;

        public LeafSlice(List<LeafReaderContextPartition> leafReaderContextPartitions) {
            Comparator<LeafReaderContextPartition> docBaseComparator = Comparator.comparingInt(l -> l.ctx.docBase);
            Comparator<LeafReaderContextPartition> minDocIdComparator = Comparator.comparingInt(l -> l.minDocId);
            leafReaderContextPartitions.sort(docBaseComparator.thenComparing(minDocIdComparator));
            this.partitions = leafReaderContextPartitions.toArray(new LeafReaderContextPartition[0]);
            this.maxDocs = Arrays.stream(this.partitions).map(leafPartition -> leafPartition.maxDocs).reduce(Integer::sum).get();
        }
    }

    public static final class LeafReaderContextPartition {
        public final int minDocId;
        public final int maxDocId;
        public final LeafReaderContext ctx;
        private final int maxDocs;

        private LeafReaderContextPartition(LeafReaderContext leafReaderContext, int minDocId, int maxDocId, int maxDocs) {
            if (minDocId >= maxDocId) {
                throw new IllegalArgumentException("minDocId is greater than or equal to maxDocId: [" + minDocId + "] > [" + maxDocId + "]");
            }
            if (minDocId < 0) {
                throw new IllegalArgumentException("minDocId is lower than 0: [" + minDocId + "]");
            }
            if (minDocId >= leafReaderContext.reader().maxDoc()) {
                throw new IllegalArgumentException("minDocId is greater than than maxDoc: [" + minDocId + "] > [" + leafReaderContext.reader().maxDoc() + "]");
            }
            this.ctx = leafReaderContext;
            this.minDocId = minDocId;
            this.maxDocId = maxDocId;
            this.maxDocs = maxDocs;
        }

        public static LeafReaderContextPartition createForEntireSegment(LeafReaderContext ctx) {
            return new LeafReaderContextPartition(ctx, 0, Integer.MAX_VALUE, ctx.reader().maxDoc());
        }

        public static LeafReaderContextPartition createFromAndTo(LeafReaderContext ctx, int minDocId, int maxDocId) {
            assert (maxDocId != Integer.MAX_VALUE);
            return new LeafReaderContextPartition(ctx, minDocId, maxDocId, maxDocId - minDocId);
        }
    }

    public static class TooManyNestedClauses
    extends TooManyClauses {
        public TooManyNestedClauses() {
            super("Query contains too many nested clauses; maxClauseCount is set to " + IndexSearcher.getMaxClauseCount());
        }
    }

    public static class TooManyClauses
    extends RuntimeException {
        private final int maxClauseCount = IndexSearcher.getMaxClauseCount();

        public TooManyClauses(String msg) {
            super(msg);
        }

        public TooManyClauses() {
            this("maxClauseCount is set to " + IndexSearcher.getMaxClauseCount());
        }
    }
}

