/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.queries.spans;

import guideme.internal.shaded.lucene.index.LeafReaderContext;
import guideme.internal.shaded.lucene.index.NumericDocValues;
import guideme.internal.shaded.lucene.index.Term;
import guideme.internal.shaded.lucene.index.TermStates;
import guideme.internal.shaded.lucene.queries.spans.SpanQuery;
import guideme.internal.shaded.lucene.queries.spans.SpanScorer;
import guideme.internal.shaded.lucene.queries.spans.Spans;
import guideme.internal.shaded.lucene.search.CollectionStatistics;
import guideme.internal.shaded.lucene.search.IndexSearcher;
import guideme.internal.shaded.lucene.search.ScorerSupplier;
import guideme.internal.shaded.lucene.search.TermStatistics;
import guideme.internal.shaded.lucene.search.Weight;
import guideme.internal.shaded.lucene.search.similarities.Similarity;
import guideme.internal.shaded.lucene.util.ArrayUtil;
import java.io.IOException;
import java.util.Map;

public abstract class SpanWeight
extends Weight {
    protected final Similarity similarity;
    protected final Similarity.SimScorer simScorer;
    protected final String field;

    public SpanWeight(SpanQuery query, IndexSearcher searcher, Map<Term, TermStates> termStates, float boost) throws IOException {
        super(query);
        this.field = query.getField();
        this.similarity = searcher.getSimilarity();
        this.simScorer = this.buildSimWeight(query, searcher, termStates, boost);
    }

    private Similarity.SimScorer buildSimWeight(SpanQuery query, IndexSearcher searcher, Map<Term, TermStates> termStates, float boost) throws IOException {
        if (termStates == null || termStates.size() == 0 || query.getField() == null) {
            return null;
        }
        TermStatistics[] termStats = new TermStatistics[termStates.size()];
        int termUpTo = 0;
        for (Map.Entry<Term, TermStates> entry : termStates.entrySet()) {
            TermStates ts = entry.getValue();
            if (ts.docFreq() <= 0) continue;
            termStats[termUpTo++] = searcher.termStatistics(entry.getKey(), ts.docFreq(), ts.totalTermFreq());
        }
        CollectionStatistics collectionStats = searcher.collectionStatistics(query.getField());
        if (termUpTo > 0) {
            return this.similarity.scorer(boost, collectionStats, ArrayUtil.copyOfSubArray(termStats, 0, termUpTo));
        }
        return null;
    }

    public abstract void extractTermStates(Map<Term, TermStates> var1);

    public abstract Spans getSpans(LeafReaderContext var1, Postings var2) throws IOException;

    @Override
    public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
        Spans spans = this.getSpans(context, Postings.POSITIONS);
        if (spans == null) {
            return null;
        }
        NumericDocValues norms = context.reader().getNormValues(this.field);
        final SpanScorer scorer = new SpanScorer(spans, this.simScorer, norms);
        return new ScorerSupplier(this){

            @Override
            public SpanScorer get(long leadCost) throws IOException {
                return scorer;
            }

            @Override
            public long cost() {
                return scorer.iterator().cost();
            }
        };
    }

    public Similarity.SimScorer getSimScorer() {
        return this.simScorer;
    }

    public static enum Postings {
        POSITIONS{

            @Override
            public int getRequiredPostings() {
                return 24;
            }
        }
        ,
        PAYLOADS{

            @Override
            public int getRequiredPostings() {
                return 88;
            }
        }
        ,
        OFFSETS{

            @Override
            public int getRequiredPostings() {
                return 120;
            }
        };


        public abstract int getRequiredPostings();
    }
}

