/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.index;

import guideme.internal.shaded.lucene.index.DocValuesIterator;
import guideme.internal.shaded.lucene.index.SortedSetDocValuesTermsEnum;
import guideme.internal.shaded.lucene.index.TermsEnum;
import guideme.internal.shaded.lucene.util.BytesRef;
import java.io.IOException;

public abstract class SortedSetDocValues
extends DocValuesIterator {
    protected SortedSetDocValues() {
    }

    public abstract long nextOrd() throws IOException;

    public abstract int docValueCount();

    public abstract BytesRef lookupOrd(long var1) throws IOException;

    public abstract long getValueCount();

    public long lookupTerm(BytesRef key) throws IOException {
        long low = 0L;
        long high = this.getValueCount() - 1L;
        while (low <= high) {
            long mid = low + high >>> 1;
            BytesRef term = this.lookupOrd(mid);
            int cmp = term.compareTo(key);
            if (cmp < 0) {
                low = mid + 1L;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1L;
                continue;
            }
            return mid;
        }
        return -(low + 1L);
    }

    public TermsEnum termsEnum() throws IOException {
        return new SortedSetDocValuesTermsEnum(this);
    }
}

