/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.index;

import guideme.internal.shaded.lucene.index.BaseCompositeReader;
import guideme.internal.shaded.lucene.index.IndexReader;
import guideme.internal.shaded.lucene.index.IndexWriter;
import guideme.internal.shaded.lucene.index.LeafReader;
import guideme.internal.shaded.lucene.index.StandardDirectoryReader;
import guideme.internal.shaded.lucene.store.Directory;
import java.io.IOException;
import java.util.Comparator;

public abstract class DirectoryReader
extends BaseCompositeReader<LeafReader> {
    protected final Directory directory;

    public static DirectoryReader open(Directory directory) throws IOException {
        return StandardDirectoryReader.open(directory, null, null);
    }

    public static DirectoryReader open(IndexWriter writer) throws IOException {
        return DirectoryReader.open(writer, true, false);
    }

    public static DirectoryReader open(IndexWriter writer, boolean applyAllDeletes, boolean writeAllDeletes) throws IOException {
        return writer.getReader(applyAllDeletes, writeAllDeletes);
    }

    public static boolean indexExists(Directory directory) throws IOException {
        String[] files = directory.listAll();
        String prefix = "segments_";
        for (String file : files) {
            if (!file.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    protected DirectoryReader(Directory directory, LeafReader[] segmentReaders, Comparator<LeafReader> leafSorter) throws IOException {
        super((IndexReader[])segmentReaders, leafSorter);
        this.directory = directory;
    }

    public final Directory directory() {
        return this.directory;
    }
}

