/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.index;

import guideme.internal.shaded.lucene.codecs.DocValuesProducer;
import guideme.internal.shaded.lucene.codecs.FieldsProducer;
import guideme.internal.shaded.lucene.codecs.KnnVectorsReader;
import guideme.internal.shaded.lucene.codecs.NormsProducer;
import guideme.internal.shaded.lucene.codecs.PointsReader;
import guideme.internal.shaded.lucene.codecs.StoredFieldsReader;
import guideme.internal.shaded.lucene.codecs.TermVectorsReader;
import guideme.internal.shaded.lucene.index.BinaryDocValues;
import guideme.internal.shaded.lucene.index.ByteVectorValues;
import guideme.internal.shaded.lucene.index.DocValuesSkipIndexType;
import guideme.internal.shaded.lucene.index.DocValuesSkipper;
import guideme.internal.shaded.lucene.index.DocValuesType;
import guideme.internal.shaded.lucene.index.FieldInfo;
import guideme.internal.shaded.lucene.index.FloatVectorValues;
import guideme.internal.shaded.lucene.index.IndexOptions;
import guideme.internal.shaded.lucene.index.LeafReader;
import guideme.internal.shaded.lucene.index.NumericDocValues;
import guideme.internal.shaded.lucene.index.PointValues;
import guideme.internal.shaded.lucene.index.SortedDocValues;
import guideme.internal.shaded.lucene.index.SortedNumericDocValues;
import guideme.internal.shaded.lucene.index.SortedSetDocValues;
import guideme.internal.shaded.lucene.index.StoredFieldVisitor;
import guideme.internal.shaded.lucene.index.StoredFields;
import guideme.internal.shaded.lucene.index.Terms;
import guideme.internal.shaded.lucene.index.VectorEncoding;
import java.io.IOException;
import java.util.Objects;

public abstract class CodecReader
extends LeafReader {
    protected CodecReader() {
    }

    public abstract StoredFieldsReader getFieldsReader();

    public abstract TermVectorsReader getTermVectorsReader();

    public abstract NormsProducer getNormsReader();

    public abstract DocValuesProducer getDocValuesReader();

    public abstract FieldsProducer getPostingsReader();

    public abstract PointsReader getPointsReader();

    public abstract KnnVectorsReader getVectorReader();

    @Override
    public final StoredFields storedFields() throws IOException {
        final StoredFieldsReader reader = this.getFieldsReader();
        return new StoredFields(){

            @Override
            public void document(int docID, StoredFieldVisitor visitor) throws IOException {
                Objects.checkIndex(docID, CodecReader.this.maxDoc());
                reader.document(docID, visitor);
            }
        };
    }

    @Override
    public final Terms terms(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null || fi.getIndexOptions() == IndexOptions.NONE) {
            return null;
        }
        return this.getPostingsReader().terms(field);
    }

    private FieldInfo getDVField(String field, DocValuesType type) {
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null) {
            return null;
        }
        if (fi.getDocValuesType() == DocValuesType.NONE) {
            return null;
        }
        if (fi.getDocValuesType() != type) {
            return null;
        }
        return fi;
    }

    @Override
    public final NumericDocValues getNumericDocValues(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getDVField(field, DocValuesType.NUMERIC);
        if (fi == null) {
            return null;
        }
        return this.getDocValuesReader().getNumeric(fi);
    }

    @Override
    public final BinaryDocValues getBinaryDocValues(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getDVField(field, DocValuesType.BINARY);
        if (fi == null) {
            return null;
        }
        return this.getDocValuesReader().getBinary(fi);
    }

    @Override
    public final SortedDocValues getSortedDocValues(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getDVField(field, DocValuesType.SORTED);
        if (fi == null) {
            return null;
        }
        return this.getDocValuesReader().getSorted(fi);
    }

    @Override
    public final SortedNumericDocValues getSortedNumericDocValues(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getDVField(field, DocValuesType.SORTED_NUMERIC);
        if (fi == null) {
            return null;
        }
        return this.getDocValuesReader().getSortedNumeric(fi);
    }

    @Override
    public final SortedSetDocValues getSortedSetDocValues(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getDVField(field, DocValuesType.SORTED_SET);
        if (fi == null) {
            return null;
        }
        return this.getDocValuesReader().getSortedSet(fi);
    }

    @Override
    public final DocValuesSkipper getDocValuesSkipper(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null || fi.docValuesSkipIndexType() == DocValuesSkipIndexType.NONE) {
            return null;
        }
        return this.getDocValuesReader().getSkipper(fi);
    }

    @Override
    public final NumericDocValues getNormValues(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null || !fi.hasNorms()) {
            return null;
        }
        return this.getNormsReader().getNorms(fi);
    }

    @Override
    public final PointValues getPointValues(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null || fi.getPointDimensionCount() == 0) {
            return null;
        }
        return this.getPointsReader().getValues(field);
    }

    @Override
    public final FloatVectorValues getFloatVectorValues(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null || fi.getVectorDimension() == 0 || fi.getVectorEncoding() != VectorEncoding.FLOAT32) {
            return null;
        }
        return this.getVectorReader().getFloatVectorValues(field);
    }

    @Override
    public final ByteVectorValues getByteVectorValues(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null || fi.getVectorDimension() == 0 || fi.getVectorEncoding() != VectorEncoding.BYTE) {
            return null;
        }
        return this.getVectorReader().getByteVectorValues(field);
    }

    @Override
    protected void doClose() throws IOException {
    }
}

