/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.analysis.nl;

import guideme.internal.shaded.lucene.analysis.Analyzer;
import guideme.internal.shaded.lucene.analysis.CharArrayMap;
import guideme.internal.shaded.lucene.analysis.CharArraySet;
import guideme.internal.shaded.lucene.analysis.LowerCaseFilter;
import guideme.internal.shaded.lucene.analysis.StopFilter;
import guideme.internal.shaded.lucene.analysis.TokenFilter;
import guideme.internal.shaded.lucene.analysis.TokenStream;
import guideme.internal.shaded.lucene.analysis.WordlistLoader;
import guideme.internal.shaded.lucene.analysis.miscellaneous.SetKeywordMarkerFilter;
import guideme.internal.shaded.lucene.analysis.miscellaneous.StemmerOverrideFilter;
import guideme.internal.shaded.lucene.analysis.snowball.SnowballFilter;
import guideme.internal.shaded.lucene.analysis.standard.StandardTokenizer;
import guideme.internal.shaded.lucene.util.CharsRefBuilder;
import guideme.internal.shaded.lucene.util.IOUtils;
import guideme.internal.shaded.snowball.ext.DutchStemmer;
import java.io.IOException;
import java.io.UncheckedIOException;

public final class DutchAnalyzer
extends Analyzer {
    private final CharArraySet stoptable;
    private final CharArraySet excltable;
    private final StemmerOverrideFilter.StemmerOverrideMap stemdict;

    public DutchAnalyzer() {
        this(DefaultSetHolder.DEFAULT_STOP_SET, CharArraySet.EMPTY_SET, DefaultSetHolder.DEFAULT_STEM_DICT);
    }

    public DutchAnalyzer(CharArraySet stopwords, CharArraySet stemExclusionTable, CharArrayMap<String> stemOverrideDict) {
        this.stoptable = CharArraySet.unmodifiableSet(CharArraySet.copy(stopwords));
        this.excltable = CharArraySet.unmodifiableSet(CharArraySet.copy(stemExclusionTable));
        if (stemOverrideDict.isEmpty()) {
            this.stemdict = null;
        } else {
            StemmerOverrideFilter.Builder builder = new StemmerOverrideFilter.Builder(false);
            CharArrayMap.EntryIterator iter = stemOverrideDict.entrySet().iterator();
            CharsRefBuilder spare = new CharsRefBuilder();
            while (iter.hasNext()) {
                char[] nextKey = iter.nextKey();
                spare.copyChars(nextKey, 0, nextKey.length);
                builder.add(spare.get(), (CharSequence)iter.currentValue());
            }
            try {
                this.stemdict = builder.build();
            }
            catch (IOException ex) {
                throw new RuntimeException("can not build stem dict", ex);
            }
        }
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        StandardTokenizer source = new StandardTokenizer();
        TokenFilter result = new LowerCaseFilter(source);
        result = new StopFilter(result, this.stoptable);
        if (!this.excltable.isEmpty()) {
            result = new SetKeywordMarkerFilter(result, this.excltable);
        }
        if (this.stemdict != null) {
            result = new StemmerOverrideFilter(result, this.stemdict);
        }
        result = new SnowballFilter(result, new DutchStemmer());
        return new Analyzer.TokenStreamComponents(source, (TokenStream)result);
    }

    @Override
    protected TokenStream normalize(String fieldName, TokenStream in) {
        return new LowerCaseFilter(in);
    }

    private static class DefaultSetHolder {
        static final CharArraySet DEFAULT_STOP_SET;
        static final CharArrayMap<String> DEFAULT_STEM_DICT;

        static {
            try {
                DEFAULT_STOP_SET = WordlistLoader.getSnowballWordSet(IOUtils.requireResourceNonNull(SnowballFilter.class.getResourceAsStream("dutch_stop.txt"), "dutch_stop.txt"));
            }
            catch (IOException ex) {
                throw new UncheckedIOException("Unable to load default stopword set", ex);
            }
            DEFAULT_STEM_DICT = new CharArrayMap(4, false);
            DEFAULT_STEM_DICT.put("fiets", "fiets");
            DEFAULT_STEM_DICT.put("bromfiets", "bromfiets");
            DEFAULT_STEM_DICT.put("ei", "eier");
            DEFAULT_STEM_DICT.put("kind", "kinder");
        }
    }
}

