/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.flatbuffers;

import guideme.internal.shaded.flatbuffers.Utf8;
import java.nio.ByteBuffer;

public final class Utf8Safe
extends Utf8 {
    private static int computeEncodedLength(CharSequence sequence) {
        int i;
        int utf16Length;
        int utf8Length = utf16Length = sequence.length();
        for (i = 0; i < utf16Length && sequence.charAt(i) < '\u0080'; ++i) {
        }
        while (i < utf16Length) {
            char c = sequence.charAt(i);
            if (c < '\u0800') {
                utf8Length += 127 - c >>> 31;
            } else {
                utf8Length += Utf8Safe.encodedLengthGeneral(sequence, i);
                break;
            }
            ++i;
        }
        if (utf8Length < utf16Length) {
            throw new IllegalArgumentException("UTF-8 length does not fit in int: " + ((long)utf8Length + 0x100000000L));
        }
        return utf8Length;
    }

    private static int encodedLengthGeneral(CharSequence sequence, int start) {
        int utf16Length = sequence.length();
        int utf8Length = 0;
        for (int i = start; i < utf16Length; ++i) {
            char c = sequence.charAt(i);
            if (c < '\u0800') {
                utf8Length += 127 - c >>> 31;
                continue;
            }
            utf8Length += 2;
            if ('\ud800' > c || c > '\udfff') continue;
            int cp = Character.codePointAt(sequence, i);
            if (cp < 65536) {
                throw new UnpairedSurrogateException(i, utf16Length);
            }
            ++i;
        }
        return utf8Length;
    }

    @Override
    public int encodedLength(CharSequence in) {
        return Utf8Safe.computeEncodedLength(in);
    }

    private static void encodeUtf8Buffer(CharSequence in, ByteBuffer out) {
        int inIx;
        int inLength = in.length();
        int outIx = out.position();
        try {
            char c;
            for (inIx = 0; inIx < inLength && (c = in.charAt(inIx)) < '\u0080'; ++inIx) {
                out.put(outIx + inIx, (byte)c);
            }
            if (inIx == inLength) {
                out.position(outIx + inIx);
                return;
            }
            outIx += inIx;
            while (inIx < inLength) {
                c = in.charAt(inIx);
                if (c < '\u0080') {
                    out.put(outIx, (byte)c);
                } else if (c < '\u0800') {
                    out.put(outIx++, (byte)(0xC0 | c >>> 6));
                    out.put(outIx, (byte)(0x80 | 0x3F & c));
                } else if (c < '\ud800' || '\udfff' < c) {
                    out.put(outIx++, (byte)(0xE0 | c >>> 12));
                    out.put(outIx++, (byte)(0x80 | 0x3F & c >>> 6));
                    out.put(outIx, (byte)(0x80 | 0x3F & c));
                } else {
                    char low;
                    if (inIx + 1 == inLength || !Character.isSurrogatePair(c, low = in.charAt(++inIx))) {
                        throw new UnpairedSurrogateException(inIx, inLength);
                    }
                    int codePoint = Character.toCodePoint(c, low);
                    out.put(outIx++, (byte)(0xF0 | codePoint >>> 18));
                    out.put(outIx++, (byte)(0x80 | 0x3F & codePoint >>> 12));
                    out.put(outIx++, (byte)(0x80 | 0x3F & codePoint >>> 6));
                    out.put(outIx, (byte)(0x80 | 0x3F & codePoint));
                }
                ++inIx;
                ++outIx;
            }
            out.position(outIx);
        }
        catch (IndexOutOfBoundsException e) {
            int badWriteIndex = out.position() + Math.max(inIx, outIx - out.position() + 1);
            throw new ArrayIndexOutOfBoundsException("Failed writing " + in.charAt(inIx) + " at index " + badWriteIndex);
        }
    }

    private static int encodeUtf8Array(CharSequence in, byte[] out, int offset, int length) {
        char c;
        int i;
        int utf16Length = in.length();
        int j = offset;
        int limit = offset + length;
        for (i = 0; i < utf16Length && i + j < limit && (c = in.charAt(i)) < '\u0080'; ++i) {
            out[j + i] = (byte)c;
        }
        if (i == utf16Length) {
            return j + utf16Length;
        }
        j += i;
        while (i < utf16Length) {
            c = in.charAt(i);
            if (c < '\u0080' && j < limit) {
                out[j++] = (byte)c;
            } else if (c < '\u0800' && j <= limit - 2) {
                out[j++] = (byte)(0x3C0 | c >>> 6);
                out[j++] = (byte)(0x80 | 0x3F & c);
            } else if ((c < '\ud800' || '\udfff' < c) && j <= limit - 3) {
                out[j++] = (byte)(0x1E0 | c >>> 12);
                out[j++] = (byte)(0x80 | 0x3F & c >>> 6);
                out[j++] = (byte)(0x80 | 0x3F & c);
            } else if (j <= limit - 4) {
                char low;
                if (i + 1 == in.length() || !Character.isSurrogatePair(c, low = in.charAt(++i))) {
                    throw new UnpairedSurrogateException(i - 1, utf16Length);
                }
                int codePoint = Character.toCodePoint(c, low);
                out[j++] = (byte)(0xF0 | codePoint >>> 18);
                out[j++] = (byte)(0x80 | 0x3F & codePoint >>> 12);
                out[j++] = (byte)(0x80 | 0x3F & codePoint >>> 6);
                out[j++] = (byte)(0x80 | 0x3F & codePoint);
            } else {
                if (!('\ud800' > c || c > '\udfff' || i + 1 != in.length() && Character.isSurrogatePair(c, in.charAt(i + 1)))) {
                    throw new UnpairedSurrogateException(i, utf16Length);
                }
                throw new ArrayIndexOutOfBoundsException("Failed writing " + c + " at index " + j);
            }
            ++i;
        }
        return j;
    }

    @Override
    public void encodeUtf8(CharSequence in, ByteBuffer out) {
        if (out.hasArray()) {
            int start = out.arrayOffset();
            int end = Utf8Safe.encodeUtf8Array(in, out.array(), start + out.position(), out.remaining());
            out.position(end - start);
        } else {
            Utf8Safe.encodeUtf8Buffer(in, out);
        }
    }

    static class UnpairedSurrogateException
    extends IllegalArgumentException {
        UnpairedSurrogateException(int index, int length) {
            super("Unpaired surrogate at index " + index + " of " + length);
        }
    }
}

