/*
 * Decompiled with CFR 0.152.
 */
package guideme.libs.micromark.html;

import guideme.libs.micromark.ListUtils;
import guideme.libs.micromark.NamedCharacterEntities;
import guideme.libs.micromark.NormalizeIdentifier;
import guideme.libs.micromark.Token;
import guideme.libs.micromark.Tokenizer;
import guideme.libs.micromark.html.CompileOptions;
import guideme.libs.micromark.html.HtmlContext;
import guideme.libs.micromark.html.HtmlContextProperty;
import guideme.libs.micromark.html.HtmlEncode;
import guideme.libs.micromark.html.HtmlExtension;
import guideme.libs.micromark.html.NumericCharacterReference;
import guideme.libs.micromark.html.SanitizeUri;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public class HtmlCompiler {
    private static final Pattern protocolHref = Pattern.compile("^(https?|ircs?|mailto|xmpp)$", 2);
    private static final Pattern protocolSrc = Pattern.compile("^https?$", 2);
    private final CompileOptions options;
    private boolean tags = true;
    private final Map<String, Media> definitions = new HashMap<String, Media>();
    private final List<List<String>> buffers = new ArrayList<ArrayList<List<String>>>(List.of(new ArrayList()));
    private final List<Media> mediaStack = new ArrayList<Media>();
    private final List<Boolean> tightStack = new ArrayList<Boolean>();
    private final HtmlExtension defaultHandlers = HtmlExtension.builder().enter("blockQuote", this::onenterblockquote).enter("codeFenced", this::onentercodefenced).enter("codeFencedFenceInfo", this::buffer).enter("codeFencedFenceMeta", this::buffer).enter("codeIndented", this::onentercodeindented).enter("codeText", this::onentercodetext).enter("content", this::onentercontent).enter("definition", this::onenterdefinition).enter("definitionDestinationString", this::onenterdefinitiondestinationstring).enter("definitionLabelString", this::buffer).enter("definitionTitleString", this::buffer).enter("emphasis", this::onenteremphasis).enter("htmlFlow", this::onenterhtmlflow).enter("htmlText", this::onenterhtml).enter("image", this::onenterimage).enter("label", this::buffer).enter("link", this::onenterlink).enter("listItemMarker", this::onenterlistitemmarker).enter("listItemValue", this::onenterlistitemvalue).enter("listOrdered", this::onenterlistordered).enter("listUnordered", this::onenterlistunordered).enter("paragraph", this::onenterparagraph).enter("reference", this::buffer).enter("resource", this::onenterresource).enter("resourceDestinationString", this::onenterresourcedestinationstring).enter("resourceTitleString", this::buffer).enter("setextHeading", this::onentersetextheading).enter("strong", this::onenterstrong).exit("atxHeading", this::onexitatxheading).exit("atxHeadingSequence", this::onexitatxheadingsequence).exit("autolinkEmail", this::onexitautolinkemail).exit("autolinkProtocol", this::onexitautolinkprotocol).exit("blockQuote", this::onexitblockquote).exit("characterEscapeValue", this::onexitdata).exit("characterReferenceMarkerHexadecimal", this::onexitcharacterreferencemarker).exit("characterReferenceMarkerNumeric", this::onexitcharacterreferencemarker).exit("characterReferenceValue", this::onexitcharacterreferencevalue).exit("codeFenced", this::onexitflowcode).exit("codeFencedFence", this::onexitcodefencedfence).exit("codeFencedFenceInfo", this::onexitcodefencedfenceinfo).exit("codeFencedFenceMeta", this::resume).exit("codeFlowValue", this::onexitcodeflowvalue).exit("codeIndented", this::onexitflowcode).exit("codeText", this::onexitcodetext).exit("codeTextData", this::onexitdata).exit("data", this::onexitdata).exit("definition", this::onexitdefinition).exit("definitionDestinationString", this::onexitdefinitiondestinationstring).exit("definitionLabelString", this::onexitdefinitionlabelstring).exit("definitionTitleString", this::onexitdefinitiontitlestring).exit("emphasis", this::onexitemphasis).exit("hardBreakEscape", this::onexithardbreak).exit("hardBreakTrailing", this::onexithardbreak).exit("htmlFlow", this::onexithtml).exit("htmlFlowData", this::onexitdata).exit("htmlText", this::onexithtml).exit("htmlTextData", this::onexitdata).exit("image", this::onexitmedia).exit("label", this::onexitlabel).exit("labelText", this::onexitlabeltext).exit("lineEnding", this::onexitlineending).exit("link", this::onexitmedia).exit("listOrdered", this::onexitlistordered).exit("listUnordered", this::onexitlistunordered).exit("paragraph", this::onexitparagraph).exit("reference", this::resume).exit("referenceString", this::onexitreferencestring).exit("resource", this::resume).exit("resourceDestinationString", this::onexitresourcedestinationstring).exit("resourceTitleString", this::onexitresourcetitlestring).exit("setextHeading", this::onexitsetextheading).exit("setextHeadingLineSequence", this::onexitsetextheadinglinesequence).exit("setextHeadingText", this::onexitsetextheadingtext).exit("strong", this::onexitstrong).exit("thematicBreak", this::onexitthematicbreak).build();
    HtmlExtension handlers;
    CompileData data = new CompileData();
    Map<HtmlContextProperty<?>, Object> extensionData;
    String lineEndingStyle;

    public HtmlCompiler() {
        this(new CompileOptions());
    }

    public HtmlCompiler(CompileOptions options) {
        this.options = options;
        if (options.getExtensions().isEmpty()) {
            this.handlers = this.defaultHandlers;
        } else {
            HtmlExtension.Builder builder = HtmlExtension.builder().addAll(this.defaultHandlers).enterDocument(this.defaultHandlers.enterDocument).exitDocument(this.defaultHandlers.exitDocument);
            for (HtmlExtension extension : options.getExtensions()) {
                builder.addAll(extension);
                if (extension.enterDocument != null) {
                    builder.enterDocument(extension.enterDocument);
                }
                if (extension.exitDocument == null) continue;
                builder.exitDocument(extension.exitDocument);
            }
            this.handlers = builder.build();
        }
        this.lineEndingStyle = options.getDefaultLineEnding();
    }

    public String compile(List<Tokenizer.Event> events) {
        int index = -1;
        int start = 0;
        ArrayList<Integer> listStack = new ArrayList<Integer>();
        List<Object> head = new ArrayList();
        List<Object> body = new ArrayList();
        while (++index < events.size()) {
            Tokenizer.Event event = events.get(index);
            Token token = event.token();
            if (this.lineEndingStyle == null && (token.type.equals("lineEnding") || token.type.equals("lineEndingBlank"))) {
                this.lineEndingStyle = event.context().sliceSerialize(token);
            }
            if (token.type.equals("listOrdered") || token.type.equals("listUnordered")) {
                if (event.isEnter()) {
                    listStack.add(index);
                } else {
                    this.prepareList(ListUtils.slice(events, (Integer)listStack.remove(listStack.size() - 1), index));
                }
            }
            if (!token.type.equals("definition")) continue;
            if (event.isEnter()) {
                body = ListUtils.push(body, ListUtils.slice(events, start, index));
                start = index;
                continue;
            }
            head = ListUtils.push(head, ListUtils.slice(events, start, index + 1));
            start = index + 1;
        }
        head = ListUtils.push(head, body);
        List<Object> result = head = ListUtils.push(head, ListUtils.slice(events, start, events.size()));
        Context context = new Context();
        if (this.handlers.enterDocument != null) {
            this.handlers.enterDocument.handle(context);
        }
        for (Tokenizer.Event event : result) {
            Token token = event.token();
            Map<String, HtmlExtension.Handler> typeHandlers = event.isEnter() ? this.handlers.enter : this.handlers.exit;
            HtmlExtension.Handler handler = typeHandlers.get(token.type);
            if (handler == null) continue;
            context.event = event;
            handler.handle(context, token);
            context.event = null;
        }
        if (this.handlers.exitDocument != null) {
            this.handlers.exitDocument.handle(context);
        }
        return String.join((CharSequence)"", (Iterable<? extends CharSequence>)this.buffers.get(0));
    }

    private void prepareList(List<Tokenizer.Event> slice) {
        int length = slice.size();
        int index = 0;
        int containerBalance = 0;
        boolean loose = false;
        boolean atMarker = false;
        block10: while (++index < length) {
            Tokenizer.Event event = slice.get(index);
            Token token = event.token();
            if (token._container) {
                atMarker = false;
                if (event.isEnter()) {
                    ++containerBalance;
                    continue;
                }
                --containerBalance;
                continue;
            }
            switch (token.type) {
                case "listItemPrefix": {
                    if (!event.isExit()) continue block10;
                    atMarker = true;
                    continue block10;
                }
                case "linePrefix": {
                    continue block10;
                }
                case "lineEndingBlank": {
                    if (!event.isEnter() || containerBalance != 0) continue block10;
                    if (atMarker) {
                        atMarker = false;
                        continue block10;
                    }
                    loose = true;
                    continue block10;
                }
            }
            atMarker = false;
        }
        slice.get((int)0).token()._loose = loose;
    }

    private void buffer() {
        this.buffers.add(new ArrayList());
    }

    private String resume() {
        List<String> buf = this.buffers.remove(this.buffers.size() - 1);
        return String.join((CharSequence)"", buf);
    }

    private void tag(String value) {
        if (!this.tags) {
            return;
        }
        this.data.lastWasTag = true;
        this.buffers.get(this.buffers.size() - 1).add(value);
    }

    private void raw(String value) {
        this.data.lastWasTag = false;
        this.buffers.get(this.buffers.size() - 1).add(value);
    }

    private void lineEnding() {
        this.raw(Objects.requireNonNullElse(this.lineEndingStyle, "\n"));
    }

    private void lineEndingIfNeeded() {
        Character previous;
        List<String> buffer = this.buffers.get(this.buffers.size() - 1);
        String slice = !buffer.isEmpty() ? buffer.get(buffer.size() - 1) : null;
        Character c = previous = slice != null ? Character.valueOf(slice.charAt(slice.length() - 1)) : null;
        if (previous == null || previous.charValue() == '\n' || previous.charValue() == '\r') {
            return;
        }
        this.lineEnding();
    }

    private String encode(String value) {
        return this.data.ignoreEncode ? value : HtmlEncode.encode(value);
    }

    private void onenterlistordered(HtmlContext context, Token token) {
        this.tightStack.add(!token._loose);
        this.lineEndingIfNeeded();
        this.tag("<ol");
        this.data.expectFirstItem = true;
    }

    private void onenterlistunordered(HtmlContext context, Token token) {
        this.tightStack.add(!token._loose);
        this.lineEndingIfNeeded();
        this.tag("<ul");
        this.data.expectFirstItem = true;
    }

    private void onenterlistitemvalue(HtmlContext context, Token token) {
        int value;
        if (this.data.expectFirstItem && (value = Integer.parseInt(context.sliceSerialize(token), 10)) != 1) {
            this.tag(" start=\"" + this.encode(String.valueOf(value)) + "\"");
        }
    }

    private void onenterlistitemmarker() {
        if (this.data.expectFirstItem) {
            this.tag(">");
        } else {
            this.onexitlistitem();
        }
        this.lineEndingIfNeeded();
        this.tag("<li>");
        this.data.expectFirstItem = false;
        this.data.lastWasTag = false;
    }

    private void onexitlistordered() {
        this.onexitlistitem();
        this.tightStack.remove(this.tightStack.size() - 1);
        this.lineEnding();
        this.tag("</ol>");
    }

    private void onexitlistunordered() {
        this.onexitlistitem();
        this.tightStack.remove(this.tightStack.size() - 1);
        this.lineEnding();
        this.tag("</ul>");
    }

    private void onexitlistitem() {
        if (this.data.lastWasTag && !this.data.slurpAllLineEndings) {
            this.lineEndingIfNeeded();
        }
        this.tag("</li>");
        this.data.slurpAllLineEndings = false;
    }

    private void onenterblockquote() {
        this.tightStack.add(false);
        this.lineEndingIfNeeded();
        this.tag("<blockquote>");
    }

    private void onexitblockquote() {
        this.tightStack.remove(this.tightStack.size() - 1);
        this.lineEndingIfNeeded();
        this.tag("</blockquote>");
        this.data.slurpAllLineEndings = false;
    }

    private void onenterparagraph() {
        if (this.tightStack.isEmpty() || !this.tightStack.get(this.tightStack.size() - 1).booleanValue()) {
            this.lineEndingIfNeeded();
            this.tag("<p>");
        }
        this.data.slurpAllLineEndings = false;
    }

    private void onexitparagraph() {
        if (!this.tightStack.isEmpty() && this.tightStack.get(this.tightStack.size() - 1).booleanValue()) {
            this.data.slurpAllLineEndings = true;
        } else {
            this.tag("</p>");
        }
    }

    private void onentercodefenced() {
        this.lineEndingIfNeeded();
        this.tag("<pre><code");
        this.data.fencesCount = 0;
    }

    private void onexitcodefencedfenceinfo() {
        String value = this.resume();
        this.tag(" class=\"language-" + value + "\"");
    }

    private void onexitcodefencedfence() {
        int count = Objects.requireNonNullElse(this.data.fencesCount, 0);
        if (count == 0) {
            this.tag(">");
            this.data.slurpOneLineEnding = true;
        }
        this.data.fencesCount = count + 1;
    }

    private void onentercodeindented() {
        this.lineEndingIfNeeded();
        this.tag("<pre><code>");
    }

    private void onexitflowcode() {
        Integer count = this.data.fencesCount;
        if (count != null && count < 2 && !this.tightStack.isEmpty() && !this.data.lastWasTag) {
            this.lineEnding();
        }
        if (this.data.flowCodeSeenData) {
            this.lineEndingIfNeeded();
        }
        this.tag("</code></pre>");
        if (count != null && count < 2) {
            this.lineEndingIfNeeded();
        }
        this.data.flowCodeSeenData = false;
        this.data.fencesCount = null;
        this.data.slurpOneLineEnding = false;
    }

    private void onenterimage() {
        Media media = new Media();
        media.image = true;
        this.mediaStack.add(media);
        this.tags = false;
    }

    private void onenterlink() {
        this.mediaStack.add(new Media());
    }

    private void onexitlabeltext(HtmlContext context, Token token) {
        this.mediaStack.get((int)(this.mediaStack.size() - 1)).labelId = context.sliceSerialize(token);
    }

    private void onexitlabel() {
        this.mediaStack.get((int)(this.mediaStack.size() - 1)).label = this.resume();
    }

    private void onexitreferencestring(HtmlContext context, Token token) {
        this.mediaStack.get((int)(this.mediaStack.size() - 1)).referenceId = context.sliceSerialize(token);
    }

    private void onenterresource() {
        this.buffer();
        this.mediaStack.get((int)(this.mediaStack.size() - 1)).destination = "";
    }

    private void onenterresourcedestinationstring() {
        this.buffer();
        this.data.ignoreEncode = true;
    }

    private void onexitresourcedestinationstring() {
        this.mediaStack.get((int)(this.mediaStack.size() - 1)).destination = this.resume();
        this.data.ignoreEncode = false;
    }

    private void onexitresourcetitlestring() {
        this.mediaStack.get((int)(this.mediaStack.size() - 1)).title = this.resume();
    }

    private void onexitmedia() {
        int index = this.mediaStack.size() - 1;
        Media media = this.mediaStack.get(index);
        String id = Objects.requireNonNullElse(media.referenceId, media.labelId);
        Media context = media.destination == null ? this.definitions.get(NormalizeIdentifier.normalizeIdentifier(id)) : media;
        this.tags = true;
        while (index-- > 0) {
            if (!this.mediaStack.get((int)index).image) continue;
            this.tags = false;
            break;
        }
        if (media.image) {
            this.tag("<img src=\"" + SanitizeUri.sanitizeUri(context.destination, this.options.isAllowDangerousProtocol() ? null : protocolSrc) + "\" alt=\"");
            this.raw(media.label);
            this.tag("\"");
        } else {
            this.tag("<a href=\"" + SanitizeUri.sanitizeUri(context.destination, this.options.isAllowDangerousProtocol() ? null : protocolHref) + "\"");
        }
        this.tag((String)(context.title != null ? " title=\"" + context.title + "\"" : ""));
        if (media.image) {
            this.tag(" />");
        } else {
            this.tag(">");
            this.raw(media.label);
            this.tag("</a>");
        }
        this.mediaStack.remove(this.mediaStack.size() - 1);
    }

    private void onenterdefinition() {
        this.buffer();
        this.mediaStack.add(new Media());
    }

    private void onexitdefinitionlabelstring(HtmlContext context, Token token) {
        this.resume();
        this.mediaStack.get((int)(this.mediaStack.size() - 1)).labelId = context.sliceSerialize(token);
    }

    private void onenterdefinitiondestinationstring() {
        this.buffer();
        this.data.ignoreEncode = true;
    }

    private void onexitdefinitiondestinationstring() {
        this.mediaStack.get((int)(this.mediaStack.size() - 1)).destination = this.resume();
        this.data.ignoreEncode = false;
    }

    private void onexitdefinitiontitlestring() {
        this.mediaStack.get((int)(this.mediaStack.size() - 1)).title = this.resume();
    }

    private void onexitdefinition() {
        Media media = this.mediaStack.get(this.mediaStack.size() - 1);
        String id = NormalizeIdentifier.normalizeIdentifier(media.labelId);
        this.resume();
        if (!this.definitions.containsKey(id)) {
            this.definitions.put(id, this.mediaStack.get(this.mediaStack.size() - 1));
        }
        this.mediaStack.remove(this.mediaStack.size() - 1);
    }

    private void onentercontent() {
        this.data.slurpAllLineEndings = true;
    }

    private void onexitatxheadingsequence(HtmlContext context, Token token) {
        if (this.data.headingRank != 0) {
            return;
        }
        this.data.headingRank = context.sliceSerialize(token).length();
        this.lineEndingIfNeeded();
        this.tag("<h" + this.data.headingRank + ">");
    }

    private void onentersetextheading() {
        this.buffer();
        this.data.slurpAllLineEndings = false;
    }

    private void onexitsetextheadingtext() {
        this.data.slurpAllLineEndings = true;
    }

    private void onexitatxheading() {
        this.tag("</h" + this.data.headingRank + ">");
        this.data.headingRank = 0;
    }

    private void onexitsetextheadinglinesequence(HtmlContext context, Token token) {
        this.data.headingRank = context.sliceSerialize(token).charAt(0) == '=' ? 1 : 2;
    }

    private void onexitsetextheading() {
        String value = this.resume();
        this.lineEndingIfNeeded();
        this.tag("<h" + this.data.headingRank + ">");
        this.raw(value);
        this.tag("</h" + this.data.headingRank + ">");
        this.data.slurpAllLineEndings = false;
        this.data.headingRank = 0;
    }

    private void onexitdata(HtmlContext context, Token token) {
        this.raw(this.encode(context.sliceSerialize(token)));
    }

    private void onexitlineending(HtmlContext context, Token token) {
        if (this.data.slurpAllLineEndings) {
            return;
        }
        if (this.data.slurpOneLineEnding) {
            this.data.slurpOneLineEnding = false;
            return;
        }
        if (this.data.inCodeText) {
            this.raw(" ");
            return;
        }
        this.raw(this.encode(context.sliceSerialize(token)));
    }

    private void onexitcodeflowvalue(HtmlContext context, Token token) {
        this.raw(this.encode(context.sliceSerialize(token)));
        this.data.flowCodeSeenData = true;
    }

    private void onexithardbreak() {
        this.tag("<br />");
    }

    private void onenterhtmlflow() {
        this.lineEndingIfNeeded();
        this.onenterhtml();
    }

    private void onexithtml() {
        this.data.ignoreEncode = false;
    }

    private void onenterhtml() {
        if (this.options.isAllowDangerousHtml()) {
            this.data.ignoreEncode = true;
        }
    }

    private void onenteremphasis() {
        this.tag("<em>");
    }

    private void onenterstrong() {
        this.tag("<strong>");
    }

    private void onentercodetext() {
        this.data.inCodeText = true;
        this.tag("<code>");
    }

    private void onexitcodetext() {
        this.data.inCodeText = false;
        this.tag("</code>");
    }

    private void onexitemphasis() {
        this.tag("</em>");
    }

    private void onexitstrong() {
        this.tag("</strong>");
    }

    private void onexitthematicbreak() {
        this.lineEndingIfNeeded();
        this.tag("<hr />");
    }

    private void onexitcharacterreferencemarker(HtmlContext context, Token token) {
        this.data.characterReferenceType = token.type;
    }

    private void onexitcharacterreferencevalue(HtmlContext context, Token token) {
        String value = context.sliceSerialize(token);
        value = this.data.characterReferenceType != null ? NumericCharacterReference.decodeNumericCharacterReference(value, this.data.characterReferenceType.equals("characterReferenceMarkerNumeric") ? 10 : 16) : NamedCharacterEntities.decodeNamedCharacterReference(value);
        this.raw(this.encode(value));
        this.data.characterReferenceType = null;
    }

    private void onexitautolinkprotocol(HtmlContext context, Token token) {
        String uri = context.sliceSerialize(token);
        this.tag("<a href=\"" + SanitizeUri.sanitizeUri(uri, this.options.isAllowDangerousProtocol() ? null : protocolHref) + "\">");
        this.raw(this.encode(uri));
        this.tag("</a>");
    }

    private void onexitautolinkemail(HtmlContext context, Token token) {
        String uri = context.sliceSerialize(token);
        this.tag("<a href=\"" + SanitizeUri.sanitizeUri("mailto:" + uri, null) + "\">");
        this.raw(this.encode(uri));
        this.tag("</a>");
    }

    public static class CompileData {
        public boolean lastWasTag;
        public boolean expectFirstItem;
        public boolean slurpOneLineEnding;
        public boolean slurpAllLineEndings;
        public boolean fencedCodeInside;
        public Integer fencesCount;
        public boolean flowCodeSeenData;
        public boolean ignoreEncode;
        public int headingRank;
        public boolean inCodeText;
        public String characterReferenceType;
    }

    class Context
    implements HtmlContext {
        Tokenizer.Event event;

        Context() {
        }

        @Override
        public CompileOptions getOptions() {
            return HtmlCompiler.this.options;
        }

        @Override
        @Nullable
        public <T> T get(HtmlContextProperty<T> property) {
            if (HtmlCompiler.this.extensionData == null) {
                return null;
            }
            return (T)HtmlCompiler.this.extensionData.get(property);
        }

        @Override
        public <T> void set(HtmlContextProperty<T> property, T value) {
            if (HtmlCompiler.this.extensionData == null) {
                HtmlCompiler.this.extensionData = new IdentityHashMap();
            }
            HtmlCompiler.this.extensionData.put(property, value);
        }

        @Override
        public void remove(HtmlContextProperty<?> property) {
            if (HtmlCompiler.this.extensionData != null) {
                HtmlCompiler.this.extensionData.remove(property);
                HtmlCompiler.this.extensionData = null;
            }
        }

        @Override
        public void lineEndingIfNeeded() {
            HtmlCompiler.this.lineEndingIfNeeded();
        }

        @Override
        public String encode(String value) {
            return HtmlCompiler.this.encode(value);
        }

        @Override
        public void buffer() {
            HtmlCompiler.this.buffer();
        }

        @Override
        public String resume() {
            return HtmlCompiler.this.resume();
        }

        @Override
        public void raw(String value) {
            HtmlCompiler.this.raw(value);
        }

        @Override
        public void tag(String value) {
            HtmlCompiler.this.tag(value);
        }

        @Override
        public String sliceSerialize(Token token) {
            return this.event.context().sliceSerialize(token);
        }

        @Override
        public void setSlurpOneLineEnding(boolean enable) {
            HtmlCompiler.this.data.slurpOneLineEnding = enable;
        }

        @Override
        public void setSlurpAllLineEndings(boolean enable) {
            HtmlCompiler.this.data.slurpAllLineEndings = enable;
        }
    }

    private static final class Media {
        boolean image;
        String labelId;
        String label;
        String referenceId;
        String destination;
        String title;

        private Media() {
        }
    }
}

