/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.util.fst;

import guideme.internal.shaded.lucene.util.ArrayUtil;
import guideme.internal.shaded.lucene.util.RamUsageEstimator;
import guideme.internal.shaded.lucene.util.fst.FST;
import java.io.IOException;

abstract class FSTEnum<T> {
    protected final FST<T> fst;
    protected FST.Arc<T>[] arcs = new FST.Arc[10];
    protected T[] output = new Object[10];
    protected final T NO_OUTPUT;
    protected final FST.BytesReader fstReader;
    protected int upto;

    FSTEnum(FST<T> fst) {
        this.fst = fst;
        this.fstReader = fst.getBytesReader();
        this.NO_OUTPUT = fst.outputs.getNoOutput();
        fst.getFirstArc(this.getArc(0));
        this.output[0] = this.NO_OUTPUT;
    }

    protected abstract void setCurrentLabel(int var1);

    protected abstract void grow();

    protected void doNext() throws IOException {
        if (this.upto == 0) {
            this.upto = 1;
            this.fst.readFirstTargetArc(this.getArc(0), this.getArc(1), this.fstReader);
        } else {
            while (this.arcs[this.upto].isLast()) {
                --this.upto;
                if (this.upto != 0) continue;
                return;
            }
            this.fst.readNextArc(this.arcs[this.upto], this.fstReader);
        }
        this.pushFirst();
    }

    private void incr() {
        ++this.upto;
        this.grow();
        if (this.arcs.length <= this.upto) {
            FST.Arc[] newArcs = new FST.Arc[ArrayUtil.oversize(1 + this.upto, RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
            System.arraycopy(this.arcs, 0, newArcs, 0, this.arcs.length);
            this.arcs = newArcs;
        }
        if (this.output.length <= this.upto) {
            Object[] newOutput = new Object[ArrayUtil.oversize(1 + this.upto, RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
            System.arraycopy(this.output, 0, newOutput, 0, this.output.length);
            this.output = newOutput;
        }
    }

    private void pushFirst() throws IOException {
        FST.Arc<T> arc = this.arcs[this.upto];
        assert (arc != null);
        while (true) {
            this.output[this.upto] = this.fst.outputs.add(this.output[this.upto - 1], arc.output());
            if (arc.label() == -1) break;
            this.setCurrentLabel(arc.label());
            this.incr();
            FST.Arc<T> nextArc = this.getArc(this.upto);
            this.fst.readFirstTargetArc(arc, nextArc, this.fstReader);
            arc = nextArc;
        }
    }

    private FST.Arc<T> getArc(int idx) {
        if (this.arcs[idx] == null) {
            this.arcs[idx] = new FST.Arc();
        }
        return this.arcs[idx];
    }
}

