/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.store;

import guideme.internal.shaded.lucene.store.AlreadyClosedException;
import guideme.internal.shaded.lucene.store.BufferedChecksumIndexInput;
import guideme.internal.shaded.lucene.store.ChecksumIndexInput;
import guideme.internal.shaded.lucene.store.IOContext;
import guideme.internal.shaded.lucene.store.IndexInput;
import guideme.internal.shaded.lucene.store.IndexOutput;
import guideme.internal.shaded.lucene.store.Lock;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;

public abstract class Directory
implements Closeable {
    public abstract String[] listAll() throws IOException;

    public abstract void deleteFile(String var1) throws IOException;

    public abstract long fileLength(String var1) throws IOException;

    public abstract IndexOutput createOutput(String var1, IOContext var2) throws IOException;

    public abstract IndexOutput createTempOutput(String var1, String var2, IOContext var3) throws IOException;

    public abstract void sync(Collection<String> var1) throws IOException;

    public abstract void syncMetaData() throws IOException;

    public abstract void rename(String var1, String var2) throws IOException;

    public abstract IndexInput openInput(String var1, IOContext var2) throws IOException;

    public ChecksumIndexInput openChecksumInput(String name) throws IOException {
        return new BufferedChecksumIndexInput(this.openInput(name, IOContext.READONCE));
    }

    public abstract Lock obtainLock(String var1) throws IOException;

    @Override
    public abstract void close() throws IOException;

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode());
    }

    protected void ensureOpen() throws AlreadyClosedException {
    }

    public abstract Set<String> getPendingDeletions() throws IOException;
}

