/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.index;

import guideme.internal.shaded.lucene.codecs.Codec;
import guideme.internal.shaded.lucene.index.IndexFileNames;
import guideme.internal.shaded.lucene.search.Sort;
import guideme.internal.shaded.lucene.store.Directory;
import guideme.internal.shaded.lucene.store.TrackingDirectoryWrapper;
import guideme.internal.shaded.lucene.util.Version;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;

public final class SegmentInfo {
    public final String name;
    private int maxDoc;
    public final Directory dir;
    private boolean isCompoundFile;
    private final byte[] id;
    private Codec codec;
    private Map<String, String> diagnostics;
    private Map<String, String> attributes;
    private final Sort indexSort;
    private final Version version;
    Version minVersion;
    private boolean hasBlocks;
    private Set<String> setFiles;

    void setDiagnostics(Map<String, String> diagnostics) {
        this.diagnostics = Map.copyOf(Objects.requireNonNull(diagnostics));
    }

    public Map<String, String> getDiagnostics() {
        return this.diagnostics;
    }

    public SegmentInfo(Directory dir, Version version, Version minVersion, String name, int maxDoc, boolean isCompoundFile, boolean hasBlocks, Codec codec, Map<String, String> diagnostics, byte[] id, Map<String, String> attributes, Sort indexSort) {
        assert (!(dir instanceof TrackingDirectoryWrapper));
        this.dir = Objects.requireNonNull(dir);
        this.version = Objects.requireNonNull(version);
        this.minVersion = minVersion;
        this.name = Objects.requireNonNull(name);
        this.maxDoc = maxDoc;
        this.isCompoundFile = isCompoundFile;
        this.hasBlocks = hasBlocks;
        this.codec = codec;
        this.diagnostics = Map.copyOf(Objects.requireNonNull(diagnostics));
        this.id = id;
        if (id.length != 16) {
            throw new IllegalArgumentException("invalid id: " + Arrays.toString(id));
        }
        this.attributes = Map.copyOf(Objects.requireNonNull(attributes));
        this.indexSort = indexSort;
    }

    void setUseCompoundFile(boolean isCompoundFile) {
        this.isCompoundFile = isCompoundFile;
    }

    public boolean getUseCompoundFile() {
        return this.isCompoundFile;
    }

    public boolean getHasBlocks() {
        return this.hasBlocks;
    }

    void setHasBlocks() {
        this.hasBlocks = true;
    }

    public void setCodec(Codec codec) {
        assert (this.codec == null);
        if (codec == null) {
            throw new IllegalArgumentException("codec must be non-null");
        }
        this.codec = codec;
    }

    public Codec getCodec() {
        return this.codec;
    }

    public int maxDoc() {
        if (this.maxDoc == -1) {
            throw new IllegalStateException("maxDoc isn't set yet");
        }
        return this.maxDoc;
    }

    void setMaxDoc(int maxDoc) {
        if (this.maxDoc != -1) {
            throw new IllegalStateException("maxDoc was already set: this.maxDoc=" + this.maxDoc + " vs maxDoc=" + maxDoc);
        }
        this.maxDoc = maxDoc;
    }

    public Set<String> files() {
        if (this.setFiles == null) {
            throw new IllegalStateException("files were not computed yet; segment=" + this.name + " maxDoc=" + this.maxDoc);
        }
        return Collections.unmodifiableSet(this.setFiles);
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int delCount) {
        Map<String, String> attributes;
        StringBuilder s = new StringBuilder();
        s.append(this.name).append('(').append(this.version == null ? "?" : this.version).append(')').append(':');
        char cfs = this.getUseCompoundFile() ? (char)'c' : 'C';
        s.append(cfs);
        s.append(this.maxDoc);
        if (delCount != 0) {
            s.append('/').append(delCount);
        }
        if (this.indexSort != null) {
            s.append(":[indexSort=");
            s.append(this.indexSort);
            s.append(']');
        }
        if (!this.diagnostics.isEmpty()) {
            s.append(":[diagnostics=");
            s.append(this.diagnostics.toString());
            s.append(']');
        }
        if (!(attributes = this.getAttributes()).isEmpty()) {
            s.append(":[attributes=");
            s.append(attributes.toString());
            s.append(']');
        }
        return s.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SegmentInfo) {
            SegmentInfo other = (SegmentInfo)obj;
            return other.dir == this.dir && other.name.equals(this.name);
        }
        return false;
    }

    public int hashCode() {
        return this.dir.hashCode() + this.name.hashCode();
    }

    public Version getVersion() {
        return this.version;
    }

    public Version getMinVersion() {
        return this.minVersion;
    }

    public byte[] getId() {
        return (byte[])this.id.clone();
    }

    public void setFiles(Collection<String> files) {
        this.setFiles = new HashSet<String>();
        this.addFiles(files);
    }

    public void addFiles(Collection<String> files) {
        this.checkFileNames(files);
        for (String f : files) {
            this.setFiles.add(this.namedForThisSegment(f));
        }
    }

    public void addFile(String file) {
        this.checkFileNames(Collections.singleton(file));
        this.setFiles.add(this.namedForThisSegment(file));
    }

    private void checkFileNames(Collection<String> files) {
        Matcher m = IndexFileNames.CODEC_FILE_PATTERN.matcher("");
        for (String file : files) {
            m.reset(file);
            if (!m.matches()) {
                throw new IllegalArgumentException("invalid codec filename '" + file + "', must match: " + IndexFileNames.CODEC_FILE_PATTERN.pattern());
            }
            if (!file.toLowerCase(Locale.ROOT).endsWith(".tmp")) continue;
            throw new IllegalArgumentException("invalid codec filename '" + file + "', cannot end with .tmp extension");
        }
    }

    String namedForThisSegment(String file) {
        return this.name + IndexFileNames.stripSegmentName(file);
    }

    public synchronized String getAttribute(String key) {
        return this.attributes.get(key);
    }

    public synchronized String putAttribute(String key, String value) {
        HashMap<String, String> newMap = new HashMap<String, String>(this.attributes);
        String oldValue = newMap.put(key, value);
        this.attributes = Collections.unmodifiableMap(newMap);
        return oldValue;
    }

    public synchronized Map<String, String> getAttributes() {
        return this.attributes;
    }

    public Sort getIndexSort() {
        return this.indexSort;
    }
}

