/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.index;

import guideme.internal.shaded.lucene.index.KnnVectorValues;
import guideme.internal.shaded.lucene.index.VectorEncoding;
import java.io.IOException;
import java.util.List;

public abstract class FloatVectorValues
extends KnnVectorValues {
    protected FloatVectorValues() {
    }

    public abstract float[] vectorValue(int var1) throws IOException;

    public abstract FloatVectorValues copy() throws IOException;

    @Override
    public VectorEncoding getEncoding() {
        return VectorEncoding.FLOAT32;
    }

    public static FloatVectorValues fromFloats(final List<float[]> vectors, final int dim) {
        return new FloatVectorValues(){

            @Override
            public int size() {
                return vectors.size();
            }

            @Override
            public int dimension() {
                return dim;
            }

            @Override
            public float[] vectorValue(int targetOrd) {
                return (float[])vectors.get(targetOrd);
            }

            @Override
            public FloatVectorValues copy() {
                return this;
            }

            @Override
            public KnnVectorValues.DocIndexIterator iterator() {
                return this.createDenseIterator();
            }
        };
    }
}

