/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.screen;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import guideme.color.ColorValue;
import guideme.color.ConstantColor;
import guideme.document.DefaultStyles;
import guideme.document.LytPoint;
import guideme.document.LytRect;
import guideme.document.block.LytBlock;
import guideme.document.block.LytDocument;
import guideme.document.block.LytNode;
import guideme.document.flow.LytFlowContainer;
import guideme.document.flow.LytFlowContent;
import guideme.document.interaction.GuideTooltip;
import guideme.document.interaction.InteractiveElement;
import guideme.internal.GuideMEClient;
import guideme.internal.screen.GuideScrollbar;
import guideme.internal.screen.IndepentScaleScreen;
import guideme.internal.util.DashPattern;
import guideme.internal.util.DashedRectangle;
import guideme.layout.LayoutContext;
import guideme.layout.MinecraftFontMetrics;
import guideme.render.RenderContext;
import guideme.style.ResolvedTextStyle;
import guideme.style.TextStyle;
import guideme.ui.GuideUiHost;
import guideme.ui.UiPoint;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL20;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DocumentScreen
extends IndepentScaleScreen
implements GuideUiHost {
    private static final Logger LOG = LoggerFactory.getLogger(DocumentScreen.class);
    private static final DashPattern DEBUG_NODE_OUTLINE = new DashPattern(1.0f, 4.0f, 3.0f, -1, 500.0f);
    private static final DashPattern DEBUG_CONTENT_OUTLINE = new DashPattern(0.5f, 2.0f, 1.0f, Integer.MAX_VALUE, 500.0f);
    private static final ColorValue DEBUG_HOVER_OUTLINE_COLOR = new ConstantColor(0x7FFFFF00);
    @Nullable
    private InteractiveElement mouseCaptureTarget;
    private LytDocument lastDocument;
    private boolean documentLayoutInvalid = true;
    private final GuideScrollbar scrollbar;
    protected LytRect screenRect = LytRect.empty();
    private LytRect documentRect = LytRect.empty();

    public DocumentScreen(Component title) {
        super(title);
        this.scrollbar = new GuideScrollbar();
    }

    @Override
    protected void init() {
        super.init();
        if (GuideMEClient.instance().isFullWidthLayout() || this.width < this.getMaxWidth()) {
            this.screenRect = new LytRect(0, 0, this.width, this.height);
        } else {
            int maxWidth = this.getMaxWidth();
            int screenWidth = Math.min(maxWidth, this.width);
            int left = (this.width - screenWidth) / 2;
            this.screenRect = new LytRect(left, 0, screenWidth, this.height);
        }
        this.addRenderableWidget((GuiEventListener)this.scrollbar);
        this.updateDocumentLayout();
    }

    protected int getMaxWidth() {
        return 570;
    }

    @Override
    protected float calculateEffectiveScale() {
        double currentScale;
        if (!GuideMEClient.instance().isAdaptiveScalingEnabled()) {
            return 1.0f;
        }
        Window window = Minecraft.getInstance().getWindow();
        double effectiveScale = currentScale = window.getGuiScale();
        if (currentScale == 1.0) {
            effectiveScale = 2.0;
        } else if (currentScale == 3.0) {
            effectiveScale = 4.0;
        }
        double virtualWidth = (double)window.getWidth() / effectiveScale;
        double virtualHeight = (double)window.getHeight() / effectiveScale;
        if (virtualWidth < 320.0 || virtualHeight < 240.0) {
            double reducedEffectiveScale = Math.max(2.0, currentScale - 1.0);
            LOG.debug("Not enough screen space ({}x{}) to increase GUI scale from {} to {}. Decreasing to {} instead.", new Object[]{virtualWidth, virtualHeight, currentScale, effectiveScale, reducedEffectiveScale});
            effectiveScale = reducedEffectiveScale;
        }
        return (float)(effectiveScale / currentScale);
    }

    protected final void ensureDocumentLayout() {
        if (!this.documentLayoutInvalid) {
            return;
        }
        this.documentLayoutInvalid = false;
        LytRect docViewport = this.getDocumentViewport();
        LayoutContext context = new LayoutContext(new MinecraftFontMetrics());
        LytDocument document = this.getDocument();
        if (document != null) {
            document.updateLayout(context, docViewport.width());
            this.scrollbar.setContentHeight(document.getContentHeight());
        }
    }

    protected final void updateDocumentLayout() {
        this.documentLayoutInvalid = true;
    }

    @Nullable
    protected abstract LytDocument getDocument();

    @Override
    public LytRect getDocumentRect() {
        return this.documentRect;
    }

    public void setDocumentRect(LytRect documentRect) {
        this.documentRect = documentRect.withWidth(documentRect.width() - this.scrollbar.getWidth());
        this.scrollbar.move(this.documentRect.right(), this.documentRect.y(), this.documentRect.height());
    }

    @Override
    public final LytRect getDocumentViewport() {
        LytRect documentRect = this.getDocumentRect();
        return new LytRect(0, this.scrollbar.getScrollAmount(), documentRect.width(), documentRect.height());
    }

    public void tick() {
        super.tick();
        LytDocument document = this.getDocumentWithLayout();
        if (document != null) {
            DocumentScreen.tickNode(document);
        }
    }

    private static void tickNode(LytNode node) {
        node.tick();
        for (LytNode lytNode : node.getChildren()) {
            DocumentScreen.tickNode(lytNode);
        }
    }

    protected final void setDocumentScrollY(int scrollY) {
        this.scrollbar.setScrollAmount(scrollY);
    }

    protected final void renderDocument(RenderContext context) {
        LytRect documentRect = this.getDocumentRect();
        LytDocument document = this.getDocumentWithLayout();
        if (document == null) {
            return;
        }
        LytRect documentViewport = this.getDocumentViewport();
        PoseStack poseStack = context.poseStack();
        context.pushScissor(documentRect);
        poseStack.pushPose();
        poseStack.translate((float)(documentRect.x() - documentViewport.x()), (float)(documentRect.y() - documentViewport.y()), 0.0f);
        MultiBufferSource.BufferSource buffers = context.beginBatch();
        document.renderBatch(context, (MultiBufferSource)buffers);
        context.endBatch(buffers);
        document.render(context);
        RenderSystem.clear((int)256, (boolean)Minecraft.ON_OSX);
        context.popScissor();
        if (GuideMEClient.instance().isShowDebugGuiOverlays()) {
            DocumentScreen.renderHoverOutline(document, context);
        }
        poseStack.popPose();
    }

    private static void renderHoverOutline(LytDocument document, RenderContext context) {
        Object bounds;
        LytDocument.HitTestResult hoveredElement = document.getHoveredElement();
        if (hoveredElement == null) {
            return;
        }
        context.poseStack().pushPose();
        context.poseStack().translate(0.0f, 0.0f, 1000.0f);
        GL20.glLogicOp((int)5382);
        GL20.glEnable((int)3058);
        LytNode lytNode = hoveredElement.node();
        if (lytNode instanceof LytBlock) {
            LytBlock block = (LytBlock)lytNode;
            bounds = block.getBounds();
            if (block.getMarginTop() > 0) {
                context.fillRect(((LytRect)bounds).withHeight(block.getMarginTop()).move(0, -block.getMarginTop()), DEBUG_HOVER_OUTLINE_COLOR);
            }
            if (block.getMarginBottom() > 0) {
                context.fillRect(((LytRect)bounds).withHeight(block.getMarginBottom()).move(0, ((LytRect)bounds).height()), DEBUG_HOVER_OUTLINE_COLOR);
            }
            if (block.getMarginLeft() > 0) {
                context.fillRect(((LytRect)bounds).withWidth(block.getMarginLeft()).move(-block.getMarginLeft(), 0), DEBUG_HOVER_OUTLINE_COLOR);
            }
            if (block.getMarginRight() > 0) {
                context.fillRect(((LytRect)bounds).withWidth(block.getMarginRight()).move(((LytRect)bounds).width(), 0), DEBUG_HOVER_OUTLINE_COLOR);
            }
        }
        DashedRectangle.render(context.poseStack(), hoveredElement.node().getBounds(), DEBUG_NODE_OUTLINE, 0.0f);
        if (hoveredElement.content() != null && (bounds = hoveredElement.node()) instanceof LytFlowContainer) {
            LytFlowContainer flowContainer = (LytFlowContainer)bounds;
            flowContainer.enumerateContentBounds(hoveredElement.content()).forEach(bound -> DashedRectangle.render(context.poseStack(), bound, DEBUG_CONTENT_OUTLINE, 0.0f));
        }
        GL20.glLogicOp((int)5379);
        GL20.glDisable((int)3058);
        LytRect bounds2 = hoveredElement.node().getBounds();
        ResolvedTextStyle debugFontStyle = TextStyle.builder().color(ConstantColor.WHITE).build().mergeWith(DefaultStyles.BASE_STYLE);
        context.fillRect(bounds2.x(), bounds2.bottom(), (int)context.getWidth(hoveredElement.node().getClass().getName(), debugFontStyle), 10, (ColorValue)ConstantColor.BLACK);
        context.renderText(hoveredElement.node().getClass().getName(), debugFontStyle, bounds2.x(), bounds2.bottom());
        context.poseStack().popPose();
    }

    @Override
    public void scaledMouseMoved(double mouseX, double mouseY) {
        UiPoint docPoint;
        super.scaledMouseMoved(mouseX, mouseY);
        if (this.mouseCaptureTarget != null) {
            UiPoint docPointUnclamped = this.getDocumentPointUnclamped(mouseX, mouseY);
            this.mouseCaptureTarget.mouseMoved(this, docPointUnclamped.x(), docPointUnclamped.y());
        }
        if ((docPoint = this.getDocumentPoint(mouseX, mouseY)) != null) {
            this.dispatchEvent(docPoint.x(), docPoint.y(), el -> el.mouseMoved(this, docPoint.x(), docPoint.y()));
        }
    }

    @Override
    public boolean scaledMouseClicked(double mouseX, double mouseY, int button) {
        if (super.scaledMouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        UiPoint docPoint = this.getDocumentPoint(mouseX, mouseY);
        if (docPoint != null) {
            if (this.documentClicked(docPoint, button)) {
                return true;
            }
            return this.dispatchEvent(docPoint.x(), docPoint.y(), el -> el.mouseClicked(this, docPoint.x(), docPoint.y(), button));
        }
        return false;
    }

    protected boolean documentClicked(UiPoint documentPoint, int button) {
        return false;
    }

    @Override
    public boolean scaledMouseReleased(double mouseX, double mouseY, int button) {
        if (this.mouseCaptureTarget != null) {
            InteractiveElement currentTarget = this.mouseCaptureTarget;
            UiPoint docPointUnclamped = this.getDocumentPointUnclamped(mouseX, mouseY);
            boolean handled = currentTarget.mouseReleased(this, docPointUnclamped.x(), docPointUnclamped.y(), button);
            this.releaseMouseCapture(currentTarget);
            if (handled) {
                return true;
            }
        }
        if (super.scaledMouseReleased(mouseX, mouseY, button)) {
            return true;
        }
        UiPoint docPoint = this.getDocumentPoint(mouseX, mouseY);
        if (docPoint != null) {
            return this.dispatchEvent(docPoint.x(), docPoint.y(), el -> el.mouseReleased(this, docPoint.x(), docPoint.y(), button));
        }
        return false;
    }

    private boolean dispatchEvent(int x, int y, EventInvoker invoker) {
        return this.dispatchInteraction(x, y, el -> {
            if (invoker.invoke((InteractiveElement)el)) {
                return Optional.of(true);
            }
            return Optional.empty();
        }).orElse(false);
    }

    private <T> Optional<T> dispatchInteraction(int x, int y, Function<InteractiveElement, Optional<T>> invoker) {
        LytDocument.HitTestResult underCursor;
        LytDocument document = this.getDocumentWithLayout();
        if (document != null && (underCursor = document.pick(x, y)) != null) {
            return DocumentScreen.dispatchInteraction(underCursor, invoker);
        }
        return Optional.empty();
    }

    private LytDocument getDocumentWithLayout() {
        LytDocument document = this.getDocument();
        if (this.lastDocument != document) {
            this.releaseMouseCapture();
            this.updateDocumentLayout();
            this.lastDocument = document;
        }
        if (document != null) {
            this.ensureDocumentLayout();
        }
        return document;
    }

    private static <T> Optional<T> dispatchInteraction(LytDocument.HitTestResult receiver, Function<InteractiveElement, Optional<T>> invoker) {
        InteractiveElement interactiveEl;
        Optional<T> result;
        for (LytFlowContent el = receiver.content(); el != null; el = el.getFlowParent()) {
            if (!(el instanceof InteractiveElement) || !(result = invoker.apply(interactiveEl = (InteractiveElement)((Object)el))).isPresent()) continue;
            return result;
        }
        for (LytNode node = receiver.node(); node != null; node = node.getParent()) {
            if (!(node instanceof InteractiveElement) || !(result = invoker.apply(interactiveEl = (InteractiveElement)((Object)node))).isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }

    public void afterMouseMove() {
        super.afterMouseMove();
        LytDocument document = this.getDocumentWithLayout();
        if (document != null) {
            double y;
            MouseHandler mouseHandler = this.minecraft.mouseHandler;
            double xScale = (double)this.minecraft.screen.width / (double)this.minecraft.getWindow().getScreenWidth();
            double yScale = (double)this.minecraft.screen.height / (double)this.minecraft.getWindow().getScreenHeight();
            double x = mouseHandler.xpos() * xScale;
            if (this.getScaledChildAt(x, y = mouseHandler.ypos() * yScale).isPresent()) {
                document.setHoveredElement(null);
                return;
            }
            UiPoint docPoint = this.getDocumentPoint(x, y);
            if (docPoint != null) {
                LytDocument.HitTestResult hoveredEl = document.pick(docPoint.x(), docPoint.y());
                document.setHoveredElement(hoveredEl);
            } else {
                document.setHoveredElement(null);
            }
        }
    }

    @Override
    @Nullable
    public UiPoint getDocumentPoint(double screenX, double screenY) {
        LytRect documentRect = this.getDocumentRect();
        if (screenX >= (double)documentRect.x() && screenX < (double)documentRect.right() && screenY >= (double)documentRect.y() && screenY < (double)documentRect.bottom()) {
            return this.getDocumentPointUnclamped(screenX, screenY);
        }
        return null;
    }

    @Override
    public UiPoint getDocumentPointUnclamped(double screenX, double screenY) {
        LytRect documentRect = this.getDocumentRect();
        int docX = (int)Math.round(screenX - (double)documentRect.x());
        int docY = (int)Math.round(screenY + (double)this.scrollbar.getScrollAmount() - (double)documentRect.y());
        return new UiPoint(docX, docY);
    }

    @Override
    public LytPoint getScreenPoint(LytPoint documentPoint) {
        LytRect documentRect = this.getDocumentRect();
        LytRect documentViewport = this.getDocumentViewport();
        float x = documentPoint.x() - (float)documentViewport.x();
        float y = documentPoint.y() - (float)documentViewport.y();
        return new LytPoint((float)documentRect.x() + x, (float)documentRect.y() + y);
    }

    @Override
    public boolean scaledMouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (!super.scaledMouseScrolled(mouseX, mouseY, deltaX, deltaY)) {
            return this.scrollbar.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
        }
        return true;
    }

    protected final void renderDocumentTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        LytDocument document = this.getDocumentWithLayout();
        if (document != null && document.getHoveredElement() != null) {
            this.renderTooltip(guiGraphics, mouseX, mouseY);
        }
    }

    private void renderTooltip(GuiGraphics guiGraphics, int x, int y) {
        UiPoint docPos = this.getDocumentPoint(x, y);
        if (docPos == null) {
            return;
        }
        LytDocument document = this.getDocumentWithLayout();
        if (document == null) {
            return;
        }
        LytDocument.HitTestResult hoveredElement = document.getHoveredElement();
        if (hoveredElement != null) {
            DocumentScreen.dispatchInteraction(hoveredElement, el -> el.getTooltip(docPos.x(), docPos.y())).ifPresent(tooltip -> this.renderTooltip(guiGraphics, (GuideTooltip)tooltip, x, y));
        }
    }

    private void renderTooltip(GuiGraphics guiGraphics, GuideTooltip tooltip, int mouseX, int mouseY) {
        ClientTooltipComponent line;
        int i;
        Minecraft minecraft = Minecraft.getInstance();
        List<ClientTooltipComponent> clientLines = tooltip.getLines();
        if (clientLines.isEmpty()) {
            return;
        }
        int frameWidth = 0;
        int frameHeight = clientLines.size() == 1 ? -2 : 0;
        for (ClientTooltipComponent clientTooltipComponent : clientLines) {
            frameWidth = Math.max(frameWidth, clientTooltipComponent.getWidth(minecraft.font));
            frameHeight += clientTooltipComponent.getHeight();
        }
        if (!tooltip.getIcon().isEmpty()) {
            frameWidth += 18;
            frameHeight = Math.max(frameHeight, 18);
        }
        int x = mouseX + 12;
        int y = mouseY - 12;
        if (x + frameWidth > this.width) {
            x -= 28 + frameWidth;
        }
        if (y + frameHeight + 6 > this.height) {
            y = this.height - frameHeight - 6;
        }
        int zOffset = 400;
        TooltipRenderUtil.renderTooltipBackground((GuiGraphics)guiGraphics, (int)x, (int)y, (int)frameWidth, (int)frameHeight, (int)zOffset);
        if (!tooltip.getIcon().isEmpty()) {
            x += 18;
        }
        PoseStack poseStack = guiGraphics.pose();
        MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
        poseStack.pushPose();
        poseStack.translate(0.0, 0.0, (double)zOffset);
        int currentY = y;
        for (i = 0; i < clientLines.size(); ++i) {
            line = clientLines.get(i);
            line.renderText(minecraft.font, x, currentY, poseStack.last().pose(), bufferSource);
            currentY += line.getHeight() + (i == 0 ? 2 : 0);
        }
        bufferSource.endBatch();
        currentY = y;
        if (!tooltip.getIcon().isEmpty()) {
            poseStack.pushPose();
            poseStack.translate(0.0f, 0.0f, (float)zOffset);
            guiGraphics.renderItem(tooltip.getIcon(), x - 18, y);
            poseStack.popPose();
        }
        for (i = 0; i < clientLines.size(); ++i) {
            line = clientLines.get(i);
            line.renderImage(minecraft.font, x, currentY, guiGraphics);
            currentY += line.getHeight() + (i == 0 ? 2 : 0);
        }
        poseStack.popPose();
    }

    @Override
    @Nullable
    public InteractiveElement getMouseCaptureTarget() {
        return this.mouseCaptureTarget;
    }

    @Override
    public void captureMouse(InteractiveElement element) {
        if (this.mouseCaptureTarget != element) {
            if (this.mouseCaptureTarget != null) {
                this.releaseMouseCapture(this.mouseCaptureTarget);
            }
            this.mouseCaptureTarget = element;
        }
    }

    @Override
    public void releaseMouseCapture(InteractiveElement element) {
        if (this.mouseCaptureTarget == element) {
            this.mouseCaptureTarget = null;
            element.mouseCaptureLost();
            if (this.mouseCaptureTarget != null) {
                throw new IllegalStateException("Element " + String.valueOf(element) + " recaptured the mouse in its release event");
            }
        }
    }

    private void releaseMouseCapture() {
        if (this.mouseCaptureTarget != null) {
            this.releaseMouseCapture(this.mouseCaptureTarget);
        }
    }

    public void onClose() {
        super.onClose();
        this.releaseMouseCapture();
    }

    protected int getMarginBottom() {
        return this.hasFooter() ? 20 : 0;
    }

    protected boolean hasFooter() {
        return false;
    }

    @FunctionalInterface
    static interface EventInvoker {
        public boolean invoke(InteractiveElement var1);
    }
}

