/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search;

import guideme.internal.shaded.lucene.index.BaseTermsEnum;
import guideme.internal.shaded.lucene.index.ImpactsEnum;
import guideme.internal.shaded.lucene.index.PostingsEnum;
import guideme.internal.shaded.lucene.index.Term;
import guideme.internal.shaded.lucene.index.TermState;
import guideme.internal.shaded.lucene.index.Terms;
import guideme.internal.shaded.lucene.index.TermsEnum;
import guideme.internal.shaded.lucene.search.BoostAttribute;
import guideme.internal.shaded.lucene.search.FuzzyAutomatonBuilder;
import guideme.internal.shaded.lucene.search.FuzzyTermsEnum$AutomatonAttribute;
import guideme.internal.shaded.lucene.search.MaxNonCompetitiveBoostAttribute;
import guideme.internal.shaded.lucene.util.AttributeImpl;
import guideme.internal.shaded.lucene.util.AttributeReflector;
import guideme.internal.shaded.lucene.util.AttributeSource;
import guideme.internal.shaded.lucene.util.BytesRef;
import guideme.internal.shaded.lucene.util.BytesRefBuilder;
import guideme.internal.shaded.lucene.util.IOBooleanSupplier;
import guideme.internal.shaded.lucene.util.UnicodeUtil;
import guideme.internal.shaded.lucene.util.automaton.CompiledAutomaton;
import java.io.IOException;
import java.util.function.Supplier;

public final class FuzzyTermsEnum
extends BaseTermsEnum {
    private TermsEnum actualEnum;
    private final AttributeSource atts;
    private final BoostAttribute boostAtt;
    private final MaxNonCompetitiveBoostAttribute maxBoostAtt;
    private final CompiledAutomaton[] automata;
    private final Terms terms;
    private final int termLength;
    private final Term term;
    private float bottom;
    private BytesRef bottomTerm;
    private BytesRef queuedBottom;
    private int maxEdits;

    private TermsEnum getAutomatonEnum(int editDistance, BytesRef lastTerm) throws IOException {
        assert (editDistance < this.automata.length);
        CompiledAutomaton compiled = this.automata[editDistance];
        BytesRef initialSeekTerm = lastTerm == null ? null : compiled.floor(lastTerm, new BytesRefBuilder());
        return this.terms.intersect(compiled, initialSeekTerm);
    }

    private void bottomChanged(BytesRef lastTerm) throws IOException {
        float maxBoost;
        boolean termAfter;
        int oldMaxEdits = this.maxEdits;
        boolean bl = termAfter = this.bottomTerm == null || lastTerm != null && lastTerm.compareTo(this.bottomTerm) >= 0;
        while (this.maxEdits > 0 && !(this.bottom < (maxBoost = 1.0f - (float)this.maxEdits / (float)this.termLength)) && (this.bottom != maxBoost || termAfter)) {
            --this.maxEdits;
        }
        if (oldMaxEdits != this.maxEdits || lastTerm == null) {
            this.actualEnum = this.getAutomatonEnum(this.maxEdits, lastTerm);
        }
    }

    @Override
    public BytesRef next() throws IOException {
        int ed;
        BytesRef term;
        if (this.queuedBottom != null) {
            this.bottomChanged(this.queuedBottom);
            this.queuedBottom = null;
        }
        if ((term = this.actualEnum.next()) == null) {
            return null;
        }
        for (ed = this.maxEdits; ed > 0 && this.matches(term, ed - 1); --ed) {
        }
        if (ed == 0) {
            this.boostAtt.setBoost(1.0f);
        } else {
            int codePointCount = UnicodeUtil.codePointCount(term);
            int minTermLength = Math.min(codePointCount, this.termLength);
            float similarity = 1.0f - (float)ed / (float)minTermLength;
            this.boostAtt.setBoost(similarity);
        }
        float bottom = this.maxBoostAtt.getMaxNonCompetitiveBoost();
        BytesRef bottomTerm = this.maxBoostAtt.getCompetitiveTerm();
        if (bottom != this.bottom || bottomTerm != this.bottomTerm) {
            this.bottom = bottom;
            this.bottomTerm = bottomTerm;
            this.queuedBottom = BytesRef.deepCopyOf(term);
        }
        return term;
    }

    private boolean matches(BytesRef termIn, int k) {
        return k == 0 ? termIn.equals(this.term.bytes()) : this.automata[k].runAutomaton.run(termIn.bytes, termIn.offset, termIn.length);
    }

    @Override
    public int docFreq() throws IOException {
        return this.actualEnum.docFreq();
    }

    @Override
    public long totalTermFreq() throws IOException {
        return this.actualEnum.totalTermFreq();
    }

    @Override
    public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
        return this.actualEnum.postings(reuse, flags);
    }

    @Override
    public ImpactsEnum impacts(int flags) throws IOException {
        return this.actualEnum.impacts(flags);
    }

    @Override
    public void seekExact(BytesRef term, TermState state) throws IOException {
        this.actualEnum.seekExact(term, state);
    }

    @Override
    public TermState termState() throws IOException {
        return this.actualEnum.termState();
    }

    @Override
    public long ord() throws IOException {
        return this.actualEnum.ord();
    }

    @Override
    public AttributeSource attributes() {
        return this.atts;
    }

    @Override
    public boolean seekExact(BytesRef text) throws IOException {
        return this.actualEnum.seekExact(text);
    }

    @Override
    public IOBooleanSupplier prepareSeekExact(BytesRef text) throws IOException {
        return this.actualEnum.prepareSeekExact(text);
    }

    @Override
    public TermsEnum.SeekStatus seekCeil(BytesRef text) throws IOException {
        return this.actualEnum.seekCeil(text);
    }

    @Override
    public void seekExact(long ord) throws IOException {
        this.actualEnum.seekExact(ord);
    }

    @Override
    public BytesRef term() throws IOException {
        return this.actualEnum.term();
    }

    private static class AutomatonAttributeImpl
    extends AttributeImpl
    implements FuzzyTermsEnum$AutomatonAttribute {
        private CompiledAutomaton[] automata;
        private int termLength;

        private AutomatonAttributeImpl() {
        }

        public CompiledAutomaton[] getAutomata() {
            return this.automata;
        }

        public int getTermLength() {
            return this.termLength;
        }

        public void init(Supplier<FuzzyAutomatonBuilder> supplier) {
            if (this.automata != null) {
                return;
            }
            FuzzyAutomatonBuilder builder = supplier.get();
            this.termLength = builder.getTermLength();
            this.automata = builder.buildAutomatonSet();
        }

        @Override
        public void clear() {
            this.automata = null;
        }

        @Override
        public void reflectWith(AttributeReflector reflector) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void copyTo(AttributeImpl target) {
            throw new UnsupportedOperationException();
        }
    }

    public static class FuzzyTermsException
    extends RuntimeException {
        FuzzyTermsException(String term, Throwable cause) {
            super("Term too complex: " + term, cause);
        }
    }
}

