/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Objects;

public final class CollectionStatistics
extends Record {
    private final String field;
    private final long maxDoc;
    private final long docCount;
    private final long sumTotalTermFreq;
    private final long sumDocFreq;

    public CollectionStatistics(String field, long maxDoc, long docCount, long sumTotalTermFreq, long sumDocFreq) {
        Objects.requireNonNull(field);
        if (maxDoc <= 0L) {
            throw new IllegalArgumentException("maxDoc must be positive, maxDoc: " + maxDoc);
        }
        if (docCount <= 0L) {
            throw new IllegalArgumentException("docCount must be positive, docCount: " + docCount);
        }
        if (docCount > maxDoc) {
            throw new IllegalArgumentException("docCount must not exceed maxDoc, docCount: " + docCount + ", maxDoc: " + maxDoc);
        }
        if (sumDocFreq <= 0L) {
            throw new IllegalArgumentException("sumDocFreq must be positive, sumDocFreq: " + sumDocFreq);
        }
        if (sumDocFreq < docCount) {
            throw new IllegalArgumentException("sumDocFreq must be at least docCount, sumDocFreq: " + sumDocFreq + ", docCount: " + docCount);
        }
        if (sumTotalTermFreq <= 0L) {
            throw new IllegalArgumentException("sumTotalTermFreq must be positive, sumTotalTermFreq: " + sumTotalTermFreq);
        }
        if (sumTotalTermFreq < sumDocFreq) {
            throw new IllegalArgumentException("sumTotalTermFreq must be at least sumDocFreq, sumTotalTermFreq: " + sumTotalTermFreq + ", sumDocFreq: " + sumDocFreq);
        }
        this.field = field;
        this.maxDoc = maxDoc;
        this.docCount = docCount;
        this.sumTotalTermFreq = sumTotalTermFreq;
        this.sumDocFreq = sumDocFreq;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{CollectionStatistics.class, "field;maxDoc;docCount;sumTotalTermFreq;sumDocFreq", "field", "maxDoc", "docCount", "sumTotalTermFreq", "sumDocFreq"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{CollectionStatistics.class, "field;maxDoc;docCount;sumTotalTermFreq;sumDocFreq", "field", "maxDoc", "docCount", "sumTotalTermFreq", "sumDocFreq"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{CollectionStatistics.class, "field;maxDoc;docCount;sumTotalTermFreq;sumDocFreq", "field", "maxDoc", "docCount", "sumTotalTermFreq", "sumDocFreq"}, this, o);
    }

    public long docCount() {
        return this.docCount;
    }

    public long sumTotalTermFreq() {
        return this.sumTotalTermFreq;
    }
}

