/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.queries.spans;

import guideme.internal.shaded.lucene.index.LeafReaderContext;
import guideme.internal.shaded.lucene.index.Term;
import guideme.internal.shaded.lucene.index.TermStates;
import guideme.internal.shaded.lucene.queries.spans.FilterSpans;
import guideme.internal.shaded.lucene.queries.spans.SpanQuery;
import guideme.internal.shaded.lucene.queries.spans.SpanWeight;
import guideme.internal.shaded.lucene.queries.spans.Spans;
import guideme.internal.shaded.lucene.search.BooleanClause;
import guideme.internal.shaded.lucene.search.IndexSearcher;
import guideme.internal.shaded.lucene.search.Query;
import guideme.internal.shaded.lucene.search.QueryVisitor;
import guideme.internal.shaded.lucene.search.ScoreMode;
import java.io.IOException;
import java.util.Map;

public abstract class SpanPositionCheckQuery
extends SpanQuery
implements Cloneable {
    protected SpanQuery match;

    public SpanQuery getMatch() {
        return this.match;
    }

    @Override
    public String getField() {
        return this.match.getField();
    }

    protected abstract FilterSpans.AcceptStatus acceptPosition(Spans var1) throws IOException;

    @Override
    public SpanWeight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        SpanWeight matchWeight = this.match.createWeight(searcher, scoreMode, boost);
        return new SpanPositionCheckWeight(matchWeight, searcher, scoreMode.needsScores() ? SpanPositionCheckQuery.getTermStates(matchWeight) : null, boost);
    }

    @Override
    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        SpanQuery rewritten = (SpanQuery)this.match.rewrite(indexSearcher);
        if (rewritten != this.match) {
            try {
                SpanPositionCheckQuery clone = (SpanPositionCheckQuery)this.clone();
                clone.match = rewritten;
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError((Object)e);
            }
        }
        return super.rewrite(indexSearcher);
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.getField())) {
            this.match.visit(visitor.getSubVisitor(BooleanClause.Occur.MUST, this));
        }
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.match.equals(((SpanPositionCheckQuery)other).match);
    }

    @Override
    public int hashCode() {
        return this.classHash() ^ this.match.hashCode();
    }

    public class SpanPositionCheckWeight
    extends SpanWeight {
        final SpanWeight matchWeight;

        public SpanPositionCheckWeight(SpanWeight matchWeight, IndexSearcher searcher, Map<Term, TermStates> terms, float boost) throws IOException {
            super(SpanPositionCheckQuery.this, searcher, terms, boost);
            this.matchWeight = matchWeight;
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return this.matchWeight.isCacheable(ctx);
        }

        @Override
        public void extractTermStates(Map<Term, TermStates> contexts) {
            this.matchWeight.extractTermStates(contexts);
        }

        @Override
        public Spans getSpans(LeafReaderContext context, SpanWeight.Postings requiredPostings) throws IOException {
            Spans matchSpans = this.matchWeight.getSpans(context, requiredPostings);
            return matchSpans == null ? null : new FilterSpans(matchSpans){

                @Override
                protected FilterSpans.AcceptStatus accept(Spans candidate) throws IOException {
                    return SpanPositionCheckQuery.this.acceptPosition(candidate);
                }
            };
        }
    }
}

