/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.internal.hppc;

import guideme.internal.shaded.lucene.internal.hppc.AbstractIterator;
import guideme.internal.shaded.lucene.internal.hppc.BitMixer;
import guideme.internal.shaded.lucene.internal.hppc.BufferAllocationException;
import guideme.internal.shaded.lucene.internal.hppc.HashContainers;
import guideme.internal.shaded.lucene.internal.hppc.IntCursor;
import guideme.internal.shaded.lucene.util.Accountable;
import guideme.internal.shaded.lucene.util.RamUsageEstimator;
import java.util.Collection;
import java.util.Iterator;

public class IntHashSet
implements Accountable,
Cloneable,
Iterable<IntCursor> {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(IntHashSet.class);
    public int[] keys;
    protected int assigned;
    protected int mask;
    protected int resizeAt;
    protected boolean hasEmptyKey;
    protected double loadFactor;
    protected int iterationSeed;

    public IntHashSet() {
        this(4);
    }

    public IntHashSet(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public IntHashSet(int expectedElements, double loadFactor) {
        this.loadFactor = this.verifyLoadFactor(loadFactor);
        this.iterationSeed = HashContainers.ITERATION_SEED.incrementAndGet();
        this.ensureCapacity(expectedElements);
    }

    public IntHashSet(Collection<Integer> collection) {
        this(collection.size());
        this.addAll(collection);
    }

    public boolean add(int key) {
        int existing;
        if (key == 0) {
            assert (this.keys[this.mask + 1] == 0);
            boolean added = !this.hasEmptyKey;
            this.hasEmptyKey = true;
            return added;
        }
        int[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0) {
            if (key == existing) {
                return false;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(slot, key);
        } else {
            keys[slot] = key;
        }
        ++this.assigned;
        return true;
    }

    public int addAll(Collection<Integer> collection) {
        int count = 0;
        for (int element : collection) {
            if (!this.add(element)) continue;
            ++count;
        }
        return count;
    }

    public int[] toArray() {
        int[] cloned = new int[this.size()];
        int j = 0;
        if (this.hasEmptyKey) {
            cloned[j++] = 0;
        }
        int[] keys = this.keys;
        int seed = this.nextIterationSeed();
        int inc = HashContainers.iterationIncrement(seed);
        int mask = this.mask;
        int slot = seed & mask;
        for (int i = 0; i <= mask; ++i) {
            int existing = keys[slot];
            if (existing != 0) {
                cloned[j++] = existing;
            }
            slot = slot + inc & mask;
        }
        return cloned;
    }

    public boolean contains(int key) {
        int existing;
        if (key == 0) {
            return this.hasEmptyKey;
        }
        int[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0) {
            if (key == existing) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public void ensureCapacity(int expectedElements) {
        if (expectedElements > this.resizeAt || this.keys == null) {
            int[] prevKeys = this.keys;
            this.allocateBuffers(HashContainers.minBufferSize(expectedElements, this.loadFactor));
            if (prevKeys != null && !this.isEmpty()) {
                this.rehash(prevKeys);
            }
        }
    }

    public int size() {
        return this.assigned + (this.hasEmptyKey ? 1 : 0);
    }

    public int hashCode() {
        int h = this.hasEmptyKey ? -559038737 : 0;
        int[] keys = this.keys;
        for (int slot = this.mask; slot >= 0; --slot) {
            int existing = keys[slot];
            if (existing == 0) continue;
            h += BitMixer.mix(existing);
        }
        return h;
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && this.getClass() == obj.getClass() && this.sameKeys((IntHashSet)this.getClass().cast(obj));
    }

    private boolean sameKeys(IntHashSet other) {
        if (other.size() != this.size()) {
            return false;
        }
        for (IntCursor c : other) {
            if (this.contains(c.value)) continue;
            return false;
        }
        return true;
    }

    public IntHashSet clone() {
        try {
            IntHashSet cloned = (IntHashSet)super.clone();
            cloned.keys = (int[])this.keys.clone();
            cloned.hasEmptyKey = this.hasEmptyKey;
            cloned.iterationSeed = HashContainers.ITERATION_SEED.incrementAndGet();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Iterator<IntCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf(this.keys);
    }

    protected int nextIterationSeed() {
        this.iterationSeed = BitMixer.mixPhi(this.iterationSeed);
        return this.iterationSeed;
    }

    protected int hashKey(int key) {
        assert (key != 0);
        return BitMixer.mixPhi(key);
    }

    protected double verifyLoadFactor(double loadFactor) {
        HashContainers.checkLoadFactor(loadFactor, 0.01f, 0.99f);
        return loadFactor;
    }

    protected void rehash(int[] fromKeys) {
        assert (HashContainers.checkPowerOfTwo(fromKeys.length - 1));
        int[] keys = this.keys;
        int mask = this.mask;
        int i = fromKeys.length - 1;
        while (--i >= 0) {
            int existing = fromKeys[i];
            if (existing == 0) continue;
            int slot = this.hashKey(existing) & mask;
            while (keys[slot] != 0) {
                slot = slot + 1 & mask;
            }
            keys[slot] = existing;
        }
    }

    protected void allocateBuffers(int arraySize) {
        assert (Integer.bitCount(arraySize) == 1);
        int[] prevKeys = this.keys;
        try {
            int emptyElementSlot = 1;
            this.keys = new int[arraySize + emptyElementSlot];
        }
        catch (OutOfMemoryError e) {
            this.keys = prevKeys;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)e, this.keys == null ? 0 : this.size(), arraySize);
        }
        this.resizeAt = HashContainers.expandAtCount(arraySize, this.loadFactor);
        this.mask = arraySize - 1;
    }

    protected void allocateThenInsertThenRehash(int slot, int pendingKey) {
        assert (this.assigned == this.resizeAt && this.keys[slot] == 0 && pendingKey != 0);
        int[] prevKeys = this.keys;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        assert (this.keys.length > prevKeys.length);
        prevKeys[slot] = pendingKey;
        this.rehash(prevKeys);
    }

    protected final class EntryIterator
    extends AbstractIterator<IntCursor> {
        private final IntCursor cursor = new IntCursor();
        private final int increment;
        private int index;
        private int slot;

        public EntryIterator() {
            int seed = IntHashSet.this.nextIterationSeed();
            this.increment = HashContainers.iterationIncrement(seed);
            this.slot = seed & IntHashSet.this.mask;
        }

        @Override
        protected IntCursor fetch() {
            int mask = IntHashSet.this.mask;
            while (this.index <= mask) {
                ++this.index;
                this.slot = this.slot + this.increment & mask;
                int existing = IntHashSet.this.keys[this.slot];
                if (existing == 0) continue;
                this.cursor.index = this.slot;
                this.cursor.value = existing;
                return this.cursor;
            }
            if (this.index == mask + 1 && IntHashSet.this.hasEmptyKey) {
                this.cursor.index = this.index++;
                this.cursor.value = 0;
                return this.cursor;
            }
            return (IntCursor)this.done();
        }
    }
}

