/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.index;

import guideme.internal.shaded.lucene.util.ArrayUtil;

class ParallelPostingsArray {
    final int size;
    final int[] textStarts;
    final int[] addressOffset;
    final int[] byteStarts;

    ParallelPostingsArray(int size) {
        this.size = size;
        this.textStarts = new int[size];
        this.addressOffset = new int[size];
        this.byteStarts = new int[size];
    }

    int bytesPerPosting() {
        return 12;
    }

    ParallelPostingsArray newInstance(int size) {
        return new ParallelPostingsArray(size);
    }

    final ParallelPostingsArray grow() {
        int newSize = ArrayUtil.oversize(this.size + 1, this.bytesPerPosting());
        ParallelPostingsArray newArray = this.newInstance(newSize);
        this.copyTo(newArray, this.size);
        return newArray;
    }

    void copyTo(ParallelPostingsArray toArray, int numToCopy) {
        System.arraycopy(this.textStarts, 0, toArray.textStarts, 0, numToCopy);
        System.arraycopy(this.addressOffset, 0, toArray.addressOffset, 0, numToCopy);
        System.arraycopy(this.byteStarts, 0, toArray.byteStarts, 0, numToCopy);
    }
}

