/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.index;

import guideme.internal.shaded.lucene.index.VectorEncoding;
import guideme.internal.shaded.lucene.search.DocIdSetIterator;
import java.io.IOException;

public abstract class KnnVectorValues {
    public abstract int dimension();

    public abstract int size();

    public abstract VectorEncoding getEncoding();

    public DocIndexIterator iterator() {
        throw new UnsupportedOperationException();
    }

    protected DocIndexIterator createDenseIterator() {
        return new DocIndexIterator(){
            int doc = -1;

            @Override
            public int docID() {
                return this.doc;
            }

            @Override
            public int index() {
                return this.doc;
            }

            @Override
            public int nextDoc() throws IOException {
                if (this.doc >= KnnVectorValues.this.size() - 1) {
                    this.doc = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                return ++this.doc;
            }

            @Override
            public int advance(int target) {
                if (target >= KnnVectorValues.this.size()) {
                    this.doc = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                this.doc = target;
                return this.doc;
            }

            @Override
            public long cost() {
                return KnnVectorValues.this.size();
            }
        };
    }

    public static abstract class DocIndexIterator
    extends DocIdSetIterator {
        public abstract int index();
    }
}

