/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.index;

import guideme.internal.shaded.lucene.analysis.Analyzer;
import guideme.internal.shaded.lucene.analysis.standard.StandardAnalyzer;
import guideme.internal.shaded.lucene.codecs.Codec;
import guideme.internal.shaded.lucene.index.FlushPolicy;
import guideme.internal.shaded.lucene.index.IndexCommit;
import guideme.internal.shaded.lucene.index.IndexDeletionPolicy;
import guideme.internal.shaded.lucene.index.IndexWriter;
import guideme.internal.shaded.lucene.index.LiveIndexWriterConfig;
import guideme.internal.shaded.lucene.index.MergePolicy;
import guideme.internal.shaded.lucene.index.MergeScheduler;
import guideme.internal.shaded.lucene.search.similarities.Similarity;
import guideme.internal.shaded.lucene.util.InfoStream;
import guideme.internal.shaded.lucene.util.SetOnce;

public final class IndexWriterConfig
extends LiveIndexWriterConfig {
    private SetOnce<IndexWriter> writer = new SetOnce();

    IndexWriterConfig setIndexWriter(IndexWriter writer) {
        if (this.writer.get() != null) {
            throw new IllegalStateException("do not share IndexWriterConfig instances across IndexWriters");
        }
        this.writer.set(writer);
        return this;
    }

    public IndexWriterConfig() {
        this(new StandardAnalyzer());
    }

    public IndexWriterConfig(Analyzer analyzer) {
        super(analyzer);
    }

    @Override
    public OpenMode getOpenMode() {
        return this.openMode;
    }

    @Override
    public IndexDeletionPolicy getIndexDeletionPolicy() {
        return this.delPolicy;
    }

    @Override
    public IndexCommit getIndexCommit() {
        return this.commit;
    }

    @Override
    public Similarity getSimilarity() {
        return this.similarity;
    }

    @Override
    public MergeScheduler getMergeScheduler() {
        return this.mergeScheduler;
    }

    @Override
    public Codec getCodec() {
        return this.codec;
    }

    @Override
    public MergePolicy getMergePolicy() {
        return this.mergePolicy;
    }

    @Override
    public boolean getReaderPooling() {
        return this.readerPooling;
    }

    @Override
    public int getRAMPerThreadHardLimitMB() {
        return this.perThreadHardLimitMB;
    }

    @Override
    FlushPolicy getFlushPolicy() {
        return this.flushPolicy;
    }

    @Override
    public InfoStream getInfoStream() {
        return this.infoStream;
    }

    @Override
    public Analyzer getAnalyzer() {
        return super.getAnalyzer();
    }

    @Override
    public int getMaxBufferedDocs() {
        return super.getMaxBufferedDocs();
    }

    @Override
    public IndexWriter.IndexReaderWarmer getMergedSegmentWarmer() {
        return super.getMergedSegmentWarmer();
    }

    @Override
    public double getRAMBufferSizeMB() {
        return super.getRAMBufferSizeMB();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("writer=").append(this.writer.get()).append("\n");
        return sb.toString();
    }

    public static enum OpenMode {
        CREATE,
        APPEND,
        CREATE_OR_APPEND;

    }
}

