/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import guideme.internal.GuideRegistry;
import guideme.internal.GuidebookText;
import guideme.internal.MutableGuide;
import guideme.internal.command.GuideIdArgument;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.SingleThreadedRandomSource;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.util.tinyfd.TinyFileDialogs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StructureCommands {
    private static final Logger LOG = LoggerFactory.getLogger(StructureCommands.class);
    @Nullable
    private static String lastOpenedOrSavedPath;
    private static final String[] FILE_PATTERNS;

    private StructureCommands() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder rootCommand = Commands.literal((String)"guideme");
        StructureCommands.registerPlaceAllStructures((LiteralArgumentBuilder<CommandSourceStack>)rootCommand);
        StructureCommands.registerImportCommand((LiteralArgumentBuilder<CommandSourceStack>)rootCommand);
        StructureCommands.registerExportCommand((LiteralArgumentBuilder<CommandSourceStack>)rootCommand);
        dispatcher.register(rootCommand);
    }

    @Nullable
    private static ServerLevel getIntegratedServerLevel(CommandContext<CommandSourceStack> context) {
        Minecraft minecraft = Minecraft.getInstance();
        if (!minecraft.hasSingleplayerServer()) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)GuidebookText.CommandOnlyWorksInSinglePlayer.text());
            return null;
        }
        return minecraft.getSingleplayerServer().getLevel(Minecraft.getInstance().player.level().dimension());
    }

    private static void registerPlaceAllStructures(LiteralArgumentBuilder<CommandSourceStack> rootCommand) {
        LiteralArgumentBuilder subcommand = LiteralArgumentBuilder.literal((String)"placeallstructures");
        subcommand = (LiteralArgumentBuilder)subcommand.requires(c -> c.hasPermission(2));
        subcommand.then(Commands.argument((String)"origin", (ArgumentType)BlockPosArgument.blockPos()).executes(context -> {
            ServerLevel level = StructureCommands.getIntegratedServerLevel((CommandContext<CommandSourceStack>)context);
            if (level == null) {
                return 1;
            }
            BlockPos origin = BlockPosArgument.getBlockPos((CommandContext)context, (String)"origin");
            StructureCommands.placeAllStructures(level, origin);
            return 0;
        }));
        subcommand.then(Commands.argument((String)"origin", (ArgumentType)BlockPosArgument.blockPos()).then(Commands.argument((String)"guide", (ArgumentType)GuideIdArgument.argument()).executes(context -> {
            ServerLevel level = StructureCommands.getIntegratedServerLevel((CommandContext<CommandSourceStack>)context);
            if (level == null) {
                return 1;
            }
            ResourceLocation guideId = GuideIdArgument.getGuide(context, "guide");
            MutableGuide guide = GuideRegistry.getById(guideId);
            if (guide == null) {
                return 1;
            }
            BlockPos origin = BlockPosArgument.getBlockPos((CommandContext)context, (String)"origin");
            StructureCommands.placeAllStructures(level, (MutableObject<BlockPos>)new MutableObject((Object)origin), guide);
            return 0;
        })));
        rootCommand.then((ArgumentBuilder)subcommand);
    }

    private static void registerImportCommand(LiteralArgumentBuilder<CommandSourceStack> rootCommand) {
        LiteralArgumentBuilder importSubcommand = LiteralArgumentBuilder.literal((String)"importstructure");
        ((LiteralArgumentBuilder)importSubcommand.requires(c -> c.hasPermission(2))).then(Commands.argument((String)"origin", (ArgumentType)BlockPosArgument.blockPos()).executes(context -> {
            ServerLevel level = StructureCommands.getIntegratedServerLevel((CommandContext<CommandSourceStack>)context);
            if (level == null) {
                return 1;
            }
            BlockPos origin = BlockPosArgument.getBlockPos((CommandContext)context, (String)"origin");
            StructureCommands.importStructure(StructureCommands.getIntegratedServerLevel((CommandContext<CommandSourceStack>)context), origin);
            return 0;
        }));
        rootCommand.then((ArgumentBuilder)importSubcommand);
    }

    private static void placeAllStructures(ServerLevel level, BlockPos origin) {
        MutableObject currentPos = new MutableObject((Object)origin);
        for (MutableGuide guide : GuideRegistry.getAll()) {
            StructureCommands.placeAllStructures(level, (MutableObject<BlockPos>)currentPos, guide);
        }
    }

    private static void placeAllStructures(ServerLevel level, MutableObject<BlockPos> origin, MutableGuide guide) {
        Minecraft minecraft = Minecraft.getInstance();
        IntegratedServer server = minecraft.getSingleplayerServer();
        LocalPlayer player = minecraft.player;
        if (server == null || player == null) {
            return;
        }
        Path sourceFolder = guide.getDevelopmentSourceFolder();
        ArrayList<Pair> structures = new ArrayList<Pair>();
        if (sourceFolder == null) {
            ResourceManager resourceManager = Minecraft.getInstance().getResourceManager();
            Map resources = resourceManager.listResources(guide.getContentRootFolder(), location -> location.getPath().endsWith(".snbt"));
            for (Map.Entry entry : resources.entrySet()) {
                structures.add(Pair.of((Object)((ResourceLocation)entry.getKey()).toString(), () -> {
                    String string;
                    block8: {
                        InputStream in = ((Resource)entry.getValue()).open();
                        try {
                            string = new String(in.readAllBytes());
                            if (in == null) break block8;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (in != null) {
                                    try {
                                        in.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (IOException e) {
                                LOG.error("Failed to read structure {}", entry.getKey(), (Object)e);
                                return null;
                            }
                        }
                        in.close();
                    }
                    return string;
                }));
            }
        } else {
            try (Stream<Path> s = Files.walk(sourceFolder, new FileVisitOption[0]).filter(p -> Files.isRegularFile(p, new LinkOption[0]) && p.getFileName().toString().endsWith(".snbt"));){
                s.forEach(path -> structures.add(Pair.of((Object)path.toString(), () -> {
                    try {
                        return Files.readString(path);
                    }
                    catch (IOException e) {
                        LOG.error("Failed to read structure {}", path, (Object)e);
                        return null;
                    }
                })));
            }
            catch (IOException e) {
                LOG.error("Failed to find all structures.", (Throwable)e);
                player.sendSystemMessage((Component)Component.literal((String)e.toString()));
                return;
            }
        }
        for (Pair pair : structures) {
            String snbtFile = (String)pair.getLeft();
            Supplier contentSupplier = (Supplier)pair.getRight();
            LOG.info("Placing {}", (Object)snbtFile);
            try {
                BlockPos pos;
                StructureTemplateManager manager = level.getServer().getStructureManager();
                String textInFile = (String)contentSupplier.get();
                if (textInFile == null) continue;
                CompoundTag compound = NbtUtils.snbtToStructure((String)textInFile);
                StructureTemplate structure = manager.readStructure(compound);
                if (!structure.placeInWorld((ServerLevelAccessor)level, pos = (BlockPos)origin.getValue(), pos, new StructurePlaceSettings(), (RandomSource)new SingleThreadedRandomSource(0L), 2)) {
                    player.sendSystemMessage((Component)Component.literal((String)("Failed to place " + snbtFile)));
                }
                origin.setValue((Object)((BlockPos)origin.getValue()).offset(structure.getSize().getX() + 2, 0, 0));
            }
            catch (Exception e) {
                LOG.error("Failed to place {}.", (Object)snbtFile, (Object)e);
                player.sendSystemMessage((Component)Component.literal((String)("Failed to place " + snbtFile + ": " + String.valueOf(e))));
            }
        }
    }

    private static void importStructure(ServerLevel level, BlockPos origin) {
        Minecraft minecraft = Minecraft.getInstance();
        IntegratedServer server = minecraft.getSingleplayerServer();
        LocalPlayer player = minecraft.player;
        if (server == null || player == null) {
            return;
        }
        ((CompletableFuture)CompletableFuture.supplyAsync(StructureCommands::pickFileForOpen, (Executor)minecraft).thenApplyAsync(selectedPath -> {
            if (selectedPath == null) {
                return null;
            }
            lastOpenedOrSavedPath = selectedPath;
            try {
                if (StructureCommands.placeStructure(level, origin, selectedPath)) {
                    player.sendSystemMessage((Component)Component.literal((String)"Placed structure"));
                } else {
                    player.sendSystemMessage((Component)Component.literal((String)"Failed to place structure"));
                }
            }
            catch (Exception e) {
                LOG.error("Failed to place structure.", (Throwable)e);
                player.sendSystemMessage((Component)Component.literal((String)e.toString()));
            }
            return null;
        }, (Executor)server)).thenRunAsync(() -> {
            if (minecraft.screen instanceof PauseScreen) {
                minecraft.setScreen(null);
            }
        }, (Executor)minecraft);
    }

    private static boolean placeStructure(ServerLevel level, BlockPos origin, String structurePath) throws CommandSyntaxException, IOException {
        CompoundTag compound;
        StructureTemplateManager manager = level.getServer().getStructureManager();
        if (structurePath.toLowerCase(Locale.ROOT).endsWith(".snbt")) {
            String textInFile = Files.readString(Paths.get(structurePath, new String[0]), StandardCharsets.UTF_8);
            compound = NbtUtils.snbtToStructure((String)textInFile);
        } else {
            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(structurePath));){
                compound = NbtIo.readCompressed((InputStream)is, (NbtAccounter)NbtAccounter.unlimitedHeap());
            }
        }
        StructureTemplate structure = manager.readStructure(compound);
        return structure.placeInWorld((ServerLevelAccessor)level, origin, origin, new StructurePlaceSettings(), (RandomSource)new SingleThreadedRandomSource(0L), 2);
    }

    private static void registerExportCommand(LiteralArgumentBuilder<CommandSourceStack> rootCommand) {
        LiteralArgumentBuilder exportSubcommand = LiteralArgumentBuilder.literal((String)"exportstructure");
        ((LiteralArgumentBuilder)exportSubcommand.requires(c -> c.hasPermission(2))).then(Commands.argument((String)"origin", (ArgumentType)BlockPosArgument.blockPos()).then(Commands.argument((String)"sizeX", (ArgumentType)IntegerArgumentType.integer((int)1)).then(Commands.argument((String)"sizeY", (ArgumentType)IntegerArgumentType.integer((int)1)).then(Commands.argument((String)"sizeZ", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> {
            ServerLevel level = StructureCommands.getIntegratedServerLevel((CommandContext<CommandSourceStack>)context);
            if (level == null) {
                return 1;
            }
            BlockPos origin = BlockPosArgument.getBlockPos((CommandContext)context, (String)"origin");
            int sizeX = IntegerArgumentType.getInteger((CommandContext)context, (String)"sizeX");
            int sizeY = IntegerArgumentType.getInteger((CommandContext)context, (String)"sizeY");
            int sizeZ = IntegerArgumentType.getInteger((CommandContext)context, (String)"sizeZ");
            Vec3i size = new Vec3i(sizeX, sizeY, sizeZ);
            StructureCommands.exportStructure(level, origin, size);
            return 0;
        })))));
        rootCommand.then((ArgumentBuilder)exportSubcommand);
    }

    private static void exportStructure(ServerLevel level, BlockPos origin, Vec3i size) {
        Minecraft minecraft = Minecraft.getInstance();
        IntegratedServer server = minecraft.getSingleplayerServer();
        LocalPlayer player = minecraft.player;
        if (server == null || player == null) {
            return;
        }
        ((CompletableFuture)CompletableFuture.supplyAsync(StructureCommands::pickFileForSave, (Executor)minecraft).thenApplyAsync(selectedPath -> {
            if (selectedPath == null) {
                return null;
            }
            try {
                BlockPos to = BlockPos.betweenClosedStream((BlockPos)origin, (BlockPos)origin.offset(size.getX() - 1, size.getY() - 1, size.getZ() - 1)).filter(pos -> !level.getBlockState(pos).isAir()).reduce(origin, (blockPos, blockPos2) -> new BlockPos(Math.max(blockPos.getX(), blockPos2.getX()), Math.max(blockPos.getY(), blockPos2.getY()), Math.max(blockPos.getZ(), blockPos2.getZ())));
                BlockPos actualSize = new BlockPos(1 + to.getX() - origin.getX(), 1 + to.getY() - origin.getY(), 1 + to.getZ() - origin.getZ());
                StructureTemplate structureTemplate = new StructureTemplate();
                structureTemplate.fillFromWorld((Level)level, origin, (Vec3i)actualSize, false, Blocks.AIR);
                CompoundTag compound = structureTemplate.save(new CompoundTag());
                if (selectedPath.toLowerCase(Locale.ROOT).endsWith(".snbt")) {
                    Files.writeString(Paths.get(selectedPath, new String[0]), (CharSequence)NbtUtils.structureToSnbt((CompoundTag)compound), StandardCharsets.UTF_8, new OpenOption[0]);
                } else {
                    NbtIo.writeCompressed((CompoundTag)compound, (Path)Paths.get(selectedPath, new String[0]));
                }
                player.sendSystemMessage((Component)Component.literal((String)"Saved structure"));
            }
            catch (IOException e) {
                LOG.error("Failed to save structure.", (Throwable)e);
                player.sendSystemMessage((Component)Component.literal((String)e.toString()));
            }
            return null;
        }, (Executor)server)).thenRunAsync(() -> {
            if (minecraft.screen instanceof PauseScreen) {
                minecraft.setScreen(null);
            }
        }, (Executor)minecraft);
    }

    private static String pickFileForOpen() {
        StructureCommands.setDefaultFolder();
        try (MemoryStack stack = MemoryStack.stackPush();){
            String string = TinyFileDialogs.tinyfd_openFileDialog((CharSequence)"Load Structure", (CharSequence)lastOpenedOrSavedPath, (PointerBuffer)StructureCommands.createFilterPatterns(stack), (CharSequence)"Structure NBT Files (*.snbt, *.nbt)", (boolean)false);
            return string;
        }
    }

    private static String pickFileForSave() {
        StructureCommands.setDefaultFolder();
        try (MemoryStack stack = MemoryStack.stackPush();){
            String string = TinyFileDialogs.tinyfd_saveFileDialog((CharSequence)"Save Structure", (CharSequence)lastOpenedOrSavedPath, (PointerBuffer)StructureCommands.createFilterPatterns(stack), (CharSequence)"Structure NBT Files (*.snbt, *.nbt)");
            return string;
        }
    }

    private static PointerBuffer createFilterPatterns(MemoryStack stack) {
        PointerBuffer filterPatternsBuffer = stack.mallocPointer(FILE_PATTERNS.length);
        for (String pattern : FILE_PATTERNS) {
            filterPatternsBuffer.put(stack.UTF8((CharSequence)pattern));
        }
        filterPatternsBuffer.flip();
        return filterPatternsBuffer;
    }

    private static void setDefaultFolder() {
        if (lastOpenedOrSavedPath == null) {
            for (MutableGuide guide : GuideRegistry.getAll()) {
                if (guide.getDevelopmentSourceFolder() == null) continue;
                lastOpenedOrSavedPath = guide.getDevelopmentSourceFolder().toString();
                if (lastOpenedOrSavedPath.endsWith("/") || lastOpenedOrSavedPath.endsWith("\\")) break;
                lastOpenedOrSavedPath = lastOpenedOrSavedPath + File.separator;
                break;
            }
        }
    }

    static {
        FILE_PATTERNS = new String[]{"*.snbt", "*.nbt"};
    }
}

