/*
 * Decompiled with CFR 0.152.
 */
package guideme.libs.micromark.commonmark;

import guideme.libs.micromark.Assert;
import guideme.libs.micromark.CharUtil;
import guideme.libs.micromark.Construct;
import guideme.libs.micromark.State;
import guideme.libs.micromark.TokenizeContext;
import guideme.libs.micromark.Tokenizer;

public final class CharacterEscape {
    public static final Construct characterEscape = new Construct();

    static {
        CharacterEscape.characterEscape.name = "characterEscape";
        CharacterEscape.characterEscape.tokenize = (context, effects, ok, nok) -> new StateMachine(context, effects, ok, nok)::start;
    }

    private static class StateMachine {
        private final TokenizeContext context;
        private final Tokenizer.Effects effects;
        private final State ok;
        private final State nok;

        public StateMachine(TokenizeContext context, Tokenizer.Effects effects, State ok, State nok) {
            this.context = context;
            this.effects = effects;
            this.ok = ok;
            this.nok = nok;
        }

        private State start(int code) {
            Assert.check(code == 92, "expected `\\`");
            this.effects.enter("characterEscape");
            this.effects.enter("escapeMarker");
            this.effects.consume(code);
            this.effects.exit("escapeMarker");
            return this::open;
        }

        private State open(int code) {
            if (CharUtil.asciiPunctuation(code)) {
                this.effects.enter("characterEscapeValue");
                this.effects.consume(code);
                this.effects.exit("characterEscapeValue");
                this.effects.exit("characterEscape");
                return this.ok;
            }
            return this.nok.step(code);
        }
    }
}

