/*
 * Decompiled with CFR 0.152.
 */
package guideme.libs.micromark.commonmark;

import guideme.libs.micromark.Assert;
import guideme.libs.micromark.CharUtil;
import guideme.libs.micromark.Construct;
import guideme.libs.micromark.State;
import guideme.libs.micromark.Token;
import guideme.libs.micromark.TokenizeContext;
import guideme.libs.micromark.Tokenizer;
import guideme.libs.micromark.factory.FactorySpace;

public final class BlockQuote {
    public static final Construct blockQuote = new Construct();

    private static void exit(TokenizeContext context, Tokenizer.Effects effects) {
        effects.exit("blockQuote");
    }

    static {
        BlockQuote.blockQuote.name = "blockQuote";
        BlockQuote.blockQuote.tokenize = (context, effects, ok, nok) -> new StateMachine(context, effects, ok, nok)::start;
        BlockQuote.blockQuote.continuation = new Construct();
        BlockQuote.blockQuote.continuation.tokenize = (context, effects, ok, nok) -> FactorySpace.create(effects, effects.attempt.hook(blockQuote, ok, nok), "linePrefix", context.getParser().constructs.nullDisable.contains("codeIndented") ? Integer.MAX_VALUE : 4);
        BlockQuote.blockQuote.exit = BlockQuote::exit;
    }

    static class StateMachine {
        private final TokenizeContext context;
        private final Tokenizer.Effects effects;
        private final State ok;
        private final State nok;

        public StateMachine(TokenizeContext context, Tokenizer.Effects effects, State ok, State nok) {
            this.context = context;
            this.effects = effects;
            this.ok = ok;
            this.nok = nok;
        }

        State start(int code) {
            if (code == 62) {
                Tokenizer.ContainerState state = this.context.getContainerState();
                Assert.check(state != null, "expected `containerState` to be defined in container");
                if (!state.containsKey("open")) {
                    Token token = new Token();
                    token._container = true;
                    this.effects.enter("blockQuote", token);
                    state.put("open", true);
                }
                this.effects.enter("blockQuotePrefix");
                this.effects.enter("blockQuoteMarker");
                this.effects.consume(code);
                this.effects.exit("blockQuoteMarker");
                return this::after;
            }
            return this.nok.step(code);
        }

        State after(int code) {
            if (CharUtil.markdownSpace(code)) {
                this.effects.enter("blockQuotePrefixWhitespace");
                this.effects.consume(code);
                this.effects.exit("blockQuotePrefixWhitespace");
                this.effects.exit("blockQuotePrefix");
                return this.ok;
            }
            this.effects.exit("blockQuotePrefix");
            return this.ok.step(code);
        }
    }
}

