/*
 * Decompiled with CFR 0.152.
 */
package guideme.libs.micromark;

import guideme.libs.micromark.Construct;
import guideme.libs.micromark.Point;
import guideme.libs.micromark.Token;
import guideme.libs.micromark.TokenizeContext;
import guideme.libs.micromark.Tokenizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RootTokenizeContext
implements TokenizeContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(RootTokenizeContext.class);
    private final Tokenizer tokenizer;
    public boolean _gfmTableDynamicInterruptHack;
    public boolean _gfmTasklistFirstContentOfListItem;
    private int previous = Integer.MIN_VALUE;
    private boolean interrupt;
    @Nullable
    private Construct currentConstruct;
    private Tokenizer.ContainerState containerState = new Tokenizer.ContainerState();
    private List<Tokenizer.Event> events = new ArrayList<Tokenizer.Event>();

    @Override
    @Nullable
    public Tokenizer.Event getLastEvent() {
        return !this.getEvents().isEmpty() ? this.getEvents().get(this.getEvents().size() - 1) : null;
    }

    public RootTokenizeContext(Tokenizer tokenizer) {
        this.tokenizer = tokenizer;
    }

    @Override
    public List<Object> sliceStream(Token token) {
        return this.sliceStream(token.start, token.end);
    }

    public List<Object> sliceStream(Point start, Point end) {
        return this.sliceChunks(this.tokenizer.chunks, start, end);
    }

    @Override
    public List<Tokenizer.Event> write(List<Object> slice) {
        this.tokenizer.chunks.addAll(slice);
        this.tokenizer.main();
        if (!Objects.equals(this.tokenizer.chunks.get(this.tokenizer.chunks.size() - 1), Integer.MIN_VALUE)) {
            return Collections.emptyList();
        }
        this.tokenizer.addResult(this.tokenizer.initialize, 0);
        this.tokenizer.context.setEvents(Construct.resolveAll(this.tokenizer.resolveAllConstructs, this.tokenizer.context.getEvents(), this.tokenizer.context));
        return this.tokenizer.context.getEvents();
    }

    @Override
    public String sliceSerialize(Point start, Point end) {
        Token t = new Token();
        t.start = start;
        t.end = end;
        return this.sliceSerialize(t, false);
    }

    @Override
    public String sliceSerialize(Token token) {
        return this.sliceSerialize(token, false);
    }

    @Override
    public String sliceSerialize(Token token, boolean expandTabs) {
        return this.tokenizer.serializeChunks(this.sliceStream(token), expandTabs);
    }

    @Override
    public void defineSkip(Point value) {
        this.tokenizer.columnStart.put(value.line(), value.column());
        this.tokenizer.accountForPotentialSkip();
    }

    @Override
    public Point now() {
        return this.tokenizer.now();
    }

    @Override
    public boolean isOnLazyLine() {
        return this.tokenizer.isOnLazyLine();
    }

    @Override
    public boolean isInterrupt() {
        return this.interrupt;
    }

    @Override
    public void setInterrupt(boolean interrupt) {
        this.interrupt = interrupt;
    }

    @Override
    public int getPrevious() {
        return this.previous;
    }

    @Override
    public void setPrevious(int previous) {
        this.previous = previous;
    }

    @Override
    public Construct getCurrentConstruct() {
        return this.currentConstruct;
    }

    @Override
    public void setCurrentConstruct(Construct currentConstruct) {
        this.currentConstruct = currentConstruct;
    }

    @Override
    public Tokenizer.ContainerState getContainerState() {
        return this.containerState;
    }

    @Override
    public void setContainerState(Tokenizer.ContainerState containerState) {
        this.containerState = containerState;
    }

    @Override
    public List<Tokenizer.Event> getEvents() {
        return this.events;
    }

    @Override
    public void setEvents(List<Tokenizer.Event> events) {
        this.events = events;
    }

    @Override
    public Tokenizer getTokenizer() {
        return this.tokenizer;
    }

    @Override
    public boolean isGfmTableDynamicInterruptHack() {
        return this._gfmTableDynamicInterruptHack;
    }

    @Override
    public void setGfmTableDynamicInterruptHack(boolean value) {
        this._gfmTableDynamicInterruptHack = value;
    }

    @Override
    public void setGfmTasklistFirstContentOfListItem(boolean value) {
        this._gfmTasklistFirstContentOfListItem = value;
    }
}

