/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.util.fst;

import guideme.internal.shaded.lucene.codecs.CodecUtil;
import guideme.internal.shaded.lucene.index.CorruptIndexException;
import guideme.internal.shaded.lucene.store.ByteBuffersDataOutput;
import guideme.internal.shaded.lucene.store.DataInput;
import guideme.internal.shaded.lucene.store.DataOutput;
import guideme.internal.shaded.lucene.util.Accountable;
import guideme.internal.shaded.lucene.util.Constants;
import guideme.internal.shaded.lucene.util.RamUsageEstimator;
import guideme.internal.shaded.lucene.util.fst.BitTableUtil;
import guideme.internal.shaded.lucene.util.fst.FSTCompiler;
import guideme.internal.shaded.lucene.util.fst.FSTReader;
import guideme.internal.shaded.lucene.util.fst.Outputs;
import guideme.internal.shaded.lucene.util.fst.ReadWriteDataOutput;
import java.io.IOException;
import java.util.Objects;

public final class FST<T>
implements Accountable {
    final FSTMetadata<T> metadata;
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(FST.class);
    private final FSTReader fstReader;
    public final Outputs<T> outputs;
    private static final int DEFAULT_MAX_BLOCK_BITS = Constants.JRE_IS_64BIT ? 30 : 28;

    private static boolean flag(int flags, int bit) {
        return (flags & bit) != 0;
    }

    FST(FSTMetadata<T> metadata, FSTReader fstReader) {
        assert (fstReader != null);
        this.metadata = Objects.requireNonNull(metadata, "FSTMetadata cannot be null");
        this.outputs = metadata.outputs;
        this.fstReader = fstReader;
    }

    public static <T> FST<T> fromFSTReader(FSTMetadata<T> fstMetadata, FSTReader fstReader) {
        if (fstMetadata == null) {
            return null;
        }
        return new FST<T>(fstMetadata, Objects.requireNonNull(fstReader, "FSTReader cannot be null"));
    }

    public static <T> FSTMetadata<T> readMetadata(DataInput metaIn, Outputs<T> outputs) throws IOException {
        Object emptyOutput;
        int version = CodecUtil.checkHeader(metaIn, "FST", 6, 9);
        if (metaIn.readByte() == 1) {
            ReadWriteDataOutput emptyBytes = (ReadWriteDataOutput)FSTCompiler.getOnHeapReaderWriter(10);
            int numBytes = metaIn.readVInt();
            emptyBytes.copyBytes(metaIn, numBytes);
            emptyBytes.freeze();
            BytesReader reader = emptyBytes.getReverseBytesReader();
            if (numBytes > 0) {
                reader.setPosition(numBytes - 1);
            }
            emptyOutput = outputs.readFinalOutput(reader);
        } else {
            emptyOutput = null;
        }
        byte t = metaIn.readByte();
        INPUT_TYPE inputType = switch (t) {
            case 0 -> INPUT_TYPE.BYTE1;
            case 1 -> INPUT_TYPE.BYTE2;
            case 2 -> INPUT_TYPE.BYTE4;
            default -> throw new CorruptIndexException("invalid input type " + t, metaIn);
        };
        long startNode = metaIn.readVLong();
        long numBytes = metaIn.readVLong();
        return new FSTMetadata<Object>(inputType, (Outputs<Object>)outputs, emptyOutput, startNode, version, numBytes);
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + this.fstReader.ramBytesUsed();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(input=" + String.valueOf((Object)this.metadata.inputType) + ",output=" + String.valueOf(this.outputs);
    }

    public long numBytes() {
        return this.metadata.numBytes;
    }

    public T getEmptyOutput() {
        return this.metadata.emptyOutput;
    }

    public void save(DataOutput metaOut, DataOutput out) throws IOException {
        this.metadata.save(metaOut);
        this.fstReader.writeTo(out);
    }

    public int readLabel(DataInput in) throws IOException {
        int v = this.metadata.inputType == INPUT_TYPE.BYTE1 ? in.readByte() & 0xFF : (this.metadata.inputType == INPUT_TYPE.BYTE2 ? (this.metadata.version < 8 ? Short.reverseBytes(in.readShort()) & 0xFFFF : in.readShort() & 0xFFFF) : in.readVInt());
        return v;
    }

    public static <T> boolean targetHasArcs(Arc<T> arc) {
        return arc.target() > 0L;
    }

    static int getNumPresenceBytes(int labelRange) {
        assert (labelRange >= 0);
        return labelRange + 7 >> 3;
    }

    private void readPresenceBytes(Arc<T> arc, BytesReader in) throws IOException {
        assert (arc.bytesPerArc() > 0);
        assert (arc.nodeFlags() == 64);
        arc.bitTableStart = in.getPosition();
        in.skipBytes(FST.getNumPresenceBytes(arc.numArcs()));
    }

    public Arc<T> getFirstArc(Arc<T> arc) {
        T NO_OUTPUT = this.outputs.getNoOutput();
        if (this.metadata.emptyOutput != null) {
            arc.flags = (byte)3;
            arc.nextFinalOutput = this.metadata.emptyOutput;
            if (this.metadata.emptyOutput != NO_OUTPUT) {
                arc.flags = (byte)(arc.flags() | 0x20);
            }
        } else {
            arc.flags = (byte)2;
            arc.nextFinalOutput = NO_OUTPUT;
        }
        arc.output = NO_OUTPUT;
        arc.target = this.metadata.startNode;
        return arc;
    }

    private long readUnpackedNodeTarget(BytesReader in) throws IOException {
        return in.readVLong();
    }

    public Arc<T> readFirstTargetArc(Arc<T> follow, Arc<T> arc, BytesReader in) throws IOException {
        if (follow.isFinal()) {
            arc.label = -1;
            arc.output = follow.nextFinalOutput();
            arc.flags = 1;
            if (follow.target() <= 0L) {
                arc.flags = (byte)(arc.flags | 2);
            } else {
                arc.nextArc = follow.target();
            }
            arc.target = -1L;
            arc.nodeFlags = arc.flags;
            return arc;
        }
        return this.readFirstRealTargetArc(follow.target(), arc, in);
    }

    private void readFirstArcInfo(long nodeAddress, Arc<T> arc, BytesReader in) throws IOException {
        in.setPosition(nodeAddress);
        byte flags = arc.nodeFlags = in.readByte();
        if (flags == 32 || flags == 64 || flags == 96) {
            arc.numArcs = in.readVInt();
            arc.bytesPerArc = in.readVInt();
            arc.arcIdx = -1;
            if (flags == 64) {
                this.readPresenceBytes(arc, in);
                arc.firstLabel = this.readLabel(in);
                arc.presenceIndex = -1;
            } else if (flags == 96) {
                arc.firstLabel = this.readLabel(in);
            }
            arc.posArcsStart = in.getPosition();
        } else {
            arc.nextArc = nodeAddress;
            arc.bytesPerArc = 0;
        }
    }

    public Arc<T> readFirstRealTargetArc(long nodeAddress, Arc<T> arc, BytesReader in) throws IOException {
        this.readFirstArcInfo(nodeAddress, arc, in);
        return this.readNextRealArc(arc, in);
    }

    public Arc<T> readNextArc(Arc<T> arc, BytesReader in) throws IOException {
        if (arc.label() == -1) {
            if (arc.nextArc() <= 0L) {
                throw new IllegalArgumentException("cannot readNextArc when arc.isLast()=true");
            }
            return this.readFirstRealTargetArc(arc.nextArc(), arc, in);
        }
        return this.readNextRealArc(arc, in);
    }

    public Arc<T> readArcByDirectAddressing(Arc<T> arc, BytesReader in, int rangeIndex) throws IOException {
        assert (Arc.BitTable.assertIsValid(arc, in));
        assert (rangeIndex >= 0 && rangeIndex < arc.numArcs());
        assert (Arc.BitTable.isBitSet(rangeIndex, arc, in));
        int presenceIndex = Arc.BitTable.countBitsUpTo(rangeIndex, arc, in);
        return this.readArcByDirectAddressing(arc, in, rangeIndex, presenceIndex);
    }

    private Arc<T> readArcByDirectAddressing(Arc<T> arc, BytesReader in, int rangeIndex, int presenceIndex) throws IOException {
        in.setPosition(arc.posArcsStart() - (long)presenceIndex * (long)arc.bytesPerArc());
        arc.arcIdx = rangeIndex;
        arc.presenceIndex = presenceIndex;
        arc.flags = in.readByte();
        return this.readArc(arc, in);
    }

    public Arc<T> readNextRealArc(Arc<T> arc, BytesReader in) throws IOException {
        switch (arc.nodeFlags()) {
            case 32: 
            case 96: {
                assert (arc.bytesPerArc() > 0);
                ++arc.arcIdx;
                assert (arc.arcIdx() >= 0 && arc.arcIdx() < arc.numArcs());
                in.setPosition(arc.posArcsStart() - (long)arc.arcIdx() * (long)arc.bytesPerArc());
                arc.flags = in.readByte();
                break;
            }
            case 64: {
                assert (Arc.BitTable.assertIsValid(arc, in));
                assert (arc.arcIdx() == -1 || Arc.BitTable.isBitSet(arc.arcIdx(), arc, in));
                int nextIndex = Arc.BitTable.nextBitSet(arc.arcIdx(), arc, in);
                return this.readArcByDirectAddressing(arc, in, nextIndex, arc.presenceIndex + 1);
            }
            default: {
                assert (arc.bytesPerArc() == 0);
                in.setPosition(arc.nextArc());
                arc.flags = in.readByte();
            }
        }
        return this.readArc(arc, in);
    }

    private Arc<T> readArc(Arc<T> arc, BytesReader in) throws IOException {
        arc.label = arc.nodeFlags() == 64 || arc.nodeFlags() == 96 ? arc.firstLabel() + arc.arcIdx() : this.readLabel(in);
        arc.output = arc.flag(16) ? this.outputs.read(in) : this.outputs.getNoOutput();
        arc.nextFinalOutput = arc.flag(32) ? this.outputs.readFinalOutput(in) : this.outputs.getNoOutput();
        if (arc.flag(8)) {
            arc.target = arc.flag(1) ? -1L : 0L;
            arc.nextArc = in.getPosition();
        } else if (arc.flag(4)) {
            arc.nextArc = in.getPosition();
            if (!arc.flag(2)) {
                if (arc.bytesPerArc() == 0) {
                    this.seekToNextNode(in);
                } else {
                    int numArcs = arc.nodeFlags == 64 ? Arc.BitTable.countBits(arc, in) : arc.numArcs();
                    in.setPosition(arc.posArcsStart() - (long)arc.bytesPerArc() * (long)numArcs);
                }
            }
            arc.target = in.getPosition();
        } else {
            arc.target = this.readUnpackedNodeTarget(in);
            arc.nextArc = in.getPosition();
        }
        return arc;
    }

    public Arc<T> findTargetArc(int labelToMatch, Arc<T> follow, Arc<T> arc, BytesReader in) throws IOException {
        if (labelToMatch == -1) {
            if (follow.isFinal()) {
                if (follow.target() <= 0L) {
                    arc.flags = (byte)2;
                } else {
                    arc.flags = 0;
                    arc.nextArc = follow.target();
                }
                arc.output = follow.nextFinalOutput();
                arc.label = -1;
                arc.nodeFlags = arc.flags;
                return arc;
            }
            return null;
        }
        if (!FST.targetHasArcs(follow)) {
            return null;
        }
        in.setPosition(follow.target());
        byte flags = arc.nodeFlags = in.readByte();
        if (flags == 64) {
            arc.numArcs = in.readVInt();
            arc.bytesPerArc = in.readVInt();
            this.readPresenceBytes(arc, in);
            arc.firstLabel = this.readLabel(in);
            arc.posArcsStart = in.getPosition();
            int arcIndex = labelToMatch - arc.firstLabel();
            if (arcIndex < 0 || arcIndex >= arc.numArcs()) {
                return null;
            }
            if (!Arc.BitTable.isBitSet(arcIndex, arc, in)) {
                return null;
            }
            return this.readArcByDirectAddressing(arc, in, arcIndex);
        }
        if (flags == 32) {
            arc.numArcs = in.readVInt();
            arc.bytesPerArc = in.readVInt();
            arc.posArcsStart = in.getPosition();
            int low = 0;
            int high = arc.numArcs() - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                in.setPosition(arc.posArcsStart() - (long)(arc.bytesPerArc() * mid + 1));
                int midLabel = this.readLabel(in);
                int cmp = midLabel - labelToMatch;
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                arc.arcIdx = mid - 1;
                return this.readNextRealArc(arc, in);
            }
            return null;
        }
        if (flags == 96) {
            arc.numArcs = in.readVInt();
            arc.bytesPerArc = in.readVInt();
            arc.firstLabel = this.readLabel(in);
            arc.posArcsStart = in.getPosition();
            int arcIndex = labelToMatch - arc.firstLabel();
            if (arcIndex < 0 || arcIndex >= arc.numArcs()) {
                return null;
            }
            arc.arcIdx = arcIndex - 1;
            return this.readNextRealArc(arc, in);
        }
        this.readFirstArcInfo(follow.target(), arc, in);
        in.setPosition(arc.nextArc());
        while (true) {
            assert (arc.bytesPerArc() == 0);
            flags = arc.flags = in.readByte();
            long pos = in.getPosition();
            int label = this.readLabel(in);
            if (label == labelToMatch) {
                in.setPosition(pos);
                return this.readArc(arc, in);
            }
            if (label > labelToMatch) {
                return null;
            }
            if (arc.isLast()) {
                return null;
            }
            if (FST.flag(flags, 16)) {
                this.outputs.skipOutput(in);
            }
            if (FST.flag(flags, 32)) {
                this.outputs.skipFinalOutput(in);
            }
            if (FST.flag(flags, 8) || FST.flag(flags, 4)) continue;
            this.readUnpackedNodeTarget(in);
        }
    }

    private void seekToNextNode(BytesReader in) throws IOException {
        byte flags;
        do {
            flags = in.readByte();
            this.readLabel(in);
            if (FST.flag(flags, 16)) {
                this.outputs.skipOutput(in);
            }
            if (FST.flag(flags, 32)) {
                this.outputs.skipFinalOutput(in);
            }
            if (FST.flag(flags, 8) || FST.flag(flags, 4)) continue;
            this.readUnpackedNodeTarget(in);
        } while (!FST.flag(flags, 2));
    }

    public BytesReader getBytesReader() {
        return this.fstReader.getReverseBytesReader();
    }

    public static final class FSTMetadata<T> {
        final INPUT_TYPE inputType;
        final Outputs<T> outputs;
        final int version;
        T emptyOutput;
        long startNode;
        long numBytes;

        public FSTMetadata(INPUT_TYPE inputType, Outputs<T> outputs, T emptyOutput, long startNode, int version, long numBytes) {
            this.inputType = inputType;
            this.outputs = outputs;
            this.emptyOutput = emptyOutput;
            this.startNode = startNode;
            this.version = version;
            this.numBytes = numBytes;
        }

        public T getEmptyOutput() {
            return this.emptyOutput;
        }

        public void save(DataOutput metaOut) throws IOException {
            CodecUtil.writeHeader(metaOut, "FST", 9);
            if (this.emptyOutput != null) {
                metaOut.writeByte((byte)1);
                ByteBuffersDataOutput ros = new ByteBuffersDataOutput();
                this.outputs.writeFinalOutput(this.emptyOutput, ros);
                byte[] emptyOutputBytes = ros.toArrayCopy();
                int emptyLen = emptyOutputBytes.length;
                int stopAt = emptyLen / 2;
                for (int upto = 0; upto < stopAt; ++upto) {
                    byte b = emptyOutputBytes[upto];
                    emptyOutputBytes[upto] = emptyOutputBytes[emptyLen - upto - 1];
                    emptyOutputBytes[emptyLen - upto - 1] = b;
                }
                metaOut.writeVInt(emptyLen);
                metaOut.writeBytes(emptyOutputBytes, 0, emptyLen);
            } else {
                metaOut.writeByte((byte)0);
            }
            int t = this.inputType == INPUT_TYPE.BYTE1 ? 0 : (this.inputType == INPUT_TYPE.BYTE2 ? 1 : 2);
            metaOut.writeByte((byte)t);
            metaOut.writeVLong(this.startNode);
            metaOut.writeVLong(this.numBytes);
        }
    }

    public static abstract class BytesReader
    extends DataInput {
        public abstract long getPosition();

        public abstract void setPosition(long var1);
    }

    public static enum INPUT_TYPE {
        BYTE1,
        BYTE2,
        BYTE4;

    }

    public static final class Arc<T> {
        private int label;
        private T output;
        private long target;
        private byte flags;
        private T nextFinalOutput;
        private long nextArc;
        private byte nodeFlags;
        private int bytesPerArc;
        private long posArcsStart;
        private int arcIdx;
        private int numArcs;
        private long bitTableStart;
        private int firstLabel;
        private int presenceIndex;

        boolean flag(int flag) {
            return FST.flag(this.flags, flag);
        }

        public boolean isLast() {
            return this.flag(2);
        }

        public boolean isFinal() {
            return this.flag(1);
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append(" target=").append(this.target());
            b.append(" label=0x").append(Integer.toHexString(this.label()));
            if (this.flag(1)) {
                b.append(" final");
            }
            if (this.flag(2)) {
                b.append(" last");
            }
            if (this.flag(4)) {
                b.append(" targetNext");
            }
            if (this.flag(8)) {
                b.append(" stop");
            }
            if (this.flag(16)) {
                b.append(" output=").append(this.output());
            }
            if (this.flag(32)) {
                b.append(" nextFinalOutput=").append(this.nextFinalOutput());
            }
            if (this.bytesPerArc() != 0) {
                b.append(" arcArray(idx=").append(this.arcIdx()).append(" of ").append(this.numArcs()).append(")").append("(").append(this.nodeFlags() == 64 ? "da" : (this.nodeFlags() == 96 ? "cs" : "bs")).append(")");
            }
            return b.toString();
        }

        public int label() {
            return this.label;
        }

        public T output() {
            return this.output;
        }

        public long target() {
            return this.target;
        }

        public byte flags() {
            return this.flags;
        }

        public T nextFinalOutput() {
            return this.nextFinalOutput;
        }

        long nextArc() {
            return this.nextArc;
        }

        public int arcIdx() {
            return this.arcIdx;
        }

        public byte nodeFlags() {
            return this.nodeFlags;
        }

        public long posArcsStart() {
            return this.posArcsStart;
        }

        public int bytesPerArc() {
            return this.bytesPerArc;
        }

        public int numArcs() {
            return this.numArcs;
        }

        int firstLabel() {
            return this.firstLabel;
        }

        static class BitTable {
            static boolean isBitSet(int bitIndex, Arc<?> arc, BytesReader in) throws IOException {
                assert (arc.nodeFlags() == 64);
                in.setPosition(arc.bitTableStart);
                return BitTableUtil.isBitSet(bitIndex, in);
            }

            static int countBits(Arc<?> arc, BytesReader in) throws IOException {
                assert (arc.nodeFlags() == 64);
                in.setPosition(arc.bitTableStart);
                return BitTableUtil.countBits(FST.getNumPresenceBytes(arc.numArcs()), in);
            }

            static int countBitsUpTo(int bitIndex, Arc<?> arc, BytesReader in) throws IOException {
                assert (arc.nodeFlags() == 64);
                in.setPosition(arc.bitTableStart);
                return BitTableUtil.countBitsUpTo(bitIndex, in);
            }

            static int nextBitSet(int bitIndex, Arc<?> arc, BytesReader in) throws IOException {
                assert (arc.nodeFlags() == 64);
                in.setPosition(arc.bitTableStart);
                return BitTableUtil.nextBitSet(bitIndex, FST.getNumPresenceBytes(arc.numArcs()), in);
            }

            static boolean assertIsValid(Arc<?> arc, BytesReader in) throws IOException {
                assert (arc.bytesPerArc() > 0);
                assert (arc.nodeFlags() == 64);
                assert (BitTable.isBitSet(0, arc, in));
                assert (BitTable.isBitSet(arc.numArcs() - 1, arc, in));
                assert (BitTable.nextBitSet(arc.numArcs() - 1, arc, in) == -1);
                return true;
            }
        }
    }
}

