/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.util.bkd;

import guideme.internal.shaded.lucene.util.ArrayUtil;

public record BKDConfig(int numDims, int numIndexDims, int bytesPerDim, int maxPointsInLeafNode) {
    public BKDConfig {
        if (numDims < 1 || numDims > 16) {
            throw new IllegalArgumentException("numDims must be 1 .. 16 (got: " + numDims + ")");
        }
        if (numIndexDims < 1 || numIndexDims > 8) {
            throw new IllegalArgumentException("numIndexDims must be 1 .. 8 (got: " + numIndexDims + ")");
        }
        if (numIndexDims > numDims) {
            throw new IllegalArgumentException("numIndexDims cannot exceed numDims (" + numDims + ") (got: " + numIndexDims + ")");
        }
        if (bytesPerDim <= 0) {
            throw new IllegalArgumentException("bytesPerDim must be > 0; got " + bytesPerDim);
        }
        if (maxPointsInLeafNode <= 0) {
            throw new IllegalArgumentException("maxPointsInLeafNode must be > 0; got " + maxPointsInLeafNode);
        }
        if (maxPointsInLeafNode > ArrayUtil.MAX_ARRAY_LENGTH) {
            throw new IllegalArgumentException("maxPointsInLeafNode must be <= ArrayUtil.MAX_ARRAY_LENGTH (= " + ArrayUtil.MAX_ARRAY_LENGTH + "); got " + maxPointsInLeafNode);
        }
    }

    public int packedBytesLength() {
        return this.numDims * this.bytesPerDim;
    }

    public int packedIndexBytesLength() {
        return this.numIndexDims * this.bytesPerDim;
    }

    public int bytesPerDoc() {
        return this.packedBytesLength() + 4;
    }
}

