/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.util.automaton;

public class RegExp {
    public final Kind kind;
    public final RegExp exp1;
    public final RegExp exp2;
    public final String s;
    public final int c;
    public final int min;
    public final int max;
    public final int digits;
    public final int from;
    public final int to;

    public String toString() {
        StringBuilder b = new StringBuilder();
        this.toStringBuilder(b);
        return b.toString();
    }

    void toStringBuilder(StringBuilder b) {
        switch (this.kind.ordinal()) {
            case 0: {
                b.append("(");
                this.exp1.toStringBuilder(b);
                b.append("|");
                this.exp2.toStringBuilder(b);
                b.append(")");
                break;
            }
            case 1: {
                this.exp1.toStringBuilder(b);
                this.exp2.toStringBuilder(b);
                break;
            }
            case 2: {
                b.append("(");
                this.exp1.toStringBuilder(b);
                b.append("&");
                this.exp2.toStringBuilder(b);
                b.append(")");
                break;
            }
            case 3: {
                b.append("(");
                this.exp1.toStringBuilder(b);
                b.append(")?");
                break;
            }
            case 4: {
                b.append("(");
                this.exp1.toStringBuilder(b);
                b.append(")*");
                break;
            }
            case 5: {
                b.append("(");
                this.exp1.toStringBuilder(b);
                b.append("){").append(this.min).append(",}");
                break;
            }
            case 6: {
                b.append("(");
                this.exp1.toStringBuilder(b);
                b.append("){").append(this.min).append(",").append(this.max).append("}");
                break;
            }
            case 7: 
            case 17: {
                b.append("~(");
                this.exp1.toStringBuilder(b);
                b.append(")");
                break;
            }
            case 8: {
                b.append("\\").appendCodePoint(this.c);
                break;
            }
            case 9: {
                b.append("[\\").appendCodePoint(this.from).append("-\\").appendCodePoint(this.to).append("]");
                break;
            }
            case 10: {
                b.append(".");
                break;
            }
            case 11: {
                b.append("#");
                break;
            }
            case 12: {
                b.append("\"").append(this.s).append("\"");
                break;
            }
            case 13: {
                b.append("@");
                break;
            }
            case 14: {
                b.append("<").append(this.s).append(">");
                break;
            }
            case 15: {
                int i;
                String s1 = Integer.toString(this.min);
                String s2 = Integer.toString(this.max);
                b.append("<");
                if (this.digits > 0) {
                    for (i = s1.length(); i < this.digits; ++i) {
                        b.append('0');
                    }
                }
                b.append(s1).append("-");
                if (this.digits > 0) {
                    for (i = s2.length(); i < this.digits; ++i) {
                        b.append('0');
                    }
                }
                b.append(s2).append(">");
                break;
            }
            case 16: {
                b.append("\\").appendCodePoint(this.from);
            }
        }
    }

    public static enum Kind {
        REGEXP_UNION,
        REGEXP_CONCATENATION,
        REGEXP_INTERSECTION,
        REGEXP_OPTIONAL,
        REGEXP_REPEAT,
        REGEXP_REPEAT_MIN,
        REGEXP_REPEAT_MINMAX,
        REGEXP_COMPLEMENT,
        REGEXP_CHAR,
        REGEXP_CHAR_RANGE,
        REGEXP_ANYCHAR,
        REGEXP_EMPTY,
        REGEXP_STRING,
        REGEXP_ANYSTRING,
        REGEXP_AUTOMATON,
        REGEXP_INTERVAL,
        REGEXP_PRE_CLASS,
        REGEXP_DEPRECATED_COMPLEMENT;

    }
}

