/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search;

import guideme.internal.shaded.lucene.index.ImpactsEnum;
import guideme.internal.shaded.lucene.index.LeafReader;
import guideme.internal.shaded.lucene.index.LeafReaderContext;
import guideme.internal.shaded.lucene.index.PostingsEnum;
import guideme.internal.shaded.lucene.index.SlowImpactsEnum;
import guideme.internal.shaded.lucene.index.Term;
import guideme.internal.shaded.lucene.index.TermState;
import guideme.internal.shaded.lucene.index.TermStates;
import guideme.internal.shaded.lucene.index.Terms;
import guideme.internal.shaded.lucene.index.TermsEnum;
import guideme.internal.shaded.lucene.internal.hppc.IntArrayList;
import guideme.internal.shaded.lucene.search.BooleanClause;
import guideme.internal.shaded.lucene.search.ExactPhraseMatcher;
import guideme.internal.shaded.lucene.search.IndexSearcher;
import guideme.internal.shaded.lucene.search.MatchNoDocsQuery;
import guideme.internal.shaded.lucene.search.PhraseMatcher;
import guideme.internal.shaded.lucene.search.PhraseWeight;
import guideme.internal.shaded.lucene.search.Query;
import guideme.internal.shaded.lucene.search.QueryVisitor;
import guideme.internal.shaded.lucene.search.ScoreMode;
import guideme.internal.shaded.lucene.search.SloppyPhraseMatcher;
import guideme.internal.shaded.lucene.search.TermQuery;
import guideme.internal.shaded.lucene.search.TermStatistics;
import guideme.internal.shaded.lucene.search.Weight;
import guideme.internal.shaded.lucene.search.similarities.Similarity;
import guideme.internal.shaded.lucene.util.ArrayUtil;
import guideme.internal.shaded.lucene.util.IOSupplier;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class PhraseQuery
extends Query {
    private final int slop;
    private final String field;
    private final Term[] terms;
    private final int[] positions;

    private PhraseQuery(int slop, Term[] terms, int[] positions) {
        if (terms.length != positions.length) {
            throw new IllegalArgumentException("Must have as many terms as positions");
        }
        if (slop < 0) {
            throw new IllegalArgumentException("Slop must be >= 0, got " + slop);
        }
        for (Term term : terms) {
            Objects.requireNonNull(term, "Cannot add a null term to PhraseQuery");
        }
        for (int i = 1; i < terms.length; ++i) {
            if (terms[i - 1].field().equals(terms[i].field())) continue;
            throw new IllegalArgumentException("All terms should have the same field");
        }
        for (int position : positions) {
            if (position >= 0) continue;
            throw new IllegalArgumentException("Positions must be >= 0, got " + position);
        }
        for (int i = 1; i < positions.length; ++i) {
            if (positions[i] >= positions[i - 1]) continue;
            throw new IllegalArgumentException("Positions should not go backwards, got " + positions[i - 1] + " before " + positions[i]);
        }
        this.slop = slop;
        this.terms = terms;
        this.positions = positions;
        this.field = terms.length == 0 ? null : terms[0].field();
    }

    private static int[] incrementalPositions(int length) {
        int[] positions = new int[length];
        for (int i = 0; i < length; ++i) {
            positions[i] = i;
        }
        return positions;
    }

    private static Term[] toTerms(String field, String ... termStrings) {
        Term[] terms = new Term[termStrings.length];
        for (int i = 0; i < terms.length; ++i) {
            Objects.requireNonNull(termStrings[i], "Cannot add a null term to PhraseQuery");
            terms[i] = new Term(field, termStrings[i]);
        }
        return terms;
    }

    public PhraseQuery(int slop, String field, String ... terms) {
        this(slop, PhraseQuery.toTerms(field, terms), PhraseQuery.incrementalPositions(terms.length));
    }

    public PhraseQuery(String field, String ... terms) {
        this(0, field, terms);
    }

    public int getSlop() {
        return this.slop;
    }

    public Term[] getTerms() {
        return this.terms;
    }

    public int[] getPositions() {
        return this.positions;
    }

    @Override
    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        if (this.terms.length == 0) {
            return new MatchNoDocsQuery("empty PhraseQuery");
        }
        if (this.terms.length == 1) {
            return new TermQuery(this.terms[0]);
        }
        if (this.positions[0] != 0) {
            int[] newPositions = new int[this.positions.length];
            for (int i = 0; i < this.positions.length; ++i) {
                newPositions[i] = this.positions[i] - this.positions[0];
            }
            return new PhraseQuery(this.slop, this.terms, newPositions);
        }
        return super.rewrite(indexSearcher);
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (!visitor.acceptField(this.field)) {
            return;
        }
        QueryVisitor v = visitor.getSubVisitor(BooleanClause.Occur.MUST, this);
        v.consumeTerms(this, this.terms);
    }

    public static float termPositionsCost(TermsEnum termsEnum) throws IOException {
        int docFreq = termsEnum.docFreq();
        assert (docFreq > 0);
        long totalTermFreq = termsEnum.totalTermFreq();
        float expOccurrencesInMatchingDoc = (float)totalTermFreq / (float)docFreq;
        return 128.0f + expOccurrencesInMatchingDoc * 7.0f;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, final float boost) throws IOException {
        return new PhraseWeight(this, this.field, searcher, scoreMode){
            private transient TermStates[] states;

            @Override
            protected Similarity.SimScorer getStats(IndexSearcher searcher) throws IOException {
                int[] positions = PhraseQuery.this.getPositions();
                if (positions.length < 2) {
                    throw new IllegalStateException("PhraseWeight does not support less than 2 terms, call rewrite first");
                }
                if (positions[0] != 0) {
                    throw new IllegalStateException("PhraseWeight requires that the first position is 0, call rewrite first");
                }
                this.states = new TermStates[PhraseQuery.this.terms.length];
                TermStatistics[] termStats = new TermStatistics[PhraseQuery.this.terms.length];
                int termUpTo = 0;
                for (int i = 0; i < PhraseQuery.this.terms.length; ++i) {
                    TermStates ts;
                    Term term = PhraseQuery.this.terms[i];
                    this.states[i] = TermStates.build(searcher, term, this.scoreMode.needsScores());
                    if (!this.scoreMode.needsScores() || (ts = this.states[i]).docFreq() <= 0) continue;
                    termStats[termUpTo++] = searcher.termStatistics(term, ts.docFreq(), ts.totalTermFreq());
                }
                if (termUpTo > 0) {
                    return this.similarity.scorer(boost, searcher.collectionStatistics(this.field), ArrayUtil.copyOfSubArray(termStats, 0, termUpTo));
                }
                return null;
            }

            @Override
            protected PhraseMatcher getPhraseMatcher(LeafReaderContext context, Similarity.SimScorer scorer, boolean exposeOffsets) throws IOException {
                assert (PhraseQuery.this.terms.length > 0);
                LeafReader reader = context.reader();
                Comparable[] postingsFreqs = new PostingsAndFreq[PhraseQuery.this.terms.length];
                Terms fieldTerms = reader.terms(this.field);
                if (fieldTerms == null) {
                    return null;
                }
                if (!fieldTerms.hasPositions()) {
                    throw new IllegalStateException("field \"" + this.field + "\" was indexed without position data; cannot run PhraseQuery (phrase=" + String.valueOf(this.getQuery()) + ")");
                }
                TermsEnum te = fieldTerms.iterator();
                float totalMatchCost = 0.0f;
                for (int i = 0; i < PhraseQuery.this.terms.length; ++i) {
                    PostingsEnum postingsEnum;
                    ImpactsEnum impactsEnum;
                    TermState state;
                    Term t = PhraseQuery.this.terms[i];
                    IOSupplier<TermState> supplier = this.states[i].get(context);
                    TermState termState = state = supplier == null ? null : supplier.get();
                    if (state == null) {
                        assert (PhraseQuery.termNotInReader(reader, t)) : "no termstate found but term exists in reader";
                        return null;
                    }
                    te.seekExact(t.bytes(), state);
                    if (this.scoreMode == ScoreMode.TOP_SCORES) {
                        impactsEnum = te.impacts(exposeOffsets ? 56 : 24);
                        postingsEnum = impactsEnum;
                    } else {
                        postingsEnum = te.postings(null, exposeOffsets ? 56 : 24);
                        impactsEnum = new SlowImpactsEnum(postingsEnum);
                    }
                    postingsFreqs[i] = new PostingsAndFreq(postingsEnum, impactsEnum, PhraseQuery.this.positions[i], t);
                    totalMatchCost += PhraseQuery.termPositionsCost(te);
                }
                if (PhraseQuery.this.slop == 0) {
                    ArrayUtil.timSort((Comparable[])postingsFreqs);
                    return new ExactPhraseMatcher((PostingsAndFreq[])postingsFreqs, this.scoreMode, scorer, totalMatchCost);
                }
                return new SloppyPhraseMatcher((PostingsAndFreq[])postingsFreqs, PhraseQuery.this.slop, this.scoreMode, scorer, totalMatchCost, exposeOffsets);
            }
        };
    }

    private static boolean termNotInReader(LeafReader reader, Term term) throws IOException {
        return reader.docFreq(term) == 0;
    }

    @Override
    public String toString(String f) {
        int i;
        StringBuilder buffer = new StringBuilder();
        if (this.field != null && !this.field.equals(f)) {
            buffer.append(this.field);
            buffer.append(":");
        }
        buffer.append("\"");
        int maxPosition = this.positions.length == 0 ? -1 : this.positions[this.positions.length - 1];
        String[] pieces = new String[maxPosition + 1];
        for (i = 0; i < this.terms.length; ++i) {
            int pos = this.positions[i];
            Object s = pieces[pos];
            s = s == null ? this.terms[i].text() : (String)s + "|" + this.terms[i].text();
            pieces[pos] = s;
        }
        for (i = 0; i < pieces.length; ++i) {
            String s;
            if (i > 0) {
                buffer.append(' ');
            }
            if ((s = pieces[i]) == null) {
                buffer.append('?');
                continue;
            }
            buffer.append(s);
        }
        buffer.append("\"");
        if (this.slop != 0) {
            buffer.append("~");
            buffer.append(this.slop);
        }
        return buffer.toString();
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((PhraseQuery)this.getClass().cast(other));
    }

    private boolean equalsTo(PhraseQuery other) {
        return this.slop == other.slop && Arrays.equals(this.terms, other.terms) && Arrays.equals(this.positions, other.positions);
    }

    @Override
    public int hashCode() {
        int h = this.classHash();
        h = 31 * h + this.slop;
        h = 31 * h + Arrays.hashCode(this.terms);
        h = 31 * h + Arrays.hashCode(this.positions);
        return h;
    }

    public static class PostingsAndFreq
    implements Comparable<PostingsAndFreq> {
        final PostingsEnum postings;
        final ImpactsEnum impacts;
        final int position;
        final Term[] terms;
        final int nTerms;

        public PostingsAndFreq(PostingsEnum postings, ImpactsEnum impacts, int position, Term ... terms) {
            this.postings = postings;
            this.impacts = impacts;
            this.position = position;
            int n = this.nTerms = terms == null ? 0 : terms.length;
            if (this.nTerms > 0) {
                if (terms.length == 1) {
                    this.terms = terms;
                } else {
                    Object[] terms2 = new Term[terms.length];
                    System.arraycopy(terms, 0, terms2, 0, terms.length);
                    Arrays.sort(terms2);
                    this.terms = terms2;
                }
            } else {
                this.terms = null;
            }
        }

        @Override
        public int compareTo(PostingsAndFreq other) {
            if (this.position != other.position) {
                return this.position - other.position;
            }
            if (this.nTerms != other.nTerms) {
                return this.nTerms - other.nTerms;
            }
            if (this.nTerms == 0) {
                return 0;
            }
            for (int i = 0; i < this.terms.length; ++i) {
                int res = this.terms[i].compareTo(other.terms[i]);
                if (res == 0) continue;
                return res;
            }
            return 0;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.position;
            for (int i = 0; i < this.nTerms; ++i) {
                result = 31 * result + this.terms[i].hashCode();
            }
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PostingsAndFreq other = (PostingsAndFreq)obj;
            if (this.position != other.position) {
                return false;
            }
            if (this.terms == null) {
                return other.terms == null;
            }
            return Arrays.equals(this.terms, other.terms);
        }
    }

    public static class Builder {
        private int slop = 0;
        private final List<Term> terms = new ArrayList<Term>();
        private final IntArrayList positions = new IntArrayList();

        public Builder setSlop(int slop) {
            this.slop = slop;
            return this;
        }

        public Builder add(Term term, int position) {
            int lastPosition;
            Objects.requireNonNull(term, "Cannot add a null term to PhraseQuery");
            if (position < 0) {
                throw new IllegalArgumentException("Positions must be >= 0, got " + position);
            }
            if (!this.positions.isEmpty() && position < (lastPosition = this.positions.get(this.positions.size() - 1))) {
                throw new IllegalArgumentException("Positions must be added in order, got " + position + " after " + lastPosition);
            }
            if (!this.terms.isEmpty() && !term.field().equals(this.terms.get(0).field())) {
                throw new IllegalArgumentException("All terms must be on the same field, got " + term.field() + " and " + this.terms.get(0).field());
            }
            this.terms.add(term);
            this.positions.add(position);
            return this;
        }

        public PhraseQuery build() {
            Term[] terms = this.terms.toArray(new Term[0]);
            return new PhraseQuery(this.slop, terms, this.positions.toArray());
        }
    }
}

