/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.codecs.hnsw;

import guideme.internal.shaded.lucene.codecs.hnsw.FlatVectorsScorer;
import guideme.internal.shaded.lucene.index.ByteVectorValues;
import guideme.internal.shaded.lucene.index.FloatVectorValues;
import guideme.internal.shaded.lucene.index.KnnVectorValues;
import guideme.internal.shaded.lucene.index.VectorSimilarityFunction;
import guideme.internal.shaded.lucene.util.hnsw.RandomVectorScorer;
import guideme.internal.shaded.lucene.util.hnsw.RandomVectorScorerSupplier;
import java.io.IOException;

public class DefaultFlatVectorScorer
implements FlatVectorsScorer {
    public static final DefaultFlatVectorScorer INSTANCE = new DefaultFlatVectorScorer();

    @Override
    public RandomVectorScorerSupplier getRandomVectorScorerSupplier(VectorSimilarityFunction similarityFunction, KnnVectorValues vectorValues) throws IOException {
        switch (vectorValues.getEncoding()) {
            case FLOAT32: {
                return new FloatScoringSupplier((FloatVectorValues)vectorValues, similarityFunction);
            }
            case BYTE: {
                return new ByteScoringSupplier((ByteVectorValues)vectorValues, similarityFunction);
            }
        }
        throw new IllegalArgumentException("vectorValues must be an instance of FloatVectorValues or ByteVectorValues, got a " + vectorValues.getClass().getName());
    }

    public String toString() {
        return "DefaultFlatVectorScorer()";
    }

    private static final class FloatScoringSupplier
    implements RandomVectorScorerSupplier {
        private final FloatVectorValues vectors;
        private final FloatVectorValues vectors1;
        private final FloatVectorValues vectors2;
        private final VectorSimilarityFunction similarityFunction;

        private FloatScoringSupplier(FloatVectorValues vectors, VectorSimilarityFunction similarityFunction) throws IOException {
            this.vectors = vectors;
            this.vectors1 = vectors.copy();
            this.vectors2 = vectors.copy();
            this.similarityFunction = similarityFunction;
        }

        @Override
        public RandomVectorScorer scorer(final int ord) {
            return new RandomVectorScorer.AbstractRandomVectorScorer(this.vectors){

                @Override
                public float score(int node) throws IOException {
                    return similarityFunction.compare(vectors1.vectorValue(ord), vectors2.vectorValue(node));
                }
            };
        }

        @Override
        public RandomVectorScorerSupplier copy() throws IOException {
            return new FloatScoringSupplier(this.vectors, this.similarityFunction);
        }

        public String toString() {
            return "FloatScoringSupplier(similarityFunction=" + String.valueOf((Object)this.similarityFunction) + ")";
        }
    }

    private static final class ByteScoringSupplier
    implements RandomVectorScorerSupplier {
        private final ByteVectorValues vectors;
        private final ByteVectorValues vectors1;
        private final ByteVectorValues vectors2;
        private final VectorSimilarityFunction similarityFunction;

        private ByteScoringSupplier(ByteVectorValues vectors, VectorSimilarityFunction similarityFunction) throws IOException {
            this.vectors = vectors;
            this.vectors1 = vectors.copy();
            this.vectors2 = vectors.copy();
            this.similarityFunction = similarityFunction;
        }

        @Override
        public RandomVectorScorer scorer(final int ord) {
            return new RandomVectorScorer.AbstractRandomVectorScorer(this.vectors){

                @Override
                public float score(int node) throws IOException {
                    return similarityFunction.compare(vectors1.vectorValue(ord), vectors2.vectorValue(node));
                }
            };
        }

        @Override
        public RandomVectorScorerSupplier copy() throws IOException {
            return new ByteScoringSupplier(this.vectors, this.similarityFunction);
        }

        public String toString() {
            return "ByteScoringSupplier(similarityFunction=" + String.valueOf((Object)this.similarityFunction) + ")";
        }
    }
}

