/*
 * Decompiled with CFR 0.152.
 */
package guideme.libs.micromark;

import guideme.libs.micromark.DefaultExtension;
import guideme.libs.micromark.Extension;
import guideme.libs.micromark.Extensions;
import guideme.libs.micromark.InitialConstruct;
import guideme.libs.micromark.InitializeContent;
import guideme.libs.micromark.InitializeDocument;
import guideme.libs.micromark.InitializeFlow;
import guideme.libs.micromark.InitializeText;
import guideme.libs.micromark.ParseContext;
import guideme.libs.micromark.Preprocessor;
import guideme.libs.micromark.Tokenizer;
import guideme.libs.micromark.commonmark.Subtokenize;
import guideme.libs.micromark.html.ParseOptions;
import java.util.ArrayList;
import java.util.List;

public final class Micromark {
    public static ParseContext parse(List<Extension> extensions) {
        ArrayList<Extension> actualExtensions = new ArrayList<Extension>();
        actualExtensions.add(DefaultExtension.create());
        actualExtensions.addAll(extensions);
        Extension constructs = Extensions.combineExtensions(actualExtensions);
        ParseContext parser = new ParseContext();
        parser.constructs = constructs;
        parser.content = Micromark.create(parser, InitializeContent.content);
        parser.document = Micromark.create(parser, InitializeDocument.document);
        parser.flow = Micromark.create(parser, InitializeFlow.flow);
        parser.string = Micromark.create(parser, InitializeText.string);
        parser.text = Micromark.create(parser, InitializeText.text);
        return parser;
    }

    public static ParseContext.Create create(ParseContext parser, InitialConstruct initial) {
        return from -> Tokenizer.create(parser, initial, from);
    }

    public static List<Tokenizer.Event> parse(String text, ParseOptions options) {
        return Micromark.parse(options.getExtensions()).document.create().write(Preprocessor.preprocess(text, true));
    }

    public static List<Tokenizer.Event> parseAndPostprocess(String text, ParseOptions options) {
        List<Tokenizer.Event> events = Micromark.parse(text, options);
        while (!Subtokenize.subtokenize(events)) {
        }
        return events;
    }
}

