/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.util;

import guideme.internal.shaded.lucene.util.MathUtil;
import guideme.internal.shaded.lucene.util.Sorter;

public abstract class IntroSorter
extends Sorter {
    @Override
    public final void sort(int from, int to) {
        this.checkRange(from, to);
        this.sort(from, to, 2 * MathUtil.log(to - from, 2));
    }

    void sort(int from, int to, int maxDepth) {
        int size;
        while ((size = to - from) > 16) {
            int pivot;
            if (--maxDepth < 0) {
                this.heapSort(from, to);
                return;
            }
            int last = to - 1;
            int mid = from + last >>> 1;
            if (size <= 40) {
                range = size >> 2;
                pivot = this.median(mid - range, mid, mid + range);
            } else {
                range = size >> 3;
                int doubleRange = range << 1;
                int medianFirst = this.median(from, from + range, from + doubleRange);
                int medianMiddle = this.median(mid - range, mid, mid + range);
                int medianLast = this.median(last - doubleRange, last - range, last);
                pivot = this.median(medianFirst, medianMiddle, medianLast);
            }
            this.setPivot(pivot);
            this.swap(from, pivot);
            int i = from;
            int j = to;
            int p = from + 1;
            int q = last;
            while (true) {
                int rightCmp;
                int leftCmp;
                if ((leftCmp = this.comparePivot(++i)) > 0) {
                    continue;
                }
                while ((rightCmp = this.comparePivot(--j)) < 0) {
                }
                if (i >= j) {
                    if (i != j || rightCmp != 0) break;
                    this.swap(i, p);
                    break;
                }
                this.swap(i, j);
                if (rightCmp == 0) {
                    this.swap(i, p++);
                }
                if (leftCmp != 0) continue;
                this.swap(j, q--);
            }
            i = j + 1;
            int k = from;
            while (k < p) {
                this.swap(k++, j--);
            }
            k = last;
            while (k > q) {
                this.swap(k--, i++);
            }
            if (j - from < last - i) {
                this.sort(from, j + 1, maxDepth);
                from = i;
                continue;
            }
            this.sort(i, to, maxDepth);
            to = j + 1;
        }
        this.insertionSort(from, to);
    }

    private int median(int i, int j, int k) {
        if (this.compare(i, j) < 0) {
            if (this.compare(j, k) <= 0) {
                return j;
            }
            return this.compare(i, k) < 0 ? k : i;
        }
        if (this.compare(j, k) >= 0) {
            return j;
        }
        return this.compare(i, k) < 0 ? i : k;
    }

    @Override
    protected abstract void setPivot(int var1);

    @Override
    protected abstract int comparePivot(int var1);

    @Override
    protected int compare(int i, int j) {
        this.setPivot(i);
        return this.comparePivot(j);
    }
}

