/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search.comparators;

import guideme.internal.shaded.lucene.search.FieldComparator;
import guideme.internal.shaded.lucene.search.Pruning;
import guideme.internal.shaded.lucene.util.BytesRef;
import guideme.internal.shaded.lucene.util.BytesRefBuilder;

public class TermOrdValComparator
extends FieldComparator<BytesRef> {
    final int[] ords;
    final BytesRef[] values;
    private final BytesRefBuilder[] tempBRs;
    final int[] readerGen;
    int currentReaderGen = -1;
    private final String field;
    private final boolean reverse;
    private final boolean sortMissingLast;
    int bottomSlot = -1;
    final int missingSortCmp;
    private boolean canSkipDocuments;
    private boolean hitsThresholdReached = false;

    public TermOrdValComparator(int numHits, String field, boolean sortMissingLast, boolean reverse, Pruning pruning) {
        this.canSkipDocuments = pruning != Pruning.NONE;
        this.ords = new int[numHits];
        this.values = new BytesRef[numHits];
        this.tempBRs = new BytesRefBuilder[numHits];
        this.readerGen = new int[numHits];
        this.field = field;
        this.reverse = reverse;
        this.sortMissingLast = sortMissingLast;
        this.missingSortCmp = sortMissingLast ? 1 : -1;
    }

    @Override
    public void disableSkipping() {
        this.canSkipDocuments = false;
    }

    @Override
    public int compareValues(BytesRef val1, BytesRef val2) {
        if (val1 == null) {
            if (val2 == null) {
                return 0;
            }
            return this.missingSortCmp;
        }
        if (val2 == null) {
            return -this.missingSortCmp;
        }
        return val1.compareTo(val2);
    }
}

