/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search;

import guideme.internal.shaded.lucene.search.BooleanClause;
import guideme.internal.shaded.lucene.search.BooleanWeight;
import guideme.internal.shaded.lucene.search.BoostQuery;
import guideme.internal.shaded.lucene.search.ConstantScoreQuery;
import guideme.internal.shaded.lucene.search.IndexSearcher;
import guideme.internal.shaded.lucene.search.MatchAllDocsQuery;
import guideme.internal.shaded.lucene.search.MatchNoDocsQuery;
import guideme.internal.shaded.lucene.search.Multiset;
import guideme.internal.shaded.lucene.search.Query;
import guideme.internal.shaded.lucene.search.QueryVisitor;
import guideme.internal.shaded.lucene.search.ScoreMode;
import guideme.internal.shaded.lucene.search.Weight;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class BooleanQuery
extends Query
implements Iterable<BooleanClause> {
    private final int minimumNumberShouldMatch;
    private final List<BooleanClause> clauses;
    private final Map<BooleanClause.Occur, Collection<Query>> clauseSets;
    private int hashCode;

    private BooleanQuery(int minimumNumberShouldMatch, BooleanClause[] clauses) {
        this.minimumNumberShouldMatch = minimumNumberShouldMatch;
        this.clauses = Collections.unmodifiableList(Arrays.asList(clauses));
        this.clauseSets = new EnumMap<BooleanClause.Occur, Collection<Query>>(BooleanClause.Occur.class);
        this.clauseSets.put(BooleanClause.Occur.SHOULD, new Multiset());
        this.clauseSets.put(BooleanClause.Occur.MUST, new Multiset());
        this.clauseSets.put(BooleanClause.Occur.FILTER, new HashSet());
        this.clauseSets.put(BooleanClause.Occur.MUST_NOT, new HashSet());
        for (BooleanClause clause : clauses) {
            this.clauseSets.get((Object)clause.occur()).add(clause.query());
        }
    }

    public int getMinimumNumberShouldMatch() {
        return this.minimumNumberShouldMatch;
    }

    public List<BooleanClause> clauses() {
        return this.clauses;
    }

    public Collection<Query> getClauses(BooleanClause.Occur occur) {
        return Collections.unmodifiableCollection(this.clauseSets.get((Object)occur));
    }

    boolean isPureDisjunction() {
        return this.clauses.size() == this.getClauses(BooleanClause.Occur.SHOULD).size() && this.minimumNumberShouldMatch <= 1;
    }

    @Override
    public final Iterator<BooleanClause> iterator() {
        return this.clauses.iterator();
    }

    BooleanQuery rewriteNoScoring() {
        boolean actuallyRewritten = false;
        Builder newQuery = new Builder().setMinimumNumberShouldMatch(this.getMinimumNumberShouldMatch());
        boolean keepShould = this.getMinimumNumberShouldMatch() > 0 || this.clauseSets.get((Object)BooleanClause.Occur.MUST).size() + this.clauseSets.get((Object)BooleanClause.Occur.FILTER).size() == 0;
        for (BooleanClause clause : this.clauses) {
            BooleanClause.Occur occur;
            Query query = clause.query();
            Query rewritten = query;
            if (rewritten instanceof BoostQuery) {
                rewritten = ((BoostQuery)rewritten).getQuery();
            }
            if (rewritten instanceof ConstantScoreQuery) {
                rewritten = ((ConstantScoreQuery)rewritten).getQuery();
            }
            if (rewritten instanceof BooleanQuery) {
                rewritten = ((BooleanQuery)rewritten).rewriteNoScoring();
            }
            if ((occur = clause.occur()) == BooleanClause.Occur.SHOULD && !keepShould) {
                actuallyRewritten = true;
                continue;
            }
            if (occur == BooleanClause.Occur.MUST) {
                newQuery.add(rewritten, BooleanClause.Occur.FILTER);
                actuallyRewritten = true;
                continue;
            }
            if (query != rewritten) {
                newQuery.add(rewritten, occur);
                actuallyRewritten = true;
                continue;
            }
            newQuery.add(clause);
        }
        if (!actuallyRewritten) {
            return this;
        }
        return newQuery.build();
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        return new BooleanWeight(this, searcher, scoreMode, boost);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        Query query;
        boolean bl;
        BooleanQuery innerQuery;
        Iterator<BooleanClause> iterator;
        Query query2;
        BoostQuery bq;
        Collection<Query> filters;
        Query rewritten;
        if (this.clauses.size() == 0) {
            return new MatchNoDocsQuery("empty BooleanQuery");
        }
        if (this.clauses.size() == this.clauseSets.get((Object)BooleanClause.Occur.MUST_NOT).size()) {
            return new MatchNoDocsQuery("pure negative BooleanQuery");
        }
        if (this.clauses.size() == 1) {
            BooleanClause c = this.clauses.get(0);
            Query query22 = c.query();
            if (this.minimumNumberShouldMatch == 1 && c.occur() == BooleanClause.Occur.SHOULD) {
                return query22;
            }
            if (this.minimumNumberShouldMatch == 0) {
                switch (c.occur()) {
                    case SHOULD: 
                    case MUST: {
                        return query22;
                    }
                    case FILTER: {
                        return new BoostQuery(new ConstantScoreQuery(query22), 0.0f);
                    }
                }
                throw new AssertionError();
            }
        }
        Builder builder4 = new Builder();
        builder4.setMinimumNumberShouldMatch(this.getMinimumNumberShouldMatch());
        boolean actuallyRewritten = false;
        for (BooleanClause booleanClause : this) {
            Query query3 = booleanClause.query();
            Object occur = booleanClause.occur();
            if (occur == BooleanClause.Occur.FILTER || occur == BooleanClause.Occur.MUST_NOT) {
                rewritten = new ConstantScoreQuery(query3).rewrite(indexSearcher);
                if (rewritten instanceof ConstantScoreQuery) {
                    rewritten = ((ConstantScoreQuery)rewritten).getQuery();
                }
            } else {
                rewritten = query3.rewrite(indexSearcher);
            }
            if (rewritten != query3 || query3.getClass() == MatchNoDocsQuery.class) {
                actuallyRewritten = true;
                if (rewritten.getClass() == MatchNoDocsQuery.class) {
                    switch (occur) {
                        case SHOULD: 
                        case MUST_NOT: {
                            break;
                        }
                        case MUST: 
                        case FILTER: {
                            return rewritten;
                        }
                    }
                    continue;
                }
                builder4.add(rewritten, (BooleanClause.Occur)((Object)occur));
                continue;
            }
            builder4.add(booleanClause);
        }
        if (actuallyRewritten) {
            return builder4.build();
        }
        int clauseCount = 0;
        for (Collection<Query> collection : this.clauseSets.values()) {
            clauseCount += collection.size();
        }
        if (clauseCount != this.clauses.size()) {
            Builder rewritten2 = new Builder();
            rewritten2.setMinimumNumberShouldMatch(this.minimumNumberShouldMatch);
            for (Map.Entry<BooleanClause.Occur, Collection<Query>> entry : this.clauseSets.entrySet()) {
                BooleanClause.Occur occur = entry.getKey();
                for (Object query4 : entry.getValue()) {
                    rewritten2.add((Query)query4, occur);
                }
            }
            return rewritten2.build();
        }
        Collection<Query> mustNotClauses = this.clauseSets.get((Object)BooleanClause.Occur.MUST_NOT);
        if (!mustNotClauses.isEmpty()) {
            Predicate<Query> p = this.clauseSets.get((Object)BooleanClause.Occur.MUST)::contains;
            if (mustNotClauses.stream().anyMatch(p.or(this.clauseSets.get((Object)BooleanClause.Occur.FILTER)::contains))) {
                return new MatchNoDocsQuery("FILTER or MUST clause also in MUST_NOT");
            }
            if (mustNotClauses.contains(new MatchAllDocsQuery())) {
                return new MatchNoDocsQuery("MUST_NOT clause is MatchAllDocsQuery");
            }
        }
        if (this.clauseSets.get((Object)BooleanClause.Occur.FILTER).size() > 0) {
            boolean bl2;
            boolean bl3;
            filters = new HashSet<Query>(this.clauseSets.get((Object)BooleanClause.Occur.FILTER));
            boolean bl4 = false;
            if (filters.size() > 1 || !this.clauseSets.get((Object)BooleanClause.Occur.MUST).isEmpty()) {
                bl3 = filters.remove(new MatchAllDocsQuery());
            }
            if (bl2 = bl3 | filters.removeAll(this.clauseSets.get((Object)BooleanClause.Occur.MUST))) {
                Builder builder = new Builder();
                builder.setMinimumNumberShouldMatch(this.getMinimumNumberShouldMatch());
                for (BooleanClause clause : this.clauses) {
                    if (clause.occur() == BooleanClause.Occur.FILTER) continue;
                    builder.add(clause);
                }
                for (Query filter : filters) {
                    builder.add(filter, BooleanClause.Occur.FILTER);
                }
                return builder.build();
            }
        }
        if (this.clauseSets.get((Object)BooleanClause.Occur.SHOULD).size() > 0 && this.clauseSets.get((Object)BooleanClause.Occur.FILTER).size() > 0) {
            filters = this.clauseSets.get((Object)BooleanClause.Occur.FILTER);
            Collection<Query> collection = this.clauseSets.get((Object)BooleanClause.Occur.SHOULD);
            HashSet<Query> hashSet = new HashSet<Query>(filters);
            hashSet.retainAll(collection);
            if (!hashSet.isEmpty()) {
                Builder builder = new Builder();
                int minShouldMatch = this.getMinimumNumberShouldMatch();
                for (BooleanClause booleanClause : this.clauses) {
                    if (hashSet.contains(booleanClause.query())) {
                        if (booleanClause.occur() != BooleanClause.Occur.SHOULD) continue;
                        builder.add(new BooleanClause(booleanClause.query(), BooleanClause.Occur.MUST));
                        --minShouldMatch;
                        continue;
                    }
                    builder.add(booleanClause);
                }
                builder.setMinimumNumberShouldMatch(Math.max(0, minShouldMatch));
                return builder.build();
            }
        }
        if (this.clauseSets.get((Object)BooleanClause.Occur.SHOULD).size() > 0 && this.minimumNumberShouldMatch <= 1) {
            HashMap<void, Double> shouldClauses = new HashMap<void, Double>();
            for (Query query4 : this.clauseSets.get((Object)BooleanClause.Occur.SHOULD)) {
                void var5_39;
                double d = 1.0;
                while (var5_39 instanceof BoostQuery) {
                    bq = (BoostQuery)var5_39;
                    d *= (double)bq.getBoost();
                    Query query5 = bq.getQuery();
                }
                shouldClauses.put(var5_39, shouldClauses.getOrDefault(var5_39, 0.0) + d);
            }
            if (shouldClauses.size() != this.clauseSets.get((Object)BooleanClause.Occur.SHOULD).size()) {
                Builder builder = new Builder().setMinimumNumberShouldMatch(this.minimumNumberShouldMatch);
                for (Map.Entry entry : shouldClauses.entrySet()) {
                    query2 = (Query)entry.getKey();
                    float boost = ((Double)entry.getValue()).floatValue();
                    if (boost != 1.0f) {
                        query2 = new BoostQuery(query2, boost);
                    }
                    builder.add(query2, BooleanClause.Occur.SHOULD);
                }
                for (BooleanClause booleanClause : this.clauses) {
                    if (booleanClause.occur() == BooleanClause.Occur.SHOULD) continue;
                    builder.add(booleanClause);
                }
                return builder.build();
            }
        }
        if (this.clauseSets.get((Object)BooleanClause.Occur.MUST).size() > 0) {
            HashMap<void, Double> mustClauses = new HashMap<void, Double>();
            for (Query query6 : this.clauseSets.get((Object)BooleanClause.Occur.MUST)) {
                void var5_45;
                double d = 1.0;
                while (var5_45 instanceof BoostQuery) {
                    bq = (BoostQuery)var5_45;
                    d *= (double)bq.getBoost();
                    Query query7 = bq.getQuery();
                }
                mustClauses.put(var5_45, mustClauses.getOrDefault(var5_45, 0.0) + d);
            }
            if (mustClauses.size() != this.clauseSets.get((Object)BooleanClause.Occur.MUST).size()) {
                Builder builder = new Builder().setMinimumNumberShouldMatch(this.minimumNumberShouldMatch);
                for (Map.Entry entry : mustClauses.entrySet()) {
                    query2 = (Query)entry.getKey();
                    float boost = ((Double)entry.getValue()).floatValue();
                    if (boost != 1.0f) {
                        query2 = new BoostQuery(query2, boost);
                    }
                    builder.add(query2, BooleanClause.Occur.MUST);
                }
                for (BooleanClause booleanClause : this.clauses) {
                    if (booleanClause.occur() == BooleanClause.Occur.MUST) continue;
                    builder.add(booleanClause);
                }
                return builder.build();
            }
        }
        Collection<Query> musts = this.clauseSets.get((Object)BooleanClause.Occur.MUST);
        Collection<Query> collection = this.clauseSets.get((Object)BooleanClause.Occur.FILTER);
        if (musts.size() == 1 && collection.size() > 0) {
            void var5_51;
            Query query8 = musts.iterator().next();
            float f = 1.0f;
            if (query8 instanceof BoostQuery) {
                BoostQuery boostQuery = (BoostQuery)query8;
                Query query9 = boostQuery.getQuery();
                f = boostQuery.getBoost();
            }
            if (var5_51.getClass() == MatchAllDocsQuery.class) {
                Builder builder7 = new Builder();
                for (BooleanClause booleanClause : this.clauses) {
                    switch (booleanClause.occur()) {
                        case FILTER: 
                        case MUST_NOT: {
                            builder7.add(booleanClause);
                            break;
                        }
                    }
                }
                rewritten = builder7.build();
                rewritten = new ConstantScoreQuery(rewritten);
                if (f != 1.0f) {
                    rewritten = new BoostQuery(rewritten, f);
                }
                builder7 = new Builder().setMinimumNumberShouldMatch(this.getMinimumNumberShouldMatch()).add(rewritten, BooleanClause.Occur.MUST);
                for (Query query6 : this.clauseSets.get((Object)BooleanClause.Occur.SHOULD)) {
                    builder7.add(query6, BooleanClause.Occur.SHOULD);
                }
                rewritten = builder7.build();
                return rewritten;
            }
        }
        if (this.minimumNumberShouldMatch <= 1) {
            boolean bl5;
            Builder builder2 = new Builder();
            builder2.setMinimumNumberShouldMatch(this.minimumNumberShouldMatch);
            boolean bl6 = false;
            for (BooleanClause booleanClause : this.clauses) {
                if (booleanClause.occur() == BooleanClause.Occur.SHOULD && (iterator = booleanClause.query()) instanceof BooleanQuery) {
                    innerQuery = (BooleanQuery)((Object)iterator);
                    if (innerQuery.isPureDisjunction()) {
                        bl5 = true;
                        iterator = innerQuery.clauses().iterator();
                        while (iterator.hasNext()) {
                            BooleanClause booleanClause2 = (BooleanClause)iterator.next();
                            builder2.add(booleanClause2);
                        }
                        continue;
                    }
                    builder2.add(booleanClause);
                    continue;
                }
                builder2.add(booleanClause);
            }
            if (bl5) {
                return builder2.build();
            }
        }
        Builder builder = new Builder();
        builder.setMinimumNumberShouldMatch(this.minimumNumberShouldMatch);
        boolean bl7 = false;
        for (BooleanClause booleanClause : this.clauses) {
            if (booleanClause.isRequired() && (iterator = booleanClause.query()) instanceof BooleanQuery) {
                innerQuery = (BooleanQuery)((Object)iterator);
                assert (innerQuery.getClauses(BooleanClause.Occur.MUST_NOT).size() != innerQuery.clauses().size());
                if (innerQuery.getMinimumNumberShouldMatch() == 0 && innerQuery.getClauses(BooleanClause.Occur.SHOULD).isEmpty()) {
                    bl = true;
                    iterator = innerQuery.iterator();
                    while (iterator.hasNext()) {
                        BooleanClause booleanClause3 = iterator.next();
                        BooleanClause.Occur innerOccur = booleanClause3.occur();
                        if (innerOccur == BooleanClause.Occur.FILTER || innerOccur == BooleanClause.Occur.MUST_NOT || booleanClause.occur() == BooleanClause.Occur.MUST) {
                            builder.add(booleanClause3);
                            continue;
                        }
                        assert (booleanClause.occur() == BooleanClause.Occur.FILTER && innerOccur == BooleanClause.Occur.MUST);
                        builder.add(booleanClause3.query(), BooleanClause.Occur.FILTER);
                    }
                    continue;
                }
                builder.add(booleanClause);
                continue;
            }
            builder.add(booleanClause);
        }
        if (bl) {
            return builder.build();
        }
        Collection<Query> shoulds = this.clauseSets.get((Object)BooleanClause.Occur.SHOULD);
        if (shoulds.size() < this.minimumNumberShouldMatch) {
            return new MatchNoDocsQuery("SHOULD clause count less than minimumNumberShouldMatch");
        }
        if (shoulds.size() > 0 && shoulds.size() == this.minimumNumberShouldMatch) {
            Builder builder2 = new Builder();
            for (BooleanClause booleanClause : this.clauses) {
                if (booleanClause.occur() == BooleanClause.Occur.SHOULD) {
                    builder2.add(booleanClause.query(), BooleanClause.Occur.MUST);
                    continue;
                }
                builder2.add(booleanClause);
            }
            return builder2.build();
        }
        if (this.clauseSets.get((Object)BooleanClause.Occur.SHOULD).isEmpty() && this.clauseSets.get((Object)BooleanClause.Occur.MUST).size() == 1 && (query = this.clauseSets.get((Object)BooleanClause.Occur.MUST).iterator().next()) instanceof BooleanQuery) {
            BooleanQuery inner = (BooleanQuery)query;
            if (inner.clauses.size() == inner.clauseSets.get((Object)BooleanClause.Occur.SHOULD).size()) {
                Builder builder3 = new Builder();
                for (BooleanClause booleanClause : this.clauses) {
                    if (booleanClause.occur() == BooleanClause.Occur.MUST) continue;
                    builder3.add(booleanClause);
                }
                for (BooleanClause booleanClause : inner.clauses()) {
                    builder3.add(booleanClause);
                }
                builder3.setMinimumNumberShouldMatch(Math.max(1, inner.getMinimumNumberShouldMatch()));
                return builder3.build();
            }
        }
        return super.rewrite(indexSearcher);
    }

    @Override
    public void visit(QueryVisitor visitor) {
        QueryVisitor sub = visitor.getSubVisitor(BooleanClause.Occur.MUST, this);
        for (BooleanClause.Occur occur : this.clauseSets.keySet()) {
            if (this.clauseSets.get((Object)occur).size() <= 0) continue;
            if (occur == BooleanClause.Occur.MUST) {
                for (Query q : this.clauseSets.get((Object)occur)) {
                    q.visit(sub);
                }
                continue;
            }
            QueryVisitor v = sub.getSubVisitor(occur, this);
            for (Query q : this.clauseSets.get((Object)occur)) {
                q.visit(v);
            }
        }
    }

    @Override
    public String toString(String field) {
        boolean needParens;
        StringBuilder buffer = new StringBuilder();
        boolean bl = needParens = this.getMinimumNumberShouldMatch() > 0;
        if (needParens) {
            buffer.append("(");
        }
        int i = 0;
        for (BooleanClause c : this) {
            buffer.append(c.occur().toString());
            Query subQuery = c.query();
            if (subQuery instanceof BooleanQuery) {
                buffer.append("(");
                buffer.append(subQuery.toString(field));
                buffer.append(")");
            } else {
                buffer.append(subQuery.toString(field));
            }
            if (i != this.clauses.size() - 1) {
                buffer.append(" ");
            }
            ++i;
        }
        if (needParens) {
            buffer.append(")");
        }
        if (this.getMinimumNumberShouldMatch() > 0) {
            buffer.append('~');
            buffer.append(this.getMinimumNumberShouldMatch());
        }
        return buffer.toString();
    }

    @Override
    public boolean equals(Object o) {
        return this.sameClassAs(o) && this.equalsTo((BooleanQuery)this.getClass().cast(o));
    }

    private boolean equalsTo(BooleanQuery other) {
        return this.getMinimumNumberShouldMatch() == other.getMinimumNumberShouldMatch() && this.clauseSets.equals(other.clauseSets);
    }

    private int computeHashCode() {
        int hashCode = Objects.hash(this.minimumNumberShouldMatch, this.clauseSets);
        if (hashCode == 0) {
            hashCode = 1;
        }
        return hashCode;
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.computeHashCode();
            assert (this.hashCode != 0);
        }
        assert (this.hashCode == this.computeHashCode());
        return this.hashCode;
    }

    public static class Builder {
        private int minimumNumberShouldMatch;
        private final List<BooleanClause> clauses = new ArrayList<BooleanClause>();

        public Builder setMinimumNumberShouldMatch(int min) {
            this.minimumNumberShouldMatch = min;
            return this;
        }

        public Builder add(BooleanClause clause) {
            if (this.clauses.size() >= IndexSearcher.maxClauseCount) {
                throw new IndexSearcher.TooManyClauses();
            }
            this.clauses.add(clause);
            return this;
        }

        public Builder add(Query query, BooleanClause.Occur occur) {
            return this.add(new BooleanClause(query, occur));
        }

        public BooleanQuery build() {
            return new BooleanQuery(this.minimumNumberShouldMatch, this.clauses.toArray(new BooleanClause[0]));
        }
    }
}

