/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.queries.spans;

import guideme.internal.shaded.lucene.index.LeafReaderContext;
import guideme.internal.shaded.lucene.index.Term;
import guideme.internal.shaded.lucene.index.TermStates;
import guideme.internal.shaded.lucene.index.Terms;
import guideme.internal.shaded.lucene.queries.spans.NearSpansOrdered;
import guideme.internal.shaded.lucene.queries.spans.NearSpansUnordered;
import guideme.internal.shaded.lucene.queries.spans.SpanQuery;
import guideme.internal.shaded.lucene.queries.spans.SpanScorer;
import guideme.internal.shaded.lucene.queries.spans.SpanWeight;
import guideme.internal.shaded.lucene.queries.spans.Spans;
import guideme.internal.shaded.lucene.search.BooleanClause;
import guideme.internal.shaded.lucene.search.IndexSearcher;
import guideme.internal.shaded.lucene.search.Query;
import guideme.internal.shaded.lucene.search.QueryVisitor;
import guideme.internal.shaded.lucene.search.ScoreMode;
import guideme.internal.shaded.lucene.search.ScorerSupplier;
import guideme.internal.shaded.lucene.search.Weight;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SpanNearQuery
extends SpanQuery
implements Cloneable {
    protected List<SpanQuery> clauses;
    protected int slop;
    protected boolean inOrder;
    protected String field;

    public SpanNearQuery(SpanQuery[] clausesIn, int slop, boolean inOrder) {
        this.clauses = new ArrayList<SpanQuery>(clausesIn.length);
        for (SpanQuery clause : clausesIn) {
            if (this.field == null) {
                this.field = clause.getField();
            } else if (clause.getField() != null && !clause.getField().equals(this.field)) {
                throw new IllegalArgumentException("Clauses must have same field.");
            }
            this.clauses.add(clause);
        }
        this.slop = slop;
        this.inOrder = inOrder;
    }

    public SpanQuery[] getClauses() {
        return this.clauses.toArray(new SpanQuery[this.clauses.size()]);
    }

    @Override
    public String getField() {
        return this.field;
    }

    @Override
    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("spanNear([");
        Iterator<SpanQuery> i = this.clauses.iterator();
        while (i.hasNext()) {
            SpanQuery clause = i.next();
            buffer.append(clause.toString(field));
            if (!i.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("], ");
        buffer.append(this.slop);
        buffer.append(", ");
        buffer.append(this.inOrder);
        buffer.append(")");
        return buffer.toString();
    }

    @Override
    public SpanWeight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        ArrayList<SpanWeight> subWeights = new ArrayList<SpanWeight>();
        for (SpanQuery q : this.clauses) {
            subWeights.add(q.createWeight(searcher, scoreMode, boost));
        }
        return new SpanNearWeight(subWeights, searcher, scoreMode.needsScores() ? SpanNearQuery.getTermStates(subWeights) : null, boost);
    }

    @Override
    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        boolean actuallyRewritten = false;
        ArrayList<SpanQuery> rewrittenClauses = new ArrayList<SpanQuery>();
        for (int i = 0; i < this.clauses.size(); ++i) {
            SpanQuery c = this.clauses.get(i);
            SpanQuery query = (SpanQuery)c.rewrite(indexSearcher);
            actuallyRewritten |= query != c;
            rewrittenClauses.add(query);
        }
        if (actuallyRewritten) {
            try {
                SpanNearQuery rewritten = (SpanNearQuery)this.clone();
                rewritten.clauses = rewrittenClauses;
                return rewritten;
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError((Object)e);
            }
        }
        return super.rewrite(indexSearcher);
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (!visitor.acceptField(this.getField())) {
            return;
        }
        QueryVisitor v = visitor.getSubVisitor(BooleanClause.Occur.MUST, this);
        for (SpanQuery clause : this.clauses) {
            clause.visit(v);
        }
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((SpanNearQuery)this.getClass().cast(other));
    }

    private boolean equalsTo(SpanNearQuery other) {
        return this.inOrder == other.inOrder && this.slop == other.slop && this.clauses.equals(other.clauses);
    }

    @Override
    public int hashCode() {
        int result = this.classHash();
        result ^= this.clauses.hashCode();
        int fac = 1 + (this.inOrder ? 8 : 4);
        return fac * (result += this.slop);
    }

    public class SpanNearWeight
    extends SpanWeight {
        final List<SpanWeight> subWeights;

        public SpanNearWeight(List<SpanWeight> subWeights, IndexSearcher searcher, Map<Term, TermStates> terms, float boost) throws IOException {
            super(SpanNearQuery.this, searcher, terms, boost);
            this.subWeights = subWeights;
        }

        @Override
        public void extractTermStates(Map<Term, TermStates> contexts) {
            for (SpanWeight w : this.subWeights) {
                w.extractTermStates(contexts);
            }
        }

        @Override
        public Spans getSpans(LeafReaderContext context, SpanWeight.Postings requiredPostings) throws IOException {
            Terms terms = context.reader().terms(this.field);
            if (terms == null) {
                return null;
            }
            ArrayList<Spans> subSpans = new ArrayList<Spans>(SpanNearQuery.this.clauses.size());
            for (SpanWeight w : this.subWeights) {
                Spans subSpan = w.getSpans(context, requiredPostings);
                if (subSpan != null) {
                    subSpans.add(subSpan);
                    continue;
                }
                return null;
            }
            return !SpanNearQuery.this.inOrder ? new NearSpansUnordered(SpanNearQuery.this.slop, subSpans) : new NearSpansOrdered(SpanNearQuery.this.slop, subSpans);
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            for (Weight weight : this.subWeights) {
                if (weight.isCacheable(ctx)) continue;
                return false;
            }
            return true;
        }

        @Override
        public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
            Spans spans = this.getSpans(context, SpanWeight.Postings.POSITIONS);
            if (spans == null) {
                return null;
            }
            SpanScorer scorer = new SpanScorer(spans, this.getSimScorer(), context.reader().getNormValues(this.field));
            return new Weight.DefaultScorerSupplier(scorer);
        }
    }

    static class GapSpans
    extends Spans {
        int doc;
        int pos;
        final int width;

        @Override
        public int nextStartPosition() throws IOException {
            return ++this.pos;
        }

        public int skipToPosition(int position) throws IOException {
            this.pos = position;
            return this.pos;
        }

        @Override
        public int startPosition() {
            return this.pos;
        }

        @Override
        public int endPosition() {
            return this.pos + this.width;
        }

        @Override
        public int width() {
            return this.width;
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public int nextDoc() throws IOException {
            this.pos = -1;
            return ++this.doc;
        }

        @Override
        public int advance(int target) throws IOException {
            this.pos = -1;
            this.doc = target;
            return this.doc;
        }

        @Override
        public long cost() {
            return 0L;
        }

        @Override
        public float positionsCost() {
            return 0.0f;
        }
    }
}

