/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.index;

import guideme.internal.shaded.lucene.index.DocValuesIterator;
import guideme.internal.shaded.lucene.index.SortedDocValuesTermsEnum;
import guideme.internal.shaded.lucene.index.TermsEnum;
import guideme.internal.shaded.lucene.util.BytesRef;
import java.io.IOException;

public abstract class SortedDocValues
extends DocValuesIterator {
    protected SortedDocValues() {
    }

    public abstract int ordValue() throws IOException;

    public abstract BytesRef lookupOrd(int var1) throws IOException;

    public abstract int getValueCount();

    public int lookupTerm(BytesRef key) throws IOException {
        int low = 0;
        int high = this.getValueCount() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            BytesRef term = this.lookupOrd(mid);
            int cmp = term.compareTo(key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public TermsEnum termsEnum() throws IOException {
        return new SortedDocValuesTermsEnum(this);
    }
}

