/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.index;

import guideme.internal.shaded.lucene.index.DocValuesSkipIndexType;
import guideme.internal.shaded.lucene.index.DocValuesType;
import guideme.internal.shaded.lucene.index.FieldInfo;
import guideme.internal.shaded.lucene.index.IndexOptions;
import guideme.internal.shaded.lucene.index.IndexReader;
import guideme.internal.shaded.lucene.index.LeafReaderContext;
import guideme.internal.shaded.lucene.index.VectorEncoding;
import guideme.internal.shaded.lucene.index.VectorSimilarityFunction;
import guideme.internal.shaded.lucene.internal.hppc.IntObjectHashMap;
import guideme.internal.shaded.lucene.util.CollectionUtil;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class FieldInfos
implements Iterable<FieldInfo> {
    public static final FieldInfos EMPTY = new FieldInfos(new FieldInfo[0]);
    private final boolean hasFreq;
    private final boolean hasPostings;
    private final boolean hasProx;
    private final boolean hasPayloads;
    private final boolean hasOffsets;
    private final boolean hasTermVectors;
    private final boolean hasNorms;
    private final boolean hasDocValues;
    private final boolean hasPointValues;
    private final boolean hasVectorValues;
    private final String softDeletesField;
    private final String parentField;
    private final FieldInfo[] byNumber;
    private final HashMap<String, FieldInfo> byName;
    private final Collection<FieldInfo> values;

    public FieldInfos(FieldInfo[] infos) {
        boolean hasTermVectors = false;
        boolean hasPostings = false;
        boolean hasProx = false;
        boolean hasPayloads = false;
        boolean hasOffsets = false;
        boolean hasFreq = false;
        boolean hasNorms = false;
        boolean hasDocValues = false;
        boolean hasPointValues = false;
        boolean hasVectorValues = false;
        String softDeletesField = null;
        String parentField = null;
        this.byName = CollectionUtil.newHashMap(infos.length);
        int maxFieldNumber = -1;
        boolean fieldNumberStrictlyAscending = true;
        for (FieldInfo info : infos) {
            int fieldNumber = info.number;
            if (fieldNumber < 0) {
                throw new IllegalArgumentException("illegal field number: " + info.number + " for field " + info.name);
            }
            if (maxFieldNumber < fieldNumber) {
                maxFieldNumber = fieldNumber;
            } else {
                fieldNumberStrictlyAscending = false;
            }
            FieldInfo previous = this.byName.put(info.name, info);
            if (previous != null) {
                throw new IllegalArgumentException("duplicate field names: " + previous.number + " and " + info.number + " have: " + info.name);
            }
            hasTermVectors |= info.hasTermVectors();
            hasPostings |= info.getIndexOptions() != IndexOptions.NONE;
            hasProx |= info.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
            hasFreq |= info.getIndexOptions() != IndexOptions.DOCS;
            hasOffsets |= info.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
            hasNorms |= info.hasNorms();
            hasDocValues |= info.getDocValuesType() != DocValuesType.NONE;
            hasPayloads |= info.hasPayloads();
            hasPointValues |= info.getPointDimensionCount() != 0;
            hasVectorValues |= info.getVectorDimension() != 0;
            if (info.isSoftDeletesField()) {
                if (softDeletesField != null && !softDeletesField.equals(info.name)) {
                    throw new IllegalArgumentException("multiple soft-deletes fields [" + info.name + ", " + softDeletesField + "]");
                }
                softDeletesField = info.name;
            }
            if (!info.isParentField()) continue;
            if (parentField != null && !parentField.equals(info.name)) {
                throw new IllegalArgumentException("multiple parent fields [" + info.name + ", " + parentField + "]");
            }
            parentField = info.name;
        }
        this.hasTermVectors = hasTermVectors;
        this.hasPostings = hasPostings;
        this.hasProx = hasProx;
        this.hasPayloads = hasPayloads;
        this.hasOffsets = hasOffsets;
        this.hasFreq = hasFreq;
        this.hasNorms = hasNorms;
        this.hasDocValues = hasDocValues;
        this.hasPointValues = hasPointValues;
        this.hasVectorValues = hasVectorValues;
        this.softDeletesField = softDeletesField;
        this.parentField = parentField;
        if (fieldNumberStrictlyAscending && maxFieldNumber == infos.length - 1) {
            this.byNumber = infos;
            this.values = Arrays.asList(this.byNumber);
        } else {
            this.byNumber = new FieldInfo[maxFieldNumber + 1];
            for (FieldInfo fieldInfo : infos) {
                FieldInfo existing = this.byNumber[fieldInfo.number];
                if (existing != null) {
                    throw new IllegalArgumentException("duplicate field numbers: " + existing.name + " and " + fieldInfo.name + " have: " + fieldInfo.number);
                }
                this.byNumber[fieldInfo.number] = fieldInfo;
            }
            if (maxFieldNumber == infos.length - 1) {
                this.values = Arrays.asList(this.byNumber);
            } else {
                if (!fieldNumberStrictlyAscending) {
                    Arrays.sort(infos, (fi1, fi2) -> Integer.compare(fi1.number, fi2.number));
                }
                this.values = Arrays.asList(infos);
            }
        }
    }

    public static FieldInfos getMergedFieldInfos(IndexReader reader) {
        List<LeafReaderContext> leaves = reader.leaves();
        if (leaves.isEmpty()) {
            return EMPTY;
        }
        if (leaves.size() == 1) {
            return leaves.get(0).reader().getFieldInfos();
        }
        String softDeletesField = leaves.stream().map(l -> l.reader().getFieldInfos().getSoftDeletesField()).filter(Objects::nonNull).findAny().orElse(null);
        String parentField = FieldInfos.getAndValidateParentField(leaves);
        Builder builder = new Builder(new FieldNumbers(softDeletesField, parentField));
        for (LeafReaderContext ctx : leaves) {
            for (FieldInfo fieldInfo : ctx.reader().getFieldInfos()) {
                builder.add(fieldInfo);
            }
        }
        return builder.finish();
    }

    private static String getAndValidateParentField(List<LeafReaderContext> leaves) {
        boolean set = false;
        String theField = null;
        for (LeafReaderContext ctx : leaves) {
            String field = ctx.reader().getFieldInfos().getParentField();
            if (set && !Objects.equals(field, theField)) {
                throw new IllegalStateException("expected parent doc field to be \"" + theField + " \" across all segments but found a segment with different field \"" + field + "\"");
            }
            theField = field;
            set = true;
        }
        return theField;
    }

    public boolean hasFreq() {
        return this.hasFreq;
    }

    public boolean hasPostings() {
        return this.hasPostings;
    }

    public boolean hasProx() {
        return this.hasProx;
    }

    public boolean hasPayloads() {
        return this.hasPayloads;
    }

    public boolean hasOffsets() {
        return this.hasOffsets;
    }

    public boolean hasTermVectors() {
        return this.hasTermVectors;
    }

    public boolean hasNorms() {
        return this.hasNorms;
    }

    public boolean hasDocValues() {
        return this.hasDocValues;
    }

    public boolean hasPointValues() {
        return this.hasPointValues;
    }

    public boolean hasVectorValues() {
        return this.hasVectorValues;
    }

    public String getSoftDeletesField() {
        return this.softDeletesField;
    }

    public String getParentField() {
        return this.parentField;
    }

    public int size() {
        return this.byName.size();
    }

    @Override
    public Iterator<FieldInfo> iterator() {
        return this.values.iterator();
    }

    public FieldInfo fieldInfo(String fieldName) {
        return this.byName.get(fieldName);
    }

    public FieldInfo fieldInfo(int fieldNumber) {
        if (fieldNumber < 0) {
            throw new IllegalArgumentException("Illegal field number: " + fieldNumber);
        }
        return fieldNumber >= this.byNumber.length ? null : this.byNumber[fieldNumber];
    }

    static final class Builder {
        private final HashMap<String, FieldInfo> byName = new HashMap();
        final FieldNumbers globalFieldNumbers;
        private boolean finished;

        Builder(FieldNumbers globalFieldNumbers) {
            assert (globalFieldNumbers != null);
            this.globalFieldNumbers = globalFieldNumbers;
        }

        public String getSoftDeletesFieldName() {
            return this.globalFieldNumbers.softDeletesFieldName;
        }

        public String getParentFieldName() {
            return this.globalFieldNumbers.parentFieldName;
        }

        public FieldInfo add(FieldInfo fi) {
            return this.add(fi, -1L);
        }

        FieldInfo add(FieldInfo fi, long dvGen) {
            FieldInfo curFi = this.fieldInfo(fi.getName());
            if (curFi != null) {
                curFi.verifySameSchema(fi);
                if (fi.attributes() != null) {
                    fi.attributes().forEach((k, v) -> curFi.putAttribute((String)k, (String)v));
                }
                if (fi.hasPayloads()) {
                    curFi.setStorePayloads();
                }
                return curFi;
            }
            assert (this.assertNotFinished());
            int fieldNumber = this.globalFieldNumbers.addOrGet(fi);
            FieldInfo fiNew = new FieldInfo(fi.getName(), fieldNumber, fi.hasTermVectors(), fi.omitsNorms(), fi.hasPayloads(), fi.getIndexOptions(), fi.getDocValuesType(), fi.docValuesSkipIndexType(), dvGen, new HashMap<String, String>(fi.attributes()), fi.getPointDimensionCount(), fi.getPointIndexDimensionCount(), fi.getPointNumBytes(), fi.getVectorDimension(), fi.getVectorEncoding(), fi.getVectorSimilarityFunction(), fi.isSoftDeletesField(), fi.isParentField());
            this.byName.put(fiNew.getName(), fiNew);
            return fiNew;
        }

        public FieldInfo fieldInfo(String fieldName) {
            return this.byName.get(fieldName);
        }

        private boolean assertNotFinished() {
            if (this.finished) {
                throw new IllegalStateException("FieldInfos.Builder was already finished; cannot add new fields");
            }
            return true;
        }

        FieldInfos finish() {
            this.finished = true;
            return new FieldInfos(this.byName.values().toArray(new FieldInfo[this.byName.size()]));
        }
    }

    static final class FieldNumbers {
        private final IntObjectHashMap<String> numberToName = new IntObjectHashMap();
        private final Map<String, FieldProperties> fieldProperties = new HashMap<String, FieldProperties>();
        private int lowestUnassignedFieldNumber = -1;
        private final String softDeletesFieldName;
        private final String parentFieldName;

        FieldNumbers(String softDeletesFieldName, String parentFieldName) {
            this.softDeletesFieldName = softDeletesFieldName;
            this.parentFieldName = parentFieldName;
            if (softDeletesFieldName != null && parentFieldName != null && parentFieldName.equals(softDeletesFieldName)) {
                throw new IllegalArgumentException("parent document and soft-deletes field can't be the same field \"" + parentFieldName + "\"");
            }
        }

        synchronized int addOrGet(FieldInfo fi) {
            String fieldName = fi.getName();
            this.verifySoftDeletedFieldName(fieldName, fi.isSoftDeletesField());
            this.verifyParentFieldName(fieldName, fi.isParentField());
            FieldProperties fieldProperties = this.fieldProperties.get(fieldName);
            if (fieldProperties != null) {
                this.verifySameSchema(fi);
            } else {
                int fieldNumber;
                if (fi.number != -1 && !this.numberToName.containsKey(fi.number)) {
                    fieldNumber = fi.number;
                } else {
                    while (this.numberToName.containsKey(++this.lowestUnassignedFieldNumber)) {
                    }
                    fieldNumber = this.lowestUnassignedFieldNumber;
                }
                assert (fieldNumber >= 0);
                this.numberToName.put(fieldNumber, fieldName);
                fieldProperties = new FieldProperties(fieldNumber, fi.getIndexOptions(), fi.getIndexOptions() != IndexOptions.NONE ? new IndexOptionsProperties(fi.hasTermVectors(), fi.omitsNorms()) : null, fi.getDocValuesType(), fi.docValuesSkipIndexType(), new FieldDimensions(fi.getPointDimensionCount(), fi.getPointIndexDimensionCount(), fi.getPointNumBytes()), new FieldVectorProperties(fi.getVectorDimension(), fi.getVectorEncoding(), fi.getVectorSimilarityFunction()));
                this.fieldProperties.put(fieldName, fieldProperties);
            }
            return fieldProperties.number;
        }

        private void verifySoftDeletedFieldName(String fieldName, boolean isSoftDeletesField) {
            if (isSoftDeletesField) {
                if (this.softDeletesFieldName == null) {
                    throw new IllegalArgumentException("this index has [" + fieldName + "] as soft-deletes already but soft-deletes field is not configured in IWC");
                }
                if (!fieldName.equals(this.softDeletesFieldName)) {
                    throw new IllegalArgumentException("cannot configure [" + this.softDeletesFieldName + "] as soft-deletes; this index uses [" + fieldName + "] as soft-deletes already");
                }
            } else if (fieldName.equals(this.softDeletesFieldName)) {
                throw new IllegalArgumentException("cannot configure [" + this.softDeletesFieldName + "] as soft-deletes; this index uses [" + fieldName + "] as non-soft-deletes already");
            }
        }

        private void verifyParentFieldName(String fieldName, boolean isParentField) {
            if (isParentField) {
                if (this.parentFieldName == null) {
                    throw new IllegalArgumentException("can't add field [" + fieldName + "] as parent document field; this IndexWriter has no parent document field configured");
                }
                if (!fieldName.equals(this.parentFieldName)) {
                    throw new IllegalArgumentException("can't add field [" + fieldName + "] as parent document field; this IndexWriter is configured with [" + this.parentFieldName + "] as parent document field");
                }
            } else if (fieldName.equals(this.parentFieldName)) {
                throw new IllegalArgumentException("can't add [" + fieldName + "] as non parent document field; this IndexWriter is configured with [" + this.parentFieldName + "] as parent document field");
            }
        }

        private void verifySameSchema(FieldInfo fi) {
            String fieldName = fi.getName();
            FieldProperties fieldProperties = this.fieldProperties.get(fieldName);
            IndexOptions currentOpts = fieldProperties.indexOptions;
            FieldInfo.verifySameIndexOptions(fieldName, currentOpts, fi.getIndexOptions());
            if (currentOpts != IndexOptions.NONE) {
                boolean curStoreTermVector = fieldProperties.indexOptionsProperties.storeTermVectors;
                FieldInfo.verifySameStoreTermVectors(fieldName, curStoreTermVector, fi.hasTermVectors());
                boolean curOmitNorms = fieldProperties.indexOptionsProperties.omitNorms;
                FieldInfo.verifySameOmitNorms(fieldName, curOmitNorms, fi.omitsNorms());
            }
            DocValuesType currentDVType = fieldProperties.docValuesType;
            FieldInfo.verifySameDocValuesType(fieldName, currentDVType, fi.getDocValuesType());
            DocValuesSkipIndexType currentDocValuesSkipIndex = fieldProperties.docValuesSkipIndex;
            FieldInfo.verifySameDocValuesSkipIndex(fieldName, currentDocValuesSkipIndex, fi.docValuesSkipIndexType());
            FieldDimensions dims = fieldProperties.fieldDimensions;
            FieldInfo.verifySamePointsOptions(fieldName, dims.dimensionCount, dims.indexDimensionCount, dims.dimensionNumBytes, fi.getPointDimensionCount(), fi.getPointIndexDimensionCount(), fi.getPointNumBytes());
            FieldVectorProperties props = fieldProperties.fieldVectorProperties;
            FieldInfo.verifySameVectorOptions(fieldName, props.numDimensions, props.vectorEncoding, props.similarityFunction, fi.getVectorDimension(), fi.getVectorEncoding(), fi.getVectorSimilarityFunction());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        FieldInfo constructFieldInfo(String fieldName, DocValuesType dvType, int newFieldNumber) {
            FieldProperties fieldProperties;
            FieldNumbers fieldNumbers = this;
            synchronized (fieldNumbers) {
                fieldProperties = this.fieldProperties.get(fieldName);
            }
            if (fieldProperties == null) {
                return null;
            }
            DocValuesType dvType0 = fieldProperties.docValuesType;
            if (dvType != dvType0) {
                return null;
            }
            boolean isSoftDeletesField = fieldName.equals(this.softDeletesFieldName);
            boolean isParentField = fieldName.equals(this.parentFieldName);
            return new FieldInfo(fieldName, newFieldNumber, false, false, false, IndexOptions.NONE, dvType, DocValuesSkipIndexType.NONE, -1L, new HashMap<String, String>(), 0, 0, 0, 0, VectorEncoding.FLOAT32, VectorSimilarityFunction.EUCLIDEAN, isSoftDeletesField, isParentField);
        }

        synchronized Set<String> getFieldNames() {
            return Set.copyOf(this.fieldProperties.keySet());
        }

        synchronized void clear() {
            this.numberToName.clear();
            this.fieldProperties.clear();
            this.lowestUnassignedFieldNumber = -1;
        }
    }

    private static final class FieldProperties
    extends Record {
        private final int number;
        private final IndexOptions indexOptions;
        private final IndexOptionsProperties indexOptionsProperties;
        private final DocValuesType docValuesType;
        private final DocValuesSkipIndexType docValuesSkipIndex;
        private final FieldDimensions fieldDimensions;
        private final FieldVectorProperties fieldVectorProperties;

        private FieldProperties(int number, IndexOptions indexOptions, IndexOptionsProperties indexOptionsProperties, DocValuesType docValuesType, DocValuesSkipIndexType docValuesSkipIndex, FieldDimensions fieldDimensions, FieldVectorProperties fieldVectorProperties) {
            this.number = number;
            this.indexOptions = indexOptions;
            this.indexOptionsProperties = indexOptionsProperties;
            this.docValuesType = docValuesType;
            this.docValuesSkipIndex = docValuesSkipIndex;
            this.fieldDimensions = fieldDimensions;
            this.fieldVectorProperties = fieldVectorProperties;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{FieldProperties.class, "number;indexOptions;indexOptionsProperties;docValuesType;docValuesSkipIndex;fieldDimensions;fieldVectorProperties", "number", "indexOptions", "indexOptionsProperties", "docValuesType", "docValuesSkipIndex", "fieldDimensions", "fieldVectorProperties"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{FieldProperties.class, "number;indexOptions;indexOptionsProperties;docValuesType;docValuesSkipIndex;fieldDimensions;fieldVectorProperties", "number", "indexOptions", "indexOptionsProperties", "docValuesType", "docValuesSkipIndex", "fieldDimensions", "fieldVectorProperties"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{FieldProperties.class, "number;indexOptions;indexOptionsProperties;docValuesType;docValuesSkipIndex;fieldDimensions;fieldVectorProperties", "number", "indexOptions", "indexOptionsProperties", "docValuesType", "docValuesSkipIndex", "fieldDimensions", "fieldVectorProperties"}, this, o);
        }
    }

    private static final class IndexOptionsProperties
    extends Record {
        private final boolean storeTermVectors;
        private final boolean omitNorms;

        private IndexOptionsProperties(boolean storeTermVectors, boolean omitNorms) {
            this.storeTermVectors = storeTermVectors;
            this.omitNorms = omitNorms;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{IndexOptionsProperties.class, "storeTermVectors;omitNorms", "storeTermVectors", "omitNorms"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{IndexOptionsProperties.class, "storeTermVectors;omitNorms", "storeTermVectors", "omitNorms"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{IndexOptionsProperties.class, "storeTermVectors;omitNorms", "storeTermVectors", "omitNorms"}, this, o);
        }
    }

    private static final class FieldVectorProperties
    extends Record {
        private final int numDimensions;
        private final VectorEncoding vectorEncoding;
        private final VectorSimilarityFunction similarityFunction;

        private FieldVectorProperties(int numDimensions, VectorEncoding vectorEncoding, VectorSimilarityFunction similarityFunction) {
            this.numDimensions = numDimensions;
            this.vectorEncoding = vectorEncoding;
            this.similarityFunction = similarityFunction;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{FieldVectorProperties.class, "numDimensions;vectorEncoding;similarityFunction", "numDimensions", "vectorEncoding", "similarityFunction"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{FieldVectorProperties.class, "numDimensions;vectorEncoding;similarityFunction", "numDimensions", "vectorEncoding", "similarityFunction"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{FieldVectorProperties.class, "numDimensions;vectorEncoding;similarityFunction", "numDimensions", "vectorEncoding", "similarityFunction"}, this, o);
        }
    }

    private static final class FieldDimensions
    extends Record {
        private final int dimensionCount;
        private final int indexDimensionCount;
        private final int dimensionNumBytes;

        private FieldDimensions(int dimensionCount, int indexDimensionCount, int dimensionNumBytes) {
            this.dimensionCount = dimensionCount;
            this.indexDimensionCount = indexDimensionCount;
            this.dimensionNumBytes = dimensionNumBytes;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{FieldDimensions.class, "dimensionCount;indexDimensionCount;dimensionNumBytes", "dimensionCount", "indexDimensionCount", "dimensionNumBytes"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{FieldDimensions.class, "dimensionCount;indexDimensionCount;dimensionNumBytes", "dimensionCount", "indexDimensionCount", "dimensionNumBytes"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{FieldDimensions.class, "dimensionCount;indexDimensionCount;dimensionNumBytes", "dimensionCount", "indexDimensionCount", "dimensionNumBytes"}, this, o);
        }
    }
}

