/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.codecs.lucene90;

import guideme.internal.shaded.lucene.codecs.DocValuesConsumer;
import guideme.internal.shaded.lucene.codecs.DocValuesFormat;
import guideme.internal.shaded.lucene.codecs.DocValuesProducer;
import guideme.internal.shaded.lucene.codecs.lucene90.Lucene90DocValuesConsumer;
import guideme.internal.shaded.lucene.codecs.lucene90.Lucene90DocValuesProducer;
import guideme.internal.shaded.lucene.index.SegmentReadState;
import guideme.internal.shaded.lucene.index.SegmentWriteState;
import java.io.IOException;

public final class Lucene90DocValuesFormat
extends DocValuesFormat {
    private final int skipIndexIntervalSize;
    static final long[] SKIP_INDEX_JUMP_LENGTH_PER_LEVEL = new long[4];

    public Lucene90DocValuesFormat() {
        this(4096);
    }

    public Lucene90DocValuesFormat(int skipIndexIntervalSize) {
        super("Lucene90");
        if (skipIndexIntervalSize < 2) {
            throw new IllegalArgumentException("skipIndexIntervalSize must be > 1, got [" + skipIndexIntervalSize + "]");
        }
        this.skipIndexIntervalSize = skipIndexIntervalSize;
    }

    @Override
    public DocValuesConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        return new Lucene90DocValuesConsumer(state, this.skipIndexIntervalSize, "Lucene90DocValuesData", "dvd", "Lucene90DocValuesMetadata", "dvm");
    }

    @Override
    public DocValuesProducer fieldsProducer(SegmentReadState state) throws IOException {
        return new Lucene90DocValuesProducer(state, "Lucene90DocValuesData", "dvd", "Lucene90DocValuesMetadata", "dvm");
    }

    static {
        Lucene90DocValuesFormat.SKIP_INDEX_JUMP_LENGTH_PER_LEVEL[0] = 24L;
        for (int level = 1; level < 4; ++level) {
            Lucene90DocValuesFormat.SKIP_INDEX_JUMP_LENGTH_PER_LEVEL[level] = SKIP_INDEX_JUMP_LENGTH_PER_LEVEL[level - 1];
            int n = level;
            SKIP_INDEX_JUMP_LENGTH_PER_LEVEL[n] = SKIP_INDEX_JUMP_LENGTH_PER_LEVEL[n] + (long)(1 << level * 3) * 29L;
            int n2 = level;
            SKIP_INDEX_JUMP_LENGTH_PER_LEVEL[n2] = SKIP_INDEX_JUMP_LENGTH_PER_LEVEL[n2] - (long)(1 << (level - 1) * 3);
        }
    }
}

