/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.analysis.util;

public class OpenStringBuilder
implements Appendable,
CharSequence {
    protected char[] buf;
    protected int len;

    public OpenStringBuilder() {
        this(32);
    }

    public OpenStringBuilder(int size) {
        this.buf = new char[size];
    }

    public void setLength(int len) {
        this.len = len;
    }

    public char[] getArray() {
        return this.buf;
    }

    public int size() {
        return this.len;
    }

    @Override
    public int length() {
        return this.len;
    }

    @Override
    public Appendable append(CharSequence csq) {
        return this.append(csq, 0, csq.length());
    }

    @Override
    public Appendable append(CharSequence csq, int start, int end) {
        this.reserve(end - start);
        for (int i = start; i < end; ++i) {
            this.unsafeWrite(csq.charAt(i));
        }
        return this;
    }

    @Override
    public Appendable append(char c) {
        this.write(c);
        return this;
    }

    @Override
    public char charAt(int index) {
        return this.buf[index];
    }

    public void setCharAt(int index, char ch) {
        this.buf[index] = ch;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        throw new UnsupportedOperationException();
    }

    public void unsafeWrite(char b) {
        this.buf[this.len++] = b;
    }

    protected void resize(int len) {
        char[] newbuf = new char[Math.max(this.buf.length << 1, len)];
        System.arraycopy(this.buf, 0, newbuf, 0, this.size());
        this.buf = newbuf;
    }

    public void reserve(int num) {
        if (this.len + num > this.buf.length) {
            this.resize(this.len + num);
        }
    }

    public void write(char b) {
        if (this.len >= this.buf.length) {
            this.resize(this.len + 1);
        }
        this.unsafeWrite(b);
    }

    public final void reset() {
        this.len = 0;
    }

    @Override
    public String toString() {
        return new String(this.buf, 0, this.size());
    }
}

