/*
 * Decompiled with CFR 0.152.
 */
package guideme.libs.micromark.factory;

import guideme.libs.micromark.Assert;
import guideme.libs.micromark.CharUtil;
import guideme.libs.micromark.ContentType;
import guideme.libs.micromark.State;
import guideme.libs.micromark.Token;
import guideme.libs.micromark.TokenizeContext;
import guideme.libs.micromark.Tokenizer;

public final class FactoryLabel {
    public static State create(TokenizeContext context, Tokenizer.Effects effects, State ok, State nok, String type, String markerType, String stringType) {
        return new StateMachine(context, effects, ok, nok, type, markerType, stringType)::start;
    }

    private static class StateMachine {
        private TokenizeContext context;
        private Tokenizer.Effects effects;
        private State ok;
        private State nok;
        private String type;
        private String markerType;
        private String stringType;
        private int size = 0;
        private boolean data;

        public StateMachine(TokenizeContext context, Tokenizer.Effects effects, State ok, State nok, String type, String markerType, String stringType) {
            this.context = context;
            this.effects = effects;
            this.ok = ok;
            this.nok = nok;
            this.type = type;
            this.markerType = markerType;
            this.stringType = stringType;
        }

        private State start(int code) {
            Assert.check(code == 91, "expected `[`");
            this.effects.enter(this.type);
            this.effects.enter(this.markerType);
            this.effects.consume(code);
            this.effects.exit(this.markerType);
            this.effects.enter(this.stringType);
            return this::atBreak;
        }

        private State atBreak(int code) {
            if (code == Integer.MIN_VALUE || code == 91 || code == 93 && !this.data || code == 94 && this.size == 0 && this.context.getParser().constructs._hiddenFootnoteSupport || this.size > 999) {
                return this.nok.step(code);
            }
            if (code == 93) {
                this.effects.exit(this.stringType);
                this.effects.enter(this.markerType);
                this.effects.consume(code);
                this.effects.exit(this.markerType);
                this.effects.exit(this.type);
                return this.ok;
            }
            if (CharUtil.markdownLineEnding(code)) {
                this.effects.enter("lineEnding");
                this.effects.consume(code);
                this.effects.exit("lineEnding");
                return this::atBreak;
            }
            Token tokenFields = new Token();
            tokenFields.contentType = ContentType.STRING;
            this.effects.enter("chunkString", tokenFields);
            return this.label(code);
        }

        private State label(int code) {
            if (code == Integer.MIN_VALUE || code == 91 || code == 93 || CharUtil.markdownLineEnding(code) || this.size++ > 999) {
                this.effects.exit("chunkString");
                return this.atBreak(code);
            }
            this.effects.consume(code);
            this.data = this.data || !CharUtil.markdownSpace(code);
            return code == 92 ? this::labelEscape : this::label;
        }

        private State labelEscape(int code) {
            if (code == 91 || code == 92 || code == 93) {
                this.effects.consume(code);
                ++this.size;
                return this::label;
            }
            return this.label(code);
        }
    }
}

