/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.util;

import guideme.compiler.FrontmatterNavigation;
import guideme.compiler.ParsedGuidePage;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NavigationUtil {
    private static final Logger LOG = LoggerFactory.getLogger(NavigationUtil.class);

    private NavigationUtil() {
    }

    public static ItemStack createNavigationIcon(ParsedGuidePage page) {
        FrontmatterNavigation navigation = page.getFrontmatter().navigationEntry();
        ItemStack icon = ItemStack.EMPTY;
        if (navigation != null && navigation.iconItemId() != null) {
            Item iconItem = BuiltInRegistries.ITEM.getOptional(navigation.iconItemId()).orElse(null);
            if (iconItem != null) {
                if (navigation.iconNbt() != null) {
                    icon = new ItemStack((ItemLike)iconItem);
                    icon.setTag(navigation.iconNbt());
                } else {
                    icon = new ItemStack((ItemLike)iconItem);
                }
            }
            if (icon.isEmpty()) {
                LOG.error("Couldn't find icon {} for icon of page {}", (Object)navigation.iconItemId(), (Object)page);
            }
        }
        return icon;
    }
}

